/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.dht;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import io.ktor.client.engine.HttpClientEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import web5.sdk.common.Convert;
import web5.sdk.common.EncodingFormat;
import web5.sdk.common.ZBase32;
import web5.sdk.crypto.AlgorithmId;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.Ed25519;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.Secp256k1;
import web5.sdk.dids.DidMethod;
import web5.sdk.dids.DidMethodKt;
import web5.sdk.dids.DidResolutionMetadata;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.ResolutionError;
import web5.sdk.dids.ResolveDidOptions;
import web5.sdk.dids.didcore.DIDDocument;
import web5.sdk.dids.didcore.DIDDocumentMetadata;
import web5.sdk.dids.didcore.DidUri;
import web5.sdk.dids.didcore.Purpose;
import web5.sdk.dids.didcore.Service;
import web5.sdk.dids.didcore.VerificationMethod;
import web5.sdk.dids.exceptions.InvalidIdentifierException;
import web5.sdk.dids.exceptions.InvalidIdentifierSizeException;
import web5.sdk.dids.exceptions.InvalidMethodNameException;
import web5.sdk.dids.exceptions.PkarrRecordNotFoundException;
import web5.sdk.dids.exceptions.PublicKeyJwkMissingException;
import web5.sdk.dids.methods.dht.Bep44Message;
import web5.sdk.dids.methods.dht.CreateDidDhtOptions;
import web5.sdk.dids.methods.dht.DIDDhtDocumentMetadata;
import web5.sdk.dids.methods.dht.DhtClient;
import web5.sdk.dids.methods.dht.DidDht;
import web5.sdk.dids.methods.dht.DidDhtConfiguration;
import web5.sdk.dids.methods.dht.DidDhtKt;
import web5.sdk.dids.methods.dht.DidDhtTypeIndexing;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J6\u0010\u0018\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001b0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0016J/\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001a0\u00192\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J,\u00100\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010-\u001a\u00020.H\u0002J<\u00102\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\f2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f032\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020.H\u0002J\u0018\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u00108\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u00109\u001a\u00020\fH\u0002J*\u0010:\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0010\b\u0002\u0010<\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001aH\u0007J\u001a\u0010=\u001a\u00020>2\u0006\u0010\"\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010@\u001a\u00020>2\u0006\u0010\"\u001a\u00020\fH\u0002J\u000e\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\fJ'\u0010C\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0010\b\u0002\u0010<\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u001aH\u0001\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bFJ\u001d\u0010G\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bHR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002IJ\u00a8\u0006K"}, d2={"Lweb5/sdk/dids/methods/dht/DidDhtApi;", "Lweb5/sdk/dids/DidMethod;", "Lweb5/sdk/dids/methods/dht/DidDht;", "Lweb5/sdk/dids/methods/dht/CreateDidDhtOptions;", "configuration", "Lweb5/sdk/dids/methods/dht/DidDhtConfiguration;", "(Lweb5/sdk/dids/methods/dht/DidDhtConfiguration;)V", "dhtClient", "Lweb5/sdk/dids/methods/dht/DhtClient;", "engine", "Lio/ktor/client/engine/HttpClientEngine;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "ttl", "", "addAlsoKnownAsRecord", "", "didDocument", "Lweb5/sdk/dids/didcore/DIDDocument;", "message", "Lorg/xbill/DNS/Message;", "addControllerRecord", "addVerificationMethodRecords", "Lkotlin/Pair;", "", "", "create", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "fromDnsPacket", "Lweb5/sdk/dids/methods/dht/DidDhtTypeIndexing;", "did", "msg", "fromDnsPacket$dids", "getDidIdentifier", "identityKey", "Lcom/nimbusds/jose/jwk/JWK;", "getDidIdentifier$dids", "getIdentityKid", "handleAlsoKnownAsRecord", "rr", "Lorg/xbill/DNS/TXTRecord;", "doc", "Lweb5/sdk/dids/didcore/DIDDocument$Builder;", "handleControllerRecord", "handleRootRecord", "keyLookup", "handleVerificationMethods", "", "name", "didDocBuilder", "load", "uri", "parseTxtData", "data", "publish", "manager", "types", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "Lweb5/sdk/dids/ResolveDidOptions;", "resolveInternal", "suffix", "id", "toDnsPacket", "toDnsPacket$dids", "validate", "validate$dids", "validateIdentityKey", "validateIdentityKey$dids", "Lweb5/sdk/dids/methods/dht/DidDht$Default;", "Lweb5/sdk/dids/methods/dht/DidDhtApiImpl;", "dids"})
@SourceDebugExtension(value={"SMAP\nDidDht.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidDht.kt\nweb5/sdk/dids/methods/dht/DidDhtApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,732:1\n1549#2:733\n1620#2,2:734\n1622#2:737\n1549#2:738\n1620#2,3:739\n1549#2:742\n1620#2,3:743\n1864#2,3:746\n1549#2:749\n1620#2,3:750\n1549#2:753\n1620#2,3:754\n1549#2:757\n1620#2,3:758\n1549#2:761\n1620#2,3:762\n1549#2:765\n1620#2,3:766\n1549#2:769\n1620#2,3:770\n1864#2,3:773\n1855#2:776\n1549#2:777\n1620#2,3:778\n1856#2:781\n1855#2:782\n1855#2,2:783\n1856#2:785\n1179#2,2:786\n1253#2,4:788\n1#3:736\n*S KotlinDebug\n*F\n+ 1 DidDht.kt\nweb5/sdk/dids/methods/dht/DidDhtApi\n*L\n142#1:733\n142#1:734,2\n142#1:737\n181#1:738\n181#1:739,3\n245#1:742\n245#1:743,3\n368#1:746,3\n393#1:749\n393#1:750,3\n397#1:753\n397#1:754,3\n401#1:757\n401#1:758,3\n405#1:761\n405#1:762,3\n409#1:765\n409#1:766,3\n423#1:769\n423#1:770,3\n438#1:773,3\n517#1:776\n541#1:777\n541#1:778,3\n517#1:781\n628#1:782\n632#1:783,2\n628#1:785\n650#1:786,2\n650#1:788,4\n*E\n"})
public abstract class DidDhtApi
implements DidMethod<DidDht, CreateDidDhtOptions> {
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final DhtClient dhtClient;
    private final long ttl;
    @NotNull
    private final String methodName;

    private DidDhtApi(DidDhtConfiguration configuration) {
        this.engine = configuration.getEngine();
        this.dhtClient = new DhtClient(configuration.getGateway(), this.engine);
        this.ttl = 7200L;
        this.methodName = "dht";
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DidDht create(@NotNull KeyManager keyManager, @Nullable CreateDidDhtOptions options) {
        Iterable<String> it;
        List list;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        CreateDidDhtOptions createDidDhtOptions = options;
        if (createDidDhtOptions == null) {
            createDidDhtOptions = new CreateDidDhtOptions(null, null, false, null, null, 31, null);
        }
        CreateDidDhtOptions opts = createDidDhtOptions;
        String keyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (AlgorithmId)AlgorithmId.Ed25519, null, (int)2, null);
        JWK publicKey = keyManager.getPublicKey(keyAlias);
        String id = DidDht.Default.getDidIdentifier$dids(publicKey);
        Iterable<Service> iterable = opts.getServices();
        if (iterable != null) {
            void $this$mapTo$iv$iv;
            Iterable<Service> $this$map$iv = iterable;
            boolean $i$f$map = false;
            Iterable<Service> iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void service;
                Service service2 = (Service)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                if (service.getId() == null) {
                    boolean $i$a$-requireNotNull-DidDhtApi$create$services$1$42 = false;
                    String $i$a$-requireNotNull-DidDhtApi$create$services$1$42 = "Service id cannot be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DidDhtApi$create$services$1$42.toString());
                }
                if (service.getType() == null) {
                    boolean $i$a$-requireNotNull-DidDhtApi$create$services$1$52 = false;
                    String $i$a$-requireNotNull-DidDhtApi$create$services$1$52 = "Service type cannot be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DidDhtApi$create$services$1$52.toString());
                }
                if (service.getServiceEndpoint() == null) {
                    boolean bl2 = false;
                    String string = "Service serviceEndpoint cannot be null";
                    throw new IllegalArgumentException(string.toString());
                }
                collection.add(new Service(id + "#" + service.getId(), service.getType(), service.getServiceEndpoint()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List services = list;
        DIDDocument.Builder didDocumentBuilder = new DIDDocument.Builder().id(id).services(services);
        Iterable<String> iterable3 = opts.getControllers();
        if (iterable3 != null) {
            it = iterable3;
            boolean bl = false;
            didDocumentBuilder.controllers(CollectionsKt.toList(it));
        }
        Iterable<String> iterable4 = opts.getAlsoKnownAses();
        if (iterable4 != null) {
            it = iterable4;
            boolean bl = false;
            didDocumentBuilder.alsoKnownAses(CollectionsKt.toList(it));
        }
        VerificationMethod identityVerificationMethod = new VerificationMethod(id + "#0", "JsonWebKey", id, publicKey.toPublicJWK());
        Object[] $i$f$map = new Purpose[]{Purpose.AssertionMethod, Purpose.Authentication, Purpose.CapabilityDelegation, Purpose.CapabilityInvocation};
        didDocumentBuilder.verificationMethodForPurposes(identityVerificationMethod, CollectionsKt.listOf((Object[])$i$f$map));
        Iterable<Triple<JWK, List<Purpose>, String>> iterable5 = opts.getVerificationMethods();
        if (iterable5 != null) {
            void $this$mapTo$iv$iv;
            Iterable<Triple<JWK, List<Purpose>, String>> $this$map$iv = iterable5;
            boolean $i$f$map2 = false;
            Iterable<Triple<JWK, List<Purpose>, String>> $i$f$mapTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VerificationMethod verificationMethod;
                Triple triple = (Triple)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                JWK key = (JWK)triple.component1();
                List purposes = (List)triple.component2();
                String controller = (String)triple.component3();
                VerificationMethod.Builder builder = new VerificationMethod.Builder().id(id + "#" + key.getKeyID()).type("JsonWebKey");
                String string = controller;
                if (string == null) {
                    string = id;
                }
                VerificationMethod.Builder builder2 = builder.controller(string);
                JWK jWK = key.toPublicJWK();
                Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"toPublicJWK(...)");
                VerificationMethod verificationMethod2 = verificationMethod = builder2.publicKeyJwk(jWK).build();
                boolean bl3 = false;
                didDocumentBuilder.verificationMethodForPurposes(verificationMethod2, CollectionsKt.toList((Iterable)purposes));
                collection.add(verificationMethod);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        DIDDocument didDocument = didDocumentBuilder.build();
        if (opts.getPublish()) {
            DidDhtApi.publish$default(this, keyManager, didDocument, null, 4, null);
        }
        return new DidDht(id, keyManager, didDocument, this);
    }

    @Override
    @NotNull
    public DidResolutionResult resolve(@NotNull String did, @Nullable ResolveDidOptions options) {
        DidResolutionResult didResolutionResult;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        try {
            didResolutionResult = this.resolveInternal(did);
        }
        catch (Exception e) {
            DidDhtKt.access$getLogger$p().warn((Throwable)e, (Function0)new Function0<Object>(did){
                final /* synthetic */ String $did;
                {
                    this.$did = $did;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "resolving DID " + this.$did + " failed";
                }
            });
            didResolutionResult = DidResolutionResult.Companion.fromResolutionError(ResolutionError.INTERNAL_ERROR);
        }
        return didResolutionResult;
    }

    /*
     * WARNING - void declaration
     */
    private final DidResolutionResult resolveInternal(String did) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Bep44Message bep44Message;
        try {
            this.validate$dids(did);
        }
        catch (InvalidMethodNameException invalidMethodNameException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.METHOD_NOT_SUPPORTED);
        }
        catch (InvalidIdentifierSizeException invalidIdentifierSizeException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.INVALID_DID);
        }
        catch (InvalidIdentifierException invalidIdentifierException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.INVALID_DID);
        }
        String getId = DidDht.Default.suffix(did);
        try {
            bep44Message = this.dhtClient.pkarrGet(getId);
        }
        catch (PkarrRecordNotFoundException pkarrRecordNotFoundException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.NOT_FOUND);
        }
        Bep44Message bep44Message2 = bep44Message;
        Message dnsPacket = DhtClient.Companion.parseBep44GetResponse(bep44Message2);
        Pair<DIDDocument, List<DidDhtTypeIndexing>> pair = this.fromDnsPacket$dids(did, dnsPacket);
        boolean bl = false;
        DIDDocument didDocument = (DIDDocument)pair.component1();
        List types = (List)pair.component2();
        Iterable iterable = types;
        DIDDocument dIDDocument = didDocument;
        String string = null;
        boolean $i$f$map = false;
        void var14_17 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DidDhtTypeIndexing didDhtTypeIndexing = (DidDhtTypeIndexing)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getIndex());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 9;
        DidResolutionMetadata didResolutionMetadata = null;
        DIDDocumentMetadata dIDDocumentMetadata = new DIDDhtDocumentMetadata(list);
        DIDDocument dIDDocument2 = dIDDocument;
        String string2 = string;
        return new DidResolutionResult(string2, dIDDocument2, dIDDocumentMetadata, didResolutionMetadata, n, defaultConstructorMarker);
    }

    @JvmOverloads
    public final void publish(@NotNull KeyManager manager, @NotNull DIDDocument didDocument, @Nullable List<? extends DidDhtTypeIndexing> types) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        this.validate$dids(didDocument.getId());
        String publishId = DidDht.Default.suffix(didDocument.getId());
        Message dnsPacket = this.toDnsPacket$dids(didDocument, types);
        Bep44Message bep44Message = DhtClient.Companion.createBep44PutRequest(manager, this.getIdentityKid(didDocument), dnsPacket);
        this.dhtClient.pkarrPut(publishId, bep44Message);
    }

    public static /* synthetic */ void publish$default(DidDhtApi didDhtApi, KeyManager keyManager, DIDDocument dIDDocument, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publish");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        didDhtApi.publish(keyManager, dIDDocument, list);
    }

    @NotNull
    public final String suffix(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String[] stringArray = new String[]{":"};
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)id, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final String getIdentityKid(DIDDocument didDocument) {
        this.validate$dids(didDocument.getId());
        List<VerificationMethod> list = didDocument.getVerificationMethod();
        if (list == null || (list = (VerificationMethod)CollectionsKt.first(list)) == null || (list = ((VerificationMethod)((Object)list)).getPublicKeyJwk()) == null) {
            throw new PublicKeyJwkMissingException("publicKeyJwk is null");
        }
        List<VerificationMethod> publicKeyJwk = list;
        String string = publicKeyJwk.getKeyID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyID(...)");
        return string;
    }

    @Override
    @NotNull
    public DidDht load(@NotNull String uri, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        DidMethodKt.validateKeyMaterialInsideKeyManager(this, uri, keyManager);
        this.validateIdentityKey$dids(uri, keyManager);
        return new DidDht(uri, keyManager, null, this);
    }

    public final void validateIdentityKey$dids(@NotNull String did, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        DidUri parsedDidUri = DidUri.Parser.parse(did);
        byte[] decodedId = ZBase32.INSTANCE.decode(parsedDidUri.getId());
        if (!(decodedId.length == 32)) {
            boolean $i$a$-require-DidDhtApi$validateIdentityKey$22 = false;
            String $i$a$-require-DidDhtApi$validateIdentityKey$22 = "expected size of decoded identifier " + parsedDidUri.getId() + " to be 32";
            throw new IllegalArgumentException($i$a$-require-DidDhtApi$validateIdentityKey$22.toString());
        }
        JWK publicKeyJwk = Ed25519.INSTANCE.bytesToPublicKey(decodedId);
        String identityKeyAlias = keyManager.getDeterministicAlias(publicKeyJwk);
        keyManager.getPublicKey(identityKeyAlias);
    }

    @NotNull
    public final String getDidIdentifier$dids(@NotNull JWK identityKey) {
        Intrinsics.checkNotNullParameter((Object)identityKey, (String)"identityKey");
        JWK publicKeyJwk = identityKey.toPublicJWK();
        Intrinsics.checkNotNull((Object)publicKeyJwk);
        byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKeyJwk);
        String zBase32Encoded = ZBase32.INSTANCE.encode(publicKeyBytes);
        return "did:dht:" + zBase32Encoded;
    }

    public final void validate$dids(@NotNull String did) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        DidUri parsedDidUri = DidUri.Parser.parse(did);
        if (!Intrinsics.areEqual((Object)parsedDidUri.getMethod(), (Object)DidDht.Default.getMethodName())) {
            boolean bl = false;
            throw new InvalidMethodNameException("expected method to be dht");
        }
        try {
            byArray = ZBase32.INSTANCE.decode(parsedDidUri.getId());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidIdentifierException("expected method-specific identifier to be z-base-32 encoded", e);
        }
        byte[] decodedId = byArray;
        if (!(decodedId.length == 32)) {
            boolean bl = false;
            throw new InvalidIdentifierSizeException("expected size of decoded identifier to be 32");
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Message toDnsPacket$dids(@NotNull DIDDocument didDocument, @Nullable List<? extends DidDhtTypeIndexing> types) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object it;
        String it2;
        Collection collection;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Object object5;
        Iterable service;
        Iterable $this$forEachIndexed$iv;
        Pair<List<String>, Map<String, String>> pair;
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        Pair<List<String>, Map<String, String>> $this$toDnsPacket_u24lambda_u2413 = pair = new Pair<List<String>, Map<String, String>>(0);
        boolean bl = false;
        $this$toDnsPacket_u24lambda_u2413.getHeader().setFlag(5);
        Pair<List<String>, Map<String, String>> message = pair;
        pair = this.addVerificationMethodRecords(didDocument, (Message)message);
        List verificationMethodIds = (List)pair.component1();
        Map verificationMethodsById = (Map)pair.component2();
        List serviceIds = new ArrayList();
        List<Service> list = didDocument.getService();
        if (list != null) {
            $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Service service2 = (Service)item$iv;
                int i = n;
                boolean bl2 = false;
                Iterator sId = "s" + i;
                Object[] objectArray = new String[]{"id=" + ((Service)((Object)service)).getId(), "t=" + ((Service)((Object)service)).getType(), "se=" + CollectionsKt.joinToString$default((Iterable)((Service)((Object)service)).getServiceEndpoint(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)};
                message.addRecord((Record)new TXTRecord(new Name("_" + (String)((Object)sId) + "._did."), 1, this.ttl, CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
                ((Collection)serviceIds).add(sId);
            }
        }
        List<String> list2 = didDocument.getController();
        if (list2 != null) {
            List<String> it3 = list2;
            boolean bl3 = false;
            this.addControllerRecord(didDocument, (Message)message);
        }
        List<String> list3 = didDocument.getAlsoKnownAs();
        if (list3 != null) {
            List<String> it4 = list3;
            boolean bl4 = false;
            this.addAlsoKnownAsRecord(didDocument, (Message)message);
        }
        Iterable $this$toDnsPacket_u24lambda_u2427 = $this$forEachIndexed$iv = (List)new ArrayList();
        boolean bl5 = false;
        if (!((Collection)verificationMethodIds).isEmpty()) {
            $this$toDnsPacket_u24lambda_u2427.add("vm=" + CollectionsKt.joinToString$default((Iterable)verificationMethodIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)serviceIds).isEmpty()) {
            $this$toDnsPacket_u24lambda_u2427.add("svc=" + CollectionsKt.joinToString$default((Iterable)serviceIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if ((object5 = didDocument.getAuthentication()) != null) {
            $this$map$iv = (Iterable)object5;
            $i$f$map = false;
            service = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object5 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object5 != null) {
                it = object5;
                boolean bl7 = false;
                $this$toDnsPacket_u24lambda_u2427.add("auth=" + (String)it);
            }
        }
        if ((object4 = didDocument.getAssertionMethod()) != null) {
            $this$map$iv = (Iterable)object4;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object4 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object4 != null) {
                it = object4;
                boolean bl9 = false;
                $this$toDnsPacket_u24lambda_u2427.add("asm=" + (String)it);
            }
        }
        if ((object3 = didDocument.getKeyAgreement()) != null) {
            $this$map$iv = (Iterable)object3;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl10 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object3 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object3 != null) {
                it = object3;
                boolean bl11 = false;
                $this$toDnsPacket_u24lambda_u2427.add("agm=" + (String)it);
            }
        }
        if ((object2 = didDocument.getCapabilityInvocation()) != null) {
            $this$map$iv = (Iterable)object2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl12 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object2 != null) {
                it = object2;
                boolean bl13 = false;
                $this$toDnsPacket_u24lambda_u2427.add("inv=" + (String)it);
            }
        }
        if ((object = didDocument.getCapabilityDelegation()) != null) {
            $this$map$iv = (Iterable)object;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl14 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object != null) {
                it = object;
                boolean bl15 = false;
                $this$toDnsPacket_u24lambda_u2427.add("del=" + (String)it);
            }
        }
        Iterable rootRecordText = $this$forEachIndexed$iv;
        message.addRecord((Record)new TXTRecord(new Name("_did."), 1, this.ttl, CollectionsKt.joinToString$default((Iterable)rootRecordText, (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
        if (types != null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = types;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it5;
                DidDhtTypeIndexing $i$f$mapTo3 = (DidDhtTypeIndexing)((Object)item$iv$iv);
                Collection collection2 = destination$iv$iv;
                boolean bl16 = false;
                collection2.add(it5.getIndex());
            }
            List typeIndexes = (List)destination$iv$iv;
            message.addRecord((Record)new TXTRecord(new Name("_typ._did."), 1, this.ttl, "id=" + CollectionsKt.joinToString$default((Iterable)typeIndexes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)), 1);
        }
        return message;
    }

    public static /* synthetic */ Message toDnsPacket$dids$default(DidDhtApi didDhtApi, DIDDocument dIDDocument, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toDnsPacket");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return didDhtApi.toDnsPacket$dids(dIDDocument, list);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<String>, Map<String, String>> addVerificationMethodRecords(DIDDocument didDocument, Message message) {
        List list;
        Map verificationMethodsById = new LinkedHashMap();
        List $this$addVerificationMethodRecords_u24lambda_u2431 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<VerificationMethod> list2 = didDocument.getVerificationMethod();
        if (list2 != null) {
            Iterable $this$forEachIndexed$iv = list2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$addVerificationMethodRecords_u24lambda_u2431_u24lambda_u2430_u24lambda_u2429;
                int n;
                JWK publicKeyJwk;
                void verificationMethod;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VerificationMethod verificationMethod2 = (VerificationMethod)item$iv;
                int i = n2;
                boolean bl2 = false;
                if (verificationMethod.getPublicKeyJwk() == null) {
                    throw new PublicKeyJwkMissingException("publicKeyJwk is null");
                }
                byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKeyJwk);
                String base64UrlEncodedKey = new Convert((Object)publicKeyBytes, null, 2, null).toBase64Url(false);
                String verificationMethodId = "k" + i;
                verificationMethodsById.put(verificationMethod.getId(), verificationMethodId);
                Object object = publicKeyJwk.getAlgorithm();
                if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.EdDSA)) {
                    n = 0;
                } else if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.ES256K)) {
                    n = 1;
                } else if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.ES256)) {
                    n = 2;
                } else {
                    throw new IllegalArgumentException("unsupported algorithm: " + publicKeyJwk.getAlgorithm());
                }
                int keyType = n;
                Object object2 = object = CollectionsKt.createListBuilder();
                long l = this.ttl;
                int n3 = 1;
                Name name = new Name("_" + verificationMethodId + "._did.");
                Message message2 = message;
                boolean bl3 = false;
                String fragment = DidUri.Parser.parse(verificationMethod.getId()).getFragment();
                $this$addVerificationMethodRecords_u24lambda_u2431_u24lambda_u2430_u24lambda_u2429.add("id=" + fragment);
                $this$addVerificationMethodRecords_u24lambda_u2431_u24lambda_u2430_u24lambda_u2429.add("t=" + keyType);
                $this$addVerificationMethodRecords_u24lambda_u2431_u24lambda_u2430_u24lambda_u2429.add("k=" + base64UrlEncodedKey);
                if (!Intrinsics.areEqual((Object)verificationMethod.getController(), (Object)didDocument.getId())) {
                    $this$addVerificationMethodRecords_u24lambda_u2431_u24lambda_u2430_u24lambda_u2429.add("c=" + verificationMethod.getController());
                }
                Unit unit = Unit.INSTANCE;
                String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)object), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
                long l2 = l;
                int n4 = n3;
                Name name2 = name;
                message2.addRecord((Record)new TXTRecord(name2, n4, l2, string), 1);
                $this$addVerificationMethodRecords_u24lambda_u2431.add(verificationMethodId);
            }
        }
        List verificationMethods = CollectionsKt.build((List)list);
        return new Pair((Object)verificationMethods, (Object)verificationMethodsById);
    }

    private final void addAlsoKnownAsRecord(DIDDocument didDocument, Message message) {
        Collection collection = didDocument.getAlsoKnownAs();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        message.addRecord((Record)new TXTRecord(new Name("_aka._did."), 1, this.ttl, CollectionsKt.joinToString$default((Iterable)didDocument.getAlsoKnownAs(), (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
    }

    private final void addControllerRecord(DIDDocument didDocument, Message message) {
        List<String> list = didDocument.getController();
        message.addRecord((Record)new TXTRecord(new Name("_cnt._did."), 1, this.ttl, list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null) : null), 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<DIDDocument, List<DidDhtTypeIndexing>> fromDnsPacket$dids(@NotNull String did, @NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        DIDDocument.Builder doc = new DIDDocument.Builder().id(did);
        List services = new ArrayList();
        List types = new ArrayList();
        Map keyLookup = new LinkedHashMap();
        List list = msg.getSection(1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSection(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object service;
            String name;
            Record rr = (Record)element$iv;
            boolean bl = false;
            if (!(rr instanceof TXTRecord)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((TXTRecord)rr).getName().toString(), (String)"toString(...)");
            if (StringsKt.startsWith$default((String)name, (String)"_k", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)rr);
                this.handleVerificationMethods((TXTRecord)rr, did, keyLookup, name, doc);
                continue;
            }
            if (StringsKt.startsWith$default((String)name, (String)"_s", (boolean)false, (int)2, null)) {
                List list2 = ((TXTRecord)rr).getStrings();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
                Map<String, String> data = this.parseTxtData(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                Service.Builder builder = new Service.Builder();
                String string = data.get("id");
                Intrinsics.checkNotNull((Object)string);
                Service.Builder builder2 = builder.id(string);
                String string2 = data.get("t");
                Intrinsics.checkNotNull((Object)string2);
                Service.Builder builder3 = builder2.type(string2);
                String string3 = data.get("se");
                Intrinsics.checkNotNull((Object)string3);
                String[] stringArray = new String[]{","};
                service = builder3.serviceEndpoint(StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).build();
                services.add(service);
                doc.services(services);
                continue;
            }
            if (StringsKt.startsWith$default((String)name, (String)"_typ._did.", (boolean)false, (int)2, null)) {
                Object e = ((TXTRecord)rr).getStrings().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                if (((CharSequence)e).length() > 0 && ((TXTRecord)rr).getStrings().size() == 1) {
                    void $this$mapTo$iv$iv;
                    Collection collection = types;
                    Object e2 = ((TXTRecord)rr).getStrings().get(0);
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                    service = new String[]{","};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)((String)e2), (CharSequence)"id="), (String[])service, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl2 = false;
                        DidDhtTypeIndexing didDhtTypeIndexing = DidDhtTypeIndexing.Companion.fromInt(Integer.parseInt((String)it));
                        if (didDhtTypeIndexing == null) {
                            throw new IllegalArgumentException("invalid type index");
                        }
                        collection2.add(didDhtTypeIndexing);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                    continue;
                }
                throw new IllegalArgumentException("invalid types record");
            }
            if (StringsKt.startsWith$default((String)name, (String)"_did.", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)rr);
                this.handleRootRecord((TXTRecord)rr, keyLookup, doc);
                continue;
            }
            if (StringsKt.startsWith$default((String)name, (String)"_cnt._did.", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)rr);
                this.handleControllerRecord((TXTRecord)rr, doc);
                continue;
            }
            if (!StringsKt.startsWith$default((String)name, (String)"_aka._did.", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNull((Object)rr);
            this.handleAlsoKnownAsRecord((TXTRecord)rr, doc);
        }
        return TuplesKt.to((Object)doc.build(), (Object)types);
    }

    private final void handleAlsoKnownAsRecord(TXTRecord rr, DIDDocument.Builder doc) {
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String data = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray = new String[]{","};
        doc.alsoKnownAses(StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final void handleControllerRecord(TXTRecord rr, DIDDocument.Builder doc) {
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String data = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray = new String[]{","};
        doc.controllers(StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final void handleVerificationMethods(TXTRecord rr, String did, Map<String, String> keyLookup, String name, DIDDocument.Builder didDocBuilder) {
        JWK jWK;
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        Map<String, String> data = this.parseTxtData(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        String string = data.get("id");
        Intrinsics.checkNotNull((Object)string);
        String verificationMethodId = string;
        String string2 = data.get("k");
        Intrinsics.checkNotNull((Object)string2);
        byte[] keyBytes = new Convert((Object)string2, EncodingFormat.Base64Url).toByteArray();
        String string3 = data.get("t");
        Intrinsics.checkNotNull((Object)string3);
        String string4 = string3;
        if (Intrinsics.areEqual((Object)string4, (Object)"0")) {
            jWK = Ed25519.INSTANCE.bytesToPublicKey(keyBytes);
        } else if (Intrinsics.areEqual((Object)string4, (Object)"1")) {
            jWK = Secp256k1.INSTANCE.bytesToPublicKey(keyBytes);
        } else {
            throw new IllegalArgumentException("Unknown key type: " + data.get("t"));
        }
        JWK publicKeyJwk = jWK;
        VerificationMethod.Builder builder = new VerificationMethod.Builder().id(did + "#" + verificationMethodId).type("JsonWebKey");
        JWK jWK2 = publicKeyJwk.toPublicJWK();
        Intrinsics.checkNotNullExpressionValue((Object)jWK2, (String)"toPublicJWK(...)");
        VerificationMethod.Builder vmBuilder = builder.publicKeyJwk(jWK2);
        if (data.containsKey("c")) {
            String string5 = data.get("c");
            Intrinsics.checkNotNull((Object)string5);
            vmBuilder.controller(string5);
        } else {
            vmBuilder.controller(did);
        }
        VerificationMethod vm = vmBuilder.build();
        DIDDocument.Builder.verificationMethodForPurposes$default(didDocBuilder, vm, null, 2, null);
        Map<String, String> map = keyLookup;
        Object object = new String[]{"."};
        object = StringsKt.drop((String)((String)StringsKt.split$default((CharSequence)name, (String[])object, (boolean)false, (int)0, (int)6, null).get(0)), (int)1);
        String string6 = did + "#" + verificationMethodId;
        map.put((String)object, string6);
    }

    private final void handleRootRecord(TXTRecord rr, Map<String, String> keyLookup, DIDDocument.Builder doc) {
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String[] stringArray = new String[]{";"};
        List rootData = StringsKt.split$default((CharSequence)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"asm", (Object)new ArrayList()), TuplesKt.to((Object)"auth", (Object)new ArrayList()), TuplesKt.to((Object)"agm", (Object)new ArrayList()), TuplesKt.to((Object)"inv", (Object)new ArrayList()), TuplesKt.to((Object)"del", (Object)new ArrayList())};
        Map purposeToVmIds = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$forEach$iv = rootData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String item = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list2 = StringsKt.split$default((CharSequence)item, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String key = (String)list2.get(0);
            String values = (String)list2.get(1);
            String[] stringArray3 = new String[]{","};
            List valuesList = StringsKt.split$default((CharSequence)values, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            Iterable $this$forEach$iv2 = valuesList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                List list3 = (List)purposeToVmIds.get(key);
                if (list3 == null) continue;
                String string = keyLookup.get(it);
                Intrinsics.checkNotNull((Object)string);
                list3.add(string);
            }
        }
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("asm"), Purpose.AssertionMethod);
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("auth"), Purpose.Authentication);
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("agm"), Purpose.KeyAgreement);
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("del"), Purpose.CapabilityDelegation);
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("inv"), Purpose.CapabilityInvocation);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseTxtData(String data) {
        void $this$associateTo$iv$iv;
        String[] stringArray = new String[]{";"};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String key = (String)list.get(0);
            String value = (String)list.get(1);
            Pair pair = TuplesKt.to((Object)key, (Object)value);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @JvmOverloads
    public final void publish(@NotNull KeyManager manager, @NotNull DIDDocument didDocument) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        DidDhtApi.publish$default(this, manager, didDocument, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Message toDnsPacket$dids(@NotNull DIDDocument didDocument) {
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        return DidDhtApi.toDnsPacket$dids$default(this, didDocument, null, 2, null);
    }

    public /* synthetic */ DidDhtApi(DidDhtConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(configuration);
    }
}

