/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.didcore.Did;
import web5.sdk.dids.methods.dht.DidDht;
import web5.sdk.dids.methods.jwk.DidJwk;
import web5.sdk.dids.methods.key.DidKey;
import web5.sdk.dids.methods.web.DidWeb;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\bJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lweb5/sdk/dids/DidResolvers;", "", "()V", "methodResolvers", "", "", "Lkotlin/Function1;", "Lweb5/sdk/dids/DidResolutionResult;", "Lweb5/sdk/dids/DidResolver;", "addResolver", "", "methodName", "resolver", "resolve", "didUrl", "dids"})
public final class DidResolvers {
    @NotNull
    public static final DidResolvers INSTANCE = new DidResolvers();
    @NotNull
    private static final Map<String, Function1<String, DidResolutionResult>> methodResolvers;

    private DidResolvers() {
    }

    @NotNull
    public final DidResolutionResult resolve(@NotNull String didUrl) {
        Intrinsics.checkNotNullParameter((Object)didUrl, (String)"didUrl");
        Did did = Did.Parser.parse(didUrl);
        Map<String, Function1<String, DidResolutionResult>> map = methodResolvers;
        Function1<String, DidResolutionResult> function1 = map.get(did.getMethod());
        if (function1 == null) {
            boolean bl = false;
            throw new IllegalArgumentException("Resolving did:" + did.getMethod() + " not supported");
        }
        Function1<String, DidResolutionResult> resolver = function1;
        return (DidResolutionResult)resolver.invoke((Object)didUrl);
    }

    public final void addResolver(@NotNull String methodName, @NotNull Function1<? super String, DidResolutionResult> resolver) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        methodResolvers.put(methodName, resolver);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key", (Object)new Function1<String, DidResolutionResult>((Object)DidKey.Companion){

            @NotNull
            public final DidResolutionResult invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DidKey.Companion)this.receiver).resolve(p0);
            }
        }), TuplesKt.to((Object)"jwk", (Object)new Function1<String, DidResolutionResult>((Object)DidJwk.INSTANCE){

            @NotNull
            public final DidResolutionResult invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DidJwk)this.receiver).resolve(p0);
            }
        }), TuplesKt.to((Object)DidDht.Default.getMethodName(), (Object)new Function1<String, DidResolutionResult>((Object)DidDht.Default){

            @NotNull
            public final DidResolutionResult invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DidDht.Default)this.receiver).resolve(p0);
            }
        }), TuplesKt.to((Object)DidWeb.Default.getMethodName(), (Object)new Function1<String, DidResolutionResult>((Object)DidWeb.Default){

            @NotNull
            public final DidResolutionResult invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DidWeb.Default)this.receiver).resolve(p0);
            }
        })};
        methodResolvers = MapsKt.mutableMapOf((Pair[])pairArray);
    }
}

