/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.jwk;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import web5.sdk.common.Convert;
import web5.sdk.common.EncodingFormat;
import web5.sdk.common.Json;
import web5.sdk.crypto.AlgorithmId;
import web5.sdk.crypto.InMemoryKeyManager;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.jwk.Jwk;
import web5.sdk.dids.DidResolutionMetadata;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.ResolutionError;
import web5.sdk.dids.did.BearerDid;
import web5.sdk.dids.did.PortableDid;
import web5.sdk.dids.didcore.Did;
import web5.sdk.dids.didcore.DidDocument;
import web5.sdk.dids.didcore.Purpose;
import web5.sdk.dids.didcore.VerificationMethod;
import web5.sdk.dids.exceptions.InvalidMethodNameException;
import web5.sdk.dids.exceptions.ParserException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lweb5/sdk/dids/methods/jwk/DidJwk;", "", "()V", "methodName", "", "create", "Lweb5/sdk/dids/did/BearerDid;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "algorithmId", "Lweb5/sdk/crypto/AlgorithmId;", "createDocument", "Lweb5/sdk/dids/didcore/DidDocument;", "did", "Lweb5/sdk/dids/didcore/Did;", "publicKeyJwk", "Lweb5/sdk/crypto/jwk/Jwk;", "import", "portableDid", "Lweb5/sdk/dids/did/PortableDid;", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "dids"})
@SourceDebugExtension(value={"SMAP\nDidJwk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidJwk.kt\nweb5/sdk/dids/methods/jwk/DidJwk\n+ 2 Json.kt\nweb5/sdk/common/Json\n*L\n1#1,181:1\n62#2:182\n*S KotlinDebug\n*F\n+ 1 DidJwk.kt\nweb5/sdk/dids/methods/jwk/DidJwk\n*L\n131#1:182\n*E\n"})
public final class DidJwk {
    @NotNull
    public static final DidJwk INSTANCE = new DidJwk();
    @NotNull
    public static final String methodName = "jwk";

    private DidJwk() {
    }

    @JvmOverloads
    @NotNull
    public final BearerDid create(@NotNull KeyManager keyManager, @NotNull AlgorithmId algorithmId) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Intrinsics.checkNotNullParameter((Object)algorithmId, (String)"algorithmId");
        String keyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (AlgorithmId)algorithmId, null, (int)2, null);
        Jwk publicKeyJwk = keyManager.getPublicKey(keyAlias);
        String base64Encoded = Convert.toBase64Url$default((Convert)new Convert((Object)Json.INSTANCE.stringify((Object)publicKeyJwk), null, 2, null), (boolean)false, (int)1, null);
        String didUri = "did:jwk:" + base64Encoded;
        Did did = new Did(didUri, didUri, methodName, base64Encoded, null, null, null, null, 240, null);
        return new BearerDid(didUri, did, keyManager, this.createDocument(did, publicKeyJwk));
    }

    public static /* synthetic */ BearerDid create$default(DidJwk didJwk, KeyManager keyManager, AlgorithmId algorithmId, int n, Object object) {
        if ((n & 1) != 0) {
            keyManager = (KeyManager)new InMemoryKeyManager();
        }
        if ((n & 2) != 0) {
            algorithmId = AlgorithmId.Ed25519;
        }
        return didJwk.create(keyManager, algorithmId);
    }

    @NotNull
    public final BearerDid import(@NotNull PortableDid portableDid, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Did parsedDid = Did.Parser.parse(portableDid.getUri());
        if (!Intrinsics.areEqual((Object)parsedDid.getMethod(), (Object)methodName)) {
            throw new InvalidMethodNameException("Method not supported");
        }
        BearerDid bearerDid = BearerDid.Companion.import(portableDid, keyManager);
        List<VerificationMethod> list = bearerDid.getDocument().getVerificationMethod();
        if (!(!(list != null ? list.size() == 0 : false))) {
            boolean bl = false;
            String string = "DidJwk DID document must contain exactly one verification method";
            throw new IllegalStateException(string.toString());
        }
        return bearerDid;
    }

    public static /* synthetic */ BearerDid import$default(DidJwk didJwk, PortableDid portableDid, KeyManager keyManager, int n, Object object) {
        if ((n & 2) != 0) {
            keyManager = (KeyManager)new InMemoryKeyManager();
        }
        return didJwk.import(portableDid, keyManager);
    }

    @NotNull
    public final DidResolutionResult resolve(@NotNull String did) {
        Json this_$iv;
        Did did2;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        try {
            did2 = Did.Parser.parse(did);
        }
        catch (ParserException parserException) {
            return new DidResolutionResult("https://w3id.org/did-resolution/v1", null, null, new DidResolutionMetadata(null, ResolutionError.INVALID_DID.getValue(), null, 5, null), 6, null);
        }
        Did parsedDid = did2;
        if (!Intrinsics.areEqual((Object)parsedDid.getMethod(), (Object)methodName)) {
            return new DidResolutionResult("https://w3id.org/did-resolution/v1", null, null, new DidResolutionMetadata(null, ResolutionError.METHOD_NOT_SUPPORTED.getValue(), null, 5, null), 6, null);
        }
        String id = parsedDid.getId();
        String decodedKey = new Convert((Object)id, EncodingFormat.Base64Url).toStr();
        try {
            this_$iv = Json.INSTANCE;
            boolean $i$f$parse = false;
            this_$iv = (Jwk)this_$iv.getObjectReader().readValue(decodedKey, Jwk.class);
        }
        catch (Exception exception) {
            return new DidResolutionResult("https://w3id.org/did-resolution/v1", null, null, new DidResolutionMetadata(null, ResolutionError.INVALID_DID.getValue(), null, 5, null), 6, null);
        }
        Json publicKeyJwk = this_$iv;
        if (!(publicKeyJwk.getD() == null)) {
            boolean bl = false;
            String string = "decoded jwk value cannot be a private key";
            throw new IllegalArgumentException(string.toString());
        }
        DidDocument didDocument = this.createDocument(parsedDid, (Jwk)publicKeyJwk);
        return new DidResolutionResult("https://w3id.org/did-resolution/v1", didDocument, null, null, 12, null);
    }

    private final DidDocument createDocument(Did did, Jwk publicKeyJwk) {
        String verificationMethodId = did.getUri() + "#0";
        VerificationMethod verificationMethod = new VerificationMethod.Builder().id(verificationMethodId).publicKeyJwk(publicKeyJwk).controller(did.getUrl()).type("JsonWebKey").build();
        DidDocument.Builder didDocumentBuilder = new DidDocument.Builder().context(CollectionsKt.listOf((Object)"https://www.w3.org/ns/did/v1")).id(did.getUrl());
        if (!Intrinsics.areEqual((Object)publicKeyJwk.getUse(), (Object)"enc")) {
            Object[] objectArray = new Purpose[]{Purpose.AssertionMethod, Purpose.Authentication, Purpose.CapabilityDelegation, Purpose.CapabilityInvocation};
            didDocumentBuilder.verificationMethodForPurposes(verificationMethod, CollectionsKt.listOf((Object[])objectArray));
        }
        if (!Intrinsics.areEqual((Object)publicKeyJwk.getUse(), (Object)"sig")) {
            didDocumentBuilder.verificationMethodForPurposes(verificationMethod, CollectionsKt.listOf((Object)Purpose.KeyAgreement));
        }
        return didDocumentBuilder.build();
    }

    @JvmOverloads
    @NotNull
    public final BearerDid create(@NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        return DidJwk.create$default(this, keyManager, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final BearerDid create() {
        return DidJwk.create$default(this, null, null, 3, null);
    }
}

