/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.dht;

import io.ktor.client.engine.HttpClientEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import web5.sdk.common.Convert;
import web5.sdk.common.EncodingFormat;
import web5.sdk.common.ZBase32;
import web5.sdk.crypto.AlgorithmId;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.Ed25519;
import web5.sdk.crypto.InMemoryKeyManager;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.Secp256k1;
import web5.sdk.crypto.jwk.Jwk;
import web5.sdk.dids.DidResolutionMetadata;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.ResolutionError;
import web5.sdk.dids.did.BearerDid;
import web5.sdk.dids.did.PortableDid;
import web5.sdk.dids.didcore.Did;
import web5.sdk.dids.didcore.DidDocument;
import web5.sdk.dids.didcore.DidDocumentMetadata;
import web5.sdk.dids.didcore.Purpose;
import web5.sdk.dids.didcore.Service;
import web5.sdk.dids.didcore.VerificationMethod;
import web5.sdk.dids.exceptions.InvalidIdentifierException;
import web5.sdk.dids.exceptions.InvalidIdentifierSizeException;
import web5.sdk.dids.exceptions.InvalidMethodNameException;
import web5.sdk.dids.exceptions.ParserException;
import web5.sdk.dids.exceptions.PkarrRecordNotFoundException;
import web5.sdk.dids.exceptions.PublicKeyJwkMissingException;
import web5.sdk.dids.methods.dht.Bep44Message;
import web5.sdk.dids.methods.dht.CreateDidDhtOptions;
import web5.sdk.dids.methods.dht.DhtClient;
import web5.sdk.dids.methods.dht.DidDht;
import web5.sdk.dids.methods.dht.DidDhtConfiguration;
import web5.sdk.dids.methods.dht.DidDhtDocumentMetadata;
import web5.sdk.dids.methods.dht.DidDhtKt;
import web5.sdk.dids.methods.dht.DidDhtTypeIndexing;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J6\u0010\u0016\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00190\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J/\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00180\u00172\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J,\u00100\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010-\u001a\u00020.H\u0002J<\u00102\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\n2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n032\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020.H\u0002J\u001a\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u0002082\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007J\u001c\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010:\u001a\u00020\nH\u0002J*\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\b\u0002\u0010=\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u0018H\u0007J\u000e\u0010>\u001a\u00020?2\u0006\u0010\"\u001a\u00020\nJ\u0010\u0010@\u001a\u00020?2\u0006\u0010\"\u001a\u00020\nH\u0002J\u000e\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\nJ'\u0010C\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0010\b\u0002\u0010=\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u0018H\u0001\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\nH\u0000\u00a2\u0006\u0002\bFJ\u001d\u0010G\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bHR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002IJ\u00a8\u0006K"}, d2={"Lweb5/sdk/dids/methods/dht/DidDhtApi;", "", "configuration", "Lweb5/sdk/dids/methods/dht/DidDhtConfiguration;", "(Lweb5/sdk/dids/methods/dht/DidDhtConfiguration;)V", "dhtClient", "Lweb5/sdk/dids/methods/dht/DhtClient;", "engine", "Lio/ktor/client/engine/HttpClientEngine;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "ttl", "", "addAlsoKnownAsRecord", "", "didDocument", "Lweb5/sdk/dids/didcore/DidDocument;", "message", "Lorg/xbill/DNS/Message;", "addControllerRecord", "addVerificationMethodRecords", "Lkotlin/Pair;", "", "", "create", "Lweb5/sdk/dids/did/BearerDid;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "Lweb5/sdk/dids/methods/dht/CreateDidDhtOptions;", "fromDnsPacket", "Lweb5/sdk/dids/methods/dht/DidDhtTypeIndexing;", "did", "msg", "fromDnsPacket$web5_dids", "getDidIdentifier", "identityKey", "Lweb5/sdk/crypto/jwk/Jwk;", "getDidIdentifier$web5_dids", "getIdentityKid", "handleAlsoKnownAsRecord", "rr", "Lorg/xbill/DNS/TXTRecord;", "doc", "Lweb5/sdk/dids/didcore/DidDocument$Builder;", "handleControllerRecord", "handleRootRecord", "keyLookup", "handleVerificationMethods", "", "name", "didDocBuilder", "import", "portableDid", "Lweb5/sdk/dids/did/PortableDid;", "parseTxtData", "data", "publish", "manager", "types", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "resolveInternal", "suffix", "didUrl", "toDnsPacket", "toDnsPacket$web5_dids", "validate", "validate$web5_dids", "validateIdentityKey", "validateIdentityKey$web5_dids", "Lweb5/sdk/dids/methods/dht/DidDht$Default;", "Lweb5/sdk/dids/methods/dht/DidDhtApiImpl;", "web5-dids"})
@SourceDebugExtension(value={"SMAP\nDidDht.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidDht.kt\nweb5/sdk/dids/methods/dht/DidDhtApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,757:1\n1549#2:758\n1620#2,2:759\n1622#2:762\n1549#2:763\n1620#2,3:764\n2624#2,3:767\n1549#2:770\n1620#2,3:771\n1864#2,3:774\n1549#2:777\n1620#2,3:778\n1549#2:781\n1620#2,3:782\n1549#2:785\n1620#2,3:786\n1549#2:789\n1620#2,3:790\n1549#2:793\n1620#2,3:794\n1549#2:797\n1620#2,3:798\n1864#2,3:801\n1855#2:804\n1549#2:805\n1620#2,3:806\n1856#2:809\n1855#2:810\n1855#2,2:811\n1856#2:813\n1179#2,2:814\n1253#2,4:816\n1#3:761\n*S KotlinDebug\n*F\n+ 1 DidDht.kt\nweb5/sdk/dids/methods/dht/DidDhtApi\n*L\n142#1:758\n142#1:759,2\n142#1:762\n181#1:763\n181#1:764,3\n253#1:767,3\n285#1:770\n285#1:771,3\n414#1:774,3\n439#1:777\n439#1:778,3\n443#1:781\n443#1:782,3\n447#1:785\n447#1:786,3\n451#1:789\n451#1:790,3\n455#1:793\n455#1:794,3\n469#1:797\n469#1:798,3\n484#1:801,3\n563#1:804\n587#1:805\n587#1:806,3\n563#1:809\n674#1:810\n678#1:811,2\n674#1:813\n696#1:814,2\n696#1:816,4\n*E\n"})
public abstract class DidDhtApi {
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final DhtClient dhtClient;
    private final long ttl;
    @NotNull
    private final String methodName;

    private DidDhtApi(DidDhtConfiguration configuration) {
        this.engine = configuration.getEngine();
        this.dhtClient = new DhtClient(configuration.getGateway(), this.engine);
        this.ttl = 7200L;
        this.methodName = "dht";
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final BearerDid create(@NotNull KeyManager keyManager, @Nullable CreateDidDhtOptions options) {
        Iterable<String> it;
        List list;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        CreateDidDhtOptions createDidDhtOptions = options;
        if (createDidDhtOptions == null) {
            createDidDhtOptions = new CreateDidDhtOptions(null, null, false, null, null, 31, null);
        }
        CreateDidDhtOptions opts = createDidDhtOptions;
        String keyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (AlgorithmId)AlgorithmId.Ed25519, null, (int)2, null);
        Jwk publicKey = keyManager.getPublicKey(keyAlias);
        String didUri = DidDht.Default.getDidIdentifier$web5_dids(publicKey);
        Iterable<Service> iterable = opts.getServices();
        if (iterable != null) {
            void $this$mapTo$iv$iv;
            Iterable<Service> $this$map$iv = iterable;
            boolean $i$f$map = false;
            Iterable<Service> iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void service;
                Service service2 = (Service)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                if (service.getId() == null) {
                    boolean $i$a$-requireNotNull-DidDhtApi$create$services$1$42 = false;
                    String $i$a$-requireNotNull-DidDhtApi$create$services$1$42 = "Service id cannot be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DidDhtApi$create$services$1$42.toString());
                }
                if (service.getType() == null) {
                    boolean $i$a$-requireNotNull-DidDhtApi$create$services$1$52 = false;
                    String $i$a$-requireNotNull-DidDhtApi$create$services$1$52 = "Service type cannot be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DidDhtApi$create$services$1$52.toString());
                }
                if (service.getServiceEndpoint() == null) {
                    boolean bl2 = false;
                    String string = "Service serviceEndpoint cannot be null";
                    throw new IllegalArgumentException(string.toString());
                }
                collection.add(new Service(didUri + "#" + service.getId(), service.getType(), service.getServiceEndpoint()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List services = list;
        DidDocument.Builder didDocumentBuilder = new DidDocument.Builder().id(didUri).services(services);
        Iterable<String> iterable3 = opts.getControllers();
        if (iterable3 != null) {
            it = iterable3;
            boolean bl = false;
            didDocumentBuilder.controllers(CollectionsKt.toList(it));
        }
        Iterable<String> iterable4 = opts.getAlsoKnownAses();
        if (iterable4 != null) {
            it = iterable4;
            boolean bl = false;
            didDocumentBuilder.alsoKnownAses(CollectionsKt.toList(it));
        }
        VerificationMethod identityVerificationMethod = new VerificationMethod(didUri + "#0", "JsonWebKey", didUri, publicKey);
        Object[] $i$f$map = new Purpose[]{Purpose.AssertionMethod, Purpose.Authentication, Purpose.CapabilityDelegation, Purpose.CapabilityInvocation};
        didDocumentBuilder.verificationMethodForPurposes(identityVerificationMethod, CollectionsKt.listOf((Object[])$i$f$map));
        Iterable<Triple<Jwk, List<Purpose>, String>> iterable5 = opts.getVerificationMethods();
        if (iterable5 != null) {
            void $this$mapTo$iv$iv;
            Iterable<Triple<Jwk, List<Purpose>, String>> $this$map$iv = iterable5;
            boolean $i$f$map2 = false;
            Iterable<Triple<Jwk, List<Purpose>, String>> $i$f$mapTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VerificationMethod verificationMethod;
                Triple triple = (Triple)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Jwk publicKey2 = (Jwk)triple.component1();
                List purposes = (List)triple.component2();
                String controller = (String)triple.component3();
                VerificationMethod.Builder builder = new VerificationMethod.Builder();
                String string = publicKey2.getKid();
                if (string == null) {
                    string = publicKey2.computeThumbprint();
                }
                VerificationMethod.Builder builder2 = builder.id(didUri + "#" + string).type("JsonWebKey");
                String string2 = controller;
                if (string2 == null) {
                    string2 = didUri;
                }
                VerificationMethod verificationMethod2 = verificationMethod = builder2.controller(string2).publicKeyJwk(publicKey2).build();
                boolean bl3 = false;
                didDocumentBuilder.verificationMethodForPurposes(verificationMethod2, CollectionsKt.toList((Iterable)purposes));
                collection.add(verificationMethod);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        DidDocument didDocument = didDocumentBuilder.build();
        if (opts.getPublish()) {
            DidDhtApi.publish$default(this, keyManager, didDocument, null, 4, null);
        }
        String id = this.suffix(didUri);
        String string = this.methodName;
        Did did = new Did(didUri, didUri, string, id, null, null, null, null, 240, null);
        return new BearerDid(didUri, did, keyManager, didDocument);
    }

    public static /* synthetic */ BearerDid create$default(DidDhtApi didDhtApi, KeyManager keyManager, CreateDidDhtOptions createDidDhtOptions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 2) != 0) {
            createDidDhtOptions = null;
        }
        return didDhtApi.create(keyManager, createDidDhtOptions);
    }

    @NotNull
    public final DidResolutionResult resolve(@NotNull String did) {
        DidResolutionResult didResolutionResult;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        try {
            didResolutionResult = this.resolveInternal(did);
        }
        catch (Exception e) {
            DidDhtKt.access$getLogger$p().warn((Throwable)e, (Function0)new Function0<Object>(did){
                final /* synthetic */ String $did;
                {
                    this.$did = $did;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "resolving DID " + this.$did + " failed";
                }
            });
            didResolutionResult = DidResolutionResult.Companion.fromResolutionError(ResolutionError.INTERNAL_ERROR);
        }
        return didResolutionResult;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final BearerDid import(@NotNull PortableDid portableDid, @NotNull KeyManager keyManager) {
        boolean containsOneVmWithFragmentId0;
        BearerDid bearerDid;
        block7: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            Did parsedDid = Did.Parser.parse(portableDid.getUri());
            if (!Intrinsics.areEqual((Object)parsedDid.getMethod(), (Object)this.methodName)) {
                throw new InvalidMethodNameException("Method not supported");
            }
            bearerDid = BearerDid.Companion.import(portableDid, keyManager);
            List<VerificationMethod> list = bearerDid.getDocument().getVerificationMethod();
            if (list != null) {
                void $this$none$iv;
                Iterable iterable = list;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        VerificationMethod vm = (VerificationMethod)element$iv;
                        boolean bl2 = false;
                        String[] stringArray = new String[]{"#"};
                        if (!Intrinsics.areEqual((Object)CollectionsKt.last((List)StringsKt.split$default((CharSequence)vm.getId(), (String[])stringArray, (boolean)false, (int)0, (int)6, null)), (Object)"0")) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            } else {
                bl = containsOneVmWithFragmentId0 = false;
            }
        }
        if (!containsOneVmWithFragmentId0) {
            boolean bl = false;
            String string = "DidDht DID document must contain at least one verification method with fragment of 0";
            throw new IllegalStateException(string.toString());
        }
        return bearerDid;
    }

    public static /* synthetic */ BearerDid import$default(DidDhtApi didDhtApi, PortableDid portableDid, KeyManager keyManager, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: import");
        }
        if ((n & 2) != 0) {
            keyManager = (KeyManager)new InMemoryKeyManager();
        }
        return didDhtApi.import(portableDid, keyManager);
    }

    /*
     * WARNING - void declaration
     */
    private final DidResolutionResult resolveInternal(String did) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Bep44Message bep44Message;
        try {
            this.validate$web5_dids(did);
        }
        catch (ParserException parserException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.INVALID_DID);
        }
        catch (InvalidMethodNameException invalidMethodNameException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.METHOD_NOT_SUPPORTED);
        }
        catch (InvalidIdentifierSizeException invalidIdentifierSizeException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.INVALID_DID);
        }
        catch (InvalidIdentifierException invalidIdentifierException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.INVALID_PUBLIC_KEY);
        }
        String getId = DidDht.Default.suffix(did);
        try {
            bep44Message = this.dhtClient.pkarrGet(getId);
        }
        catch (PkarrRecordNotFoundException pkarrRecordNotFoundException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.NOT_FOUND);
        }
        Bep44Message bep44Message2 = bep44Message;
        Message dnsPacket = DhtClient.Companion.parseBep44GetResponse(bep44Message2);
        Pair<DidDocument, List<DidDhtTypeIndexing>> pair = this.fromDnsPacket$web5_dids(did, dnsPacket);
        boolean bl = false;
        DidDocument didDocument = (DidDocument)pair.component1();
        List types = (List)pair.component2();
        Iterable iterable = types;
        DidDocument didDocument2 = didDocument;
        String string = null;
        boolean $i$f$map = false;
        void var14_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DidDhtTypeIndexing didDhtTypeIndexing = (DidDhtTypeIndexing)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getIndex());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 9;
        DidResolutionMetadata didResolutionMetadata = null;
        DidDocumentMetadata didDocumentMetadata = new DidDhtDocumentMetadata(list);
        DidDocument didDocument3 = didDocument2;
        String string2 = string;
        return new DidResolutionResult(string2, didDocument3, didDocumentMetadata, didResolutionMetadata, n, defaultConstructorMarker);
    }

    @JvmOverloads
    public final void publish(@NotNull KeyManager manager, @NotNull DidDocument didDocument, @Nullable List<? extends DidDhtTypeIndexing> types) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        this.validate$web5_dids(didDocument.getId());
        String publishId = DidDht.Default.suffix(didDocument.getId());
        Message dnsPacket = this.toDnsPacket$web5_dids(didDocument, types);
        Bep44Message bep44Message = DhtClient.Companion.createBep44PutRequest(manager, this.getIdentityKid(didDocument), dnsPacket);
        this.dhtClient.pkarrPut(publishId, bep44Message);
    }

    public static /* synthetic */ void publish$default(DidDhtApi didDhtApi, KeyManager keyManager, DidDocument didDocument, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publish");
        }
        if ((n & 4) != 0) {
            list = null;
        }
        didDhtApi.publish(keyManager, didDocument, list);
    }

    @NotNull
    public final String suffix(@NotNull String didUrl) {
        Intrinsics.checkNotNullParameter((Object)didUrl, (String)"didUrl");
        String[] stringArray = new String[]{":"};
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)didUrl, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final String getIdentityKid(DidDocument didDocument) {
        this.validate$web5_dids(didDocument.getId());
        List<VerificationMethod> list = didDocument.getVerificationMethod();
        if (list == null || (list = (VerificationMethod)CollectionsKt.first(list)) == null || (list = ((VerificationMethod)((Object)list)).getPublicKeyJwk()) == null) {
            throw new PublicKeyJwkMissingException("publicKeyJwk is null");
        }
        List<VerificationMethod> publicKeyJwk = list;
        String string = publicKeyJwk.getKid();
        if (string == null) {
            string = publicKeyJwk.computeThumbprint();
        }
        return string;
    }

    public final void validateIdentityKey$web5_dids(@NotNull String did, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Did parsedDid = Did.Parser.parse(did);
        byte[] decodedId = ZBase32.INSTANCE.decode(parsedDid.getId());
        if (!(decodedId.length == 32)) {
            boolean $i$a$-require-DidDhtApi$validateIdentityKey$22 = false;
            String $i$a$-require-DidDhtApi$validateIdentityKey$22 = "expected size of decoded identifier " + parsedDid.getId() + " to be 32";
            throw new IllegalArgumentException($i$a$-require-DidDhtApi$validateIdentityKey$22.toString());
        }
        Jwk publicKeyJwk = Ed25519.INSTANCE.bytesToPublicKey(decodedId);
        String identityKeyAlias = keyManager.getDeterministicAlias(publicKeyJwk);
        keyManager.getPublicKey(identityKeyAlias);
    }

    @NotNull
    public final String getDidIdentifier$web5_dids(@NotNull Jwk identityKey) {
        String string;
        String it;
        Jwk.Builder builder;
        Intrinsics.checkNotNullParameter((Object)identityKey, (String)"identityKey");
        Jwk.Builder $this$getDidIdentifier_u24lambda_u2417 = builder = new Jwk.Builder(identityKey.getKty(), identityKey.getCrv());
        boolean bl = false;
        String string2 = identityKey.getX();
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            $this$getDidIdentifier_u24lambda_u2417.x(it);
        }
        String string3 = identityKey.getY();
        if (string3 != null) {
            it = string3;
            boolean bl3 = false;
            $this$getDidIdentifier_u24lambda_u2417.y(it);
        }
        String string4 = identityKey.getAlg();
        if (string4 != null) {
            it = string4;
            boolean bl4 = false;
            $this$getDidIdentifier_u24lambda_u2417.algorithm(it);
        }
        if ((string = identityKey.getKid()) == null) {
            string = identityKey.computeThumbprint();
        }
        String it2 = string;
        boolean bl5 = false;
        $this$getDidIdentifier_u24lambda_u2417.keyId(it2);
        Jwk publicKeyJwk = builder.build();
        publicKeyJwk.setKid(publicKeyJwk.computeThumbprint());
        byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKeyJwk);
        String zBase32Encoded = ZBase32.INSTANCE.encode(publicKeyBytes);
        return "did:dht:" + zBase32Encoded;
    }

    public final void validate$web5_dids(@NotNull String did) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Did parsedDid = Did.Parser.parse(did);
        if (!Intrinsics.areEqual((Object)parsedDid.getMethod(), (Object)DidDht.Default.getMethodName())) {
            boolean bl = false;
            throw new InvalidMethodNameException("expected method to be dht");
        }
        try {
            byArray = ZBase32.INSTANCE.decode(parsedDid.getId());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidIdentifierException("expected method-specific identifier to be z-base-32 encoded", e);
        }
        byte[] decodedId = byArray;
        if (!(decodedId.length == 32)) {
            boolean bl = false;
            throw new InvalidIdentifierSizeException("expected size of decoded identifier to be 32");
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Message toDnsPacket$web5_dids(@NotNull DidDocument didDocument, @Nullable List<? extends DidDhtTypeIndexing> types) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object it;
        String it2;
        Collection collection;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Object object5;
        Iterable service;
        Iterable $this$forEachIndexed$iv;
        Pair<List<String>, Map<String, String>> pair;
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        Pair<List<String>, Map<String, String>> $this$toDnsPacket_u24lambda_u2420 = pair = new Pair<List<String>, Map<String, String>>(0);
        boolean bl = false;
        $this$toDnsPacket_u24lambda_u2420.getHeader().setFlag(5);
        Pair<List<String>, Map<String, String>> message = pair;
        pair = this.addVerificationMethodRecords(didDocument, (Message)message);
        List verificationMethodIds = (List)pair.component1();
        Map verificationMethodsById = (Map)pair.component2();
        List serviceIds = new ArrayList();
        List<Service> list = didDocument.getService();
        if (list != null) {
            $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Service service2 = (Service)item$iv;
                int i = n;
                boolean bl2 = false;
                Iterator sId = "s" + i;
                Object[] objectArray = new String[]{"id=" + ((Service)((Object)service)).getId(), "t=" + ((Service)((Object)service)).getType(), "se=" + CollectionsKt.joinToString$default((Iterable)((Service)((Object)service)).getServiceEndpoint(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)};
                message.addRecord((Record)new TXTRecord(new Name("_" + (String)((Object)sId) + "._did."), 1, this.ttl, CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
                ((Collection)serviceIds).add(sId);
            }
        }
        List<String> list2 = didDocument.getController();
        if (list2 != null) {
            List<String> it3 = list2;
            boolean bl3 = false;
            this.addControllerRecord(didDocument, (Message)message);
        }
        List<String> list3 = didDocument.getAlsoKnownAs();
        if (list3 != null) {
            List<String> it4 = list3;
            boolean bl4 = false;
            this.addAlsoKnownAsRecord(didDocument, (Message)message);
        }
        Iterable $this$toDnsPacket_u24lambda_u2434 = $this$forEachIndexed$iv = (List)new ArrayList();
        boolean bl5 = false;
        if (!((Collection)verificationMethodIds).isEmpty()) {
            $this$toDnsPacket_u24lambda_u2434.add("vm=" + CollectionsKt.joinToString$default((Iterable)verificationMethodIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)serviceIds).isEmpty()) {
            $this$toDnsPacket_u24lambda_u2434.add("svc=" + CollectionsKt.joinToString$default((Iterable)serviceIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if ((object5 = didDocument.getAuthentication()) != null) {
            $this$map$iv = (Iterable)object5;
            $i$f$map = false;
            service = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object5 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object5 != null) {
                it = object5;
                boolean bl7 = false;
                $this$toDnsPacket_u24lambda_u2434.add("auth=" + (String)it);
            }
        }
        if ((object4 = didDocument.getAssertionMethod()) != null) {
            $this$map$iv = (Iterable)object4;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object4 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object4 != null) {
                it = object4;
                boolean bl9 = false;
                $this$toDnsPacket_u24lambda_u2434.add("asm=" + (String)it);
            }
        }
        if ((object3 = didDocument.getKeyAgreement()) != null) {
            $this$map$iv = (Iterable)object3;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl10 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object3 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object3 != null) {
                it = object3;
                boolean bl11 = false;
                $this$toDnsPacket_u24lambda_u2434.add("agm=" + (String)it);
            }
        }
        if ((object2 = didDocument.getCapabilityInvocation()) != null) {
            $this$map$iv = (Iterable)object2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl12 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object2 != null) {
                it = object2;
                boolean bl13 = false;
                $this$toDnsPacket_u24lambda_u2434.add("inv=" + (String)it);
            }
        }
        if ((object = didDocument.getCapabilityDelegation()) != null) {
            $this$map$iv = (Iterable)object;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl14 = false;
                collection.add((String)verificationMethodsById.get(it2));
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            if (object != null) {
                it = object;
                boolean bl15 = false;
                $this$toDnsPacket_u24lambda_u2434.add("del=" + (String)it);
            }
        }
        Iterable rootRecordText = $this$forEachIndexed$iv;
        message.addRecord((Record)new TXTRecord(new Name("_did."), 1, this.ttl, CollectionsKt.joinToString$default((Iterable)rootRecordText, (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
        if (types != null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = types;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it5;
                DidDhtTypeIndexing $i$f$mapTo3 = (DidDhtTypeIndexing)((Object)item$iv$iv);
                Collection collection2 = destination$iv$iv;
                boolean bl16 = false;
                collection2.add(it5.getIndex());
            }
            List typeIndexes = (List)destination$iv$iv;
            message.addRecord((Record)new TXTRecord(new Name("_typ._did."), 1, this.ttl, "id=" + CollectionsKt.joinToString$default((Iterable)typeIndexes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)), 1);
        }
        return message;
    }

    public static /* synthetic */ Message toDnsPacket$web5_dids$default(DidDhtApi didDhtApi, DidDocument didDocument, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toDnsPacket");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return didDhtApi.toDnsPacket$web5_dids(didDocument, list);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<String>, Map<String, String>> addVerificationMethodRecords(DidDocument didDocument, Message message) {
        List list;
        Map verificationMethodsById = new LinkedHashMap();
        List $this$addVerificationMethodRecords_u24lambda_u2438 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<VerificationMethod> list2 = didDocument.getVerificationMethod();
        if (list2 != null) {
            Iterable $this$forEachIndexed$iv = list2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$addVerificationMethodRecords_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436;
                int n;
                Jwk publicKeyJwk;
                void verificationMethod;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VerificationMethod verificationMethod2 = (VerificationMethod)item$iv;
                int i = n2;
                boolean bl2 = false;
                if (verificationMethod.getPublicKeyJwk() == null) {
                    throw new PublicKeyJwkMissingException("publicKeyJwk is null");
                }
                byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKeyJwk);
                String base64UrlEncodedKey = Convert.toBase64Url$default((Convert)new Convert((Object)publicKeyBytes, null, 2, null), (boolean)false, (int)1, null);
                String verificationMethodId = "k" + i;
                verificationMethodsById.put(verificationMethod.getId(), verificationMethodId);
                Object object = publicKeyJwk.getAlg();
                if (Intrinsics.areEqual((Object)object, (Object)"EdDSA")) {
                    n = 0;
                } else if (Intrinsics.areEqual((Object)object, (Object)"ES256K")) {
                    n = 1;
                } else {
                    throw new IllegalArgumentException("unsupported algorithm: " + publicKeyJwk.getAlg());
                }
                int keyType = n;
                Object object2 = object = CollectionsKt.createListBuilder();
                long l = this.ttl;
                int n3 = 1;
                Name name = new Name("_" + verificationMethodId + "._did.");
                Message message2 = message;
                boolean bl3 = false;
                String fragment = Did.Parser.parse(verificationMethod.getId()).getFragment();
                $this$addVerificationMethodRecords_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.add("id=" + fragment);
                $this$addVerificationMethodRecords_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.add("t=" + keyType);
                $this$addVerificationMethodRecords_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.add("k=" + base64UrlEncodedKey);
                if (!Intrinsics.areEqual((Object)verificationMethod.getController(), (Object)didDocument.getId())) {
                    $this$addVerificationMethodRecords_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.add("c=" + verificationMethod.getController());
                }
                Unit unit = Unit.INSTANCE;
                String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)object), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
                long l2 = l;
                int n4 = n3;
                Name name2 = name;
                message2.addRecord((Record)new TXTRecord(name2, n4, l2, string), 1);
                $this$addVerificationMethodRecords_u24lambda_u2438.add(verificationMethodId);
            }
        }
        List verificationMethods = CollectionsKt.build((List)list);
        return new Pair((Object)verificationMethods, (Object)verificationMethodsById);
    }

    private final void addAlsoKnownAsRecord(DidDocument didDocument, Message message) {
        Collection collection = didDocument.getAlsoKnownAs();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        message.addRecord((Record)new TXTRecord(new Name("_aka._did."), 1, this.ttl, CollectionsKt.joinToString$default((Iterable)didDocument.getAlsoKnownAs(), (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), 1);
    }

    private final void addControllerRecord(DidDocument didDocument, Message message) {
        List<String> list = didDocument.getController();
        message.addRecord((Record)new TXTRecord(new Name("_cnt._did."), 1, this.ttl, list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null) : null), 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<DidDocument, List<DidDhtTypeIndexing>> fromDnsPacket$web5_dids(@NotNull String did, @NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        DidDocument.Builder doc = new DidDocument.Builder().id(did);
        List services = new ArrayList();
        List types = new ArrayList();
        Map keyLookup = new LinkedHashMap();
        List list = msg.getSection(1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSection(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object service;
            String name;
            Record rr = (Record)element$iv;
            boolean bl = false;
            if (!(rr instanceof TXTRecord)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((TXTRecord)rr).getName().toString(), (String)"toString(...)");
            if (StringsKt.startsWith$default((String)name, (String)"_k", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)rr);
                this.handleVerificationMethods((TXTRecord)rr, did, keyLookup, name, doc);
                continue;
            }
            if (StringsKt.startsWith$default((String)name, (String)"_s", (boolean)false, (int)2, null)) {
                List list2 = ((TXTRecord)rr).getStrings();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
                Map<String, String> data = this.parseTxtData(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                Service.Builder builder = new Service.Builder();
                String string = data.get("id");
                Intrinsics.checkNotNull((Object)string);
                Service.Builder builder2 = builder.id(string);
                String string2 = data.get("t");
                Intrinsics.checkNotNull((Object)string2);
                Service.Builder builder3 = builder2.type(string2);
                String string3 = data.get("se");
                Intrinsics.checkNotNull((Object)string3);
                String[] stringArray = new String[]{","};
                service = builder3.serviceEndpoint(StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).build();
                services.add(service);
                doc.services(services);
                continue;
            }
            if (StringsKt.startsWith$default((String)name, (String)"_typ._did.", (boolean)false, (int)2, null)) {
                Object e = ((TXTRecord)rr).getStrings().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                if (((CharSequence)e).length() > 0 && ((TXTRecord)rr).getStrings().size() == 1) {
                    void $this$mapTo$iv$iv;
                    Collection collection = types;
                    Object e2 = ((TXTRecord)rr).getStrings().get(0);
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                    service = new String[]{","};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)((String)e2), (CharSequence)"id="), (String[])service, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl2 = false;
                        DidDhtTypeIndexing didDhtTypeIndexing = DidDhtTypeIndexing.Companion.fromInt(Integer.parseInt((String)it));
                        if (didDhtTypeIndexing == null) {
                            throw new IllegalArgumentException("invalid type index");
                        }
                        collection2.add(didDhtTypeIndexing);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                    continue;
                }
                throw new IllegalArgumentException("invalid types record");
            }
            if (StringsKt.startsWith$default((String)name, (String)"_did.", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)rr);
                this.handleRootRecord((TXTRecord)rr, keyLookup, doc);
                continue;
            }
            if (StringsKt.startsWith$default((String)name, (String)"_cnt._did.", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)rr);
                this.handleControllerRecord((TXTRecord)rr, doc);
                continue;
            }
            if (!StringsKt.startsWith$default((String)name, (String)"_aka._did.", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNull((Object)rr);
            this.handleAlsoKnownAsRecord((TXTRecord)rr, doc);
        }
        return TuplesKt.to((Object)doc.build(), (Object)types);
    }

    private final void handleAlsoKnownAsRecord(TXTRecord rr, DidDocument.Builder doc) {
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String data = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray = new String[]{","};
        doc.alsoKnownAses(StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final void handleControllerRecord(TXTRecord rr, DidDocument.Builder doc) {
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String data = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray = new String[]{","};
        doc.controllers(StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    private final void handleVerificationMethods(TXTRecord rr, String did, Map<String, String> keyLookup, String name, DidDocument.Builder didDocBuilder) {
        Jwk jwk;
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        Map<String, String> data = this.parseTxtData(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        String string = data.get("id");
        Intrinsics.checkNotNull((Object)string);
        String verificationMethodId = string;
        String string2 = data.get("k");
        Intrinsics.checkNotNull((Object)string2);
        byte[] keyBytes = new Convert((Object)string2, EncodingFormat.Base64Url).toByteArray();
        String string3 = data.get("t");
        Intrinsics.checkNotNull((Object)string3);
        String string4 = string3;
        if (Intrinsics.areEqual((Object)string4, (Object)"0")) {
            jwk = Ed25519.INSTANCE.bytesToPublicKey(keyBytes);
        } else if (Intrinsics.areEqual((Object)string4, (Object)"1")) {
            jwk = Secp256k1.INSTANCE.bytesToPublicKey(keyBytes);
        } else {
            throw new IllegalArgumentException("Unknown key type: " + data.get("t"));
        }
        Jwk publicKeyJwk = jwk;
        VerificationMethod.Builder vmBuilder = new VerificationMethod.Builder().id(did + "#" + verificationMethodId).type("JsonWebKey").publicKeyJwk(publicKeyJwk);
        if (data.containsKey("c")) {
            String string5 = data.get("c");
            Intrinsics.checkNotNull((Object)string5);
            vmBuilder.controller(string5);
        } else {
            vmBuilder.controller(did);
        }
        VerificationMethod vm = vmBuilder.build();
        DidDocument.Builder.verificationMethodForPurposes$default(didDocBuilder, vm, null, 2, null);
        Map<String, String> map = keyLookup;
        Object object = new String[]{"."};
        object = StringsKt.drop((String)((String)StringsKt.split$default((CharSequence)name, (String[])object, (boolean)false, (int)0, (int)6, null).get(0)), (int)1);
        String string6 = did + "#" + verificationMethodId;
        map.put((String)object, string6);
    }

    private final void handleRootRecord(TXTRecord rr, Map<String, String> keyLookup, DidDocument.Builder doc) {
        List list = rr.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        String[] stringArray = new String[]{";"};
        List rootData = StringsKt.split$default((CharSequence)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)";", null, null, (int)0, null, null, (int)62, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"asm", (Object)new ArrayList()), TuplesKt.to((Object)"auth", (Object)new ArrayList()), TuplesKt.to((Object)"agm", (Object)new ArrayList()), TuplesKt.to((Object)"inv", (Object)new ArrayList()), TuplesKt.to((Object)"del", (Object)new ArrayList())};
        Map purposeToVmIds = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$forEach$iv = rootData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String item = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list2 = StringsKt.split$default((CharSequence)item, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String key = (String)list2.get(0);
            String values = (String)list2.get(1);
            String[] stringArray3 = new String[]{","};
            List valuesList = StringsKt.split$default((CharSequence)values, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            Iterable $this$forEach$iv2 = valuesList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                List list3 = (List)purposeToVmIds.get(key);
                if (list3 == null) continue;
                String string = keyLookup.get(it);
                Intrinsics.checkNotNull((Object)string);
                list3.add(string);
            }
        }
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("asm"), Purpose.AssertionMethod);
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("auth"), Purpose.Authentication);
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("agm"), Purpose.KeyAgreement);
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("del"), Purpose.CapabilityDelegation);
        doc.verificationMethodIdsForPurpose((List)purposeToVmIds.get("inv"), Purpose.CapabilityInvocation);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseTxtData(String data) {
        void $this$associateTo$iv$iv;
        String[] stringArray = new String[]{";"};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String key = (String)list.get(0);
            String value = (String)list.get(1);
            Pair pair = TuplesKt.to((Object)key, (Object)value);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @JvmOverloads
    @NotNull
    public final BearerDid create(@NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        return DidDhtApi.create$default(this, keyManager, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final BearerDid import(@NotNull PortableDid portableDid) {
        Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
        return DidDhtApi.import$default(this, portableDid, null, 2, null);
    }

    @JvmOverloads
    public final void publish(@NotNull KeyManager manager, @NotNull DidDocument didDocument) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        DidDhtApi.publish$default(this, manager, didDocument, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Message toDnsPacket$web5_dids(@NotNull DidDocument didDocument) {
        Intrinsics.checkNotNullParameter((Object)didDocument, (String)"didDocument");
        return DidDhtApi.toDnsPacket$web5_dids$default(this, didDocument, null, 2, null);
    }

    public /* synthetic */ DidDhtApi(DidDhtConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(configuration);
    }
}

