/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.did;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.crypto.InMemoryKeyManager;
import web5.sdk.crypto.KeyExporter;
import web5.sdk.crypto.KeyImporter;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.jwk.Jwk;
import web5.sdk.dids.did.PortableDid;
import web5.sdk.dids.didcore.Did;
import web5.sdk.dids.didcore.DidDocument;
import web5.sdk.dids.didcore.VMSelector;
import web5.sdk.dids.didcore.VerificationMethod;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014J?\u0010\u0015\u001a-\u0012#\u0012!\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00180\u0017j\u0002`\u001c\u0012\u0004\u0012\u00020\u001d0\u00162\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lweb5/sdk/dids/did/BearerDid;", "", "uri", "", "did", "Lweb5/sdk/dids/didcore/Did;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "document", "Lweb5/sdk/dids/didcore/DidDocument;", "(Ljava/lang/String;Lweb5/sdk/dids/didcore/Did;Lweb5/sdk/crypto/KeyManager;Lweb5/sdk/dids/didcore/DidDocument;)V", "getDid", "()Lweb5/sdk/dids/didcore/Did;", "getDocument", "()Lweb5/sdk/dids/didcore/DidDocument;", "getKeyManager", "()Lweb5/sdk/crypto/KeyManager;", "getUri", "()Ljava/lang/String;", "export", "Lweb5/sdk/dids/did/PortableDid;", "getSigner", "Lkotlin/Pair;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "payload", "Lweb5/sdk/dids/did/DidSigner;", "Lweb5/sdk/dids/didcore/VerificationMethod;", "selector", "Lweb5/sdk/dids/didcore/VMSelector;", "Companion", "web5-dids"})
@SourceDebugExtension(value={"SMAP\nBearerDid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BearerDid.kt\nweb5/sdk/dids/did/BearerDid\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1855#2:155\n1856#2:157\n1#3:156\n*S KotlinDebug\n*F\n+ 1 BearerDid.kt\nweb5/sdk/dids/did/BearerDid\n*L\n85#1:155\n85#1:157\n*E\n"})
public final class BearerDid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String uri;
    @NotNull
    private final Did did;
    @NotNull
    private final KeyManager keyManager;
    @NotNull
    private final DidDocument document;

    public BearerDid(@NotNull String uri, @NotNull Did did, @NotNull KeyManager keyManager, @NotNull DidDocument document) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.uri = uri;
        this.did = did;
        this.keyManager = keyManager;
        this.document = document;
    }

    @NotNull
    public final String getUri() {
        return this.uri;
    }

    @NotNull
    public final Did getDid() {
        return this.did;
    }

    @NotNull
    public final KeyManager getKeyManager() {
        return this.keyManager;
    }

    @NotNull
    public final DidDocument getDocument() {
        return this.document;
    }

    @JvmOverloads
    @NotNull
    public final Pair<Function1<byte[], byte[]>, VerificationMethod> getSigner(@Nullable VMSelector selector) {
        VerificationMethod verificationMethod = this.document.selectVerificationMethod(selector);
        Object object = verificationMethod.getPublicKeyJwk();
        if (object == null || (object = object.computeThumbprint()) == null) {
            throw new Exception("Failed to compute key alias");
        }
        Object kid = object;
        Function1 signer2 = (Function1)new Function1<byte[], byte[]>(this, (String)kid){
            final /* synthetic */ BearerDid this$0;
            final /* synthetic */ String $kid;
            {
                this.this$0 = $receiver;
                this.$kid = $kid;
                super(1);
            }

            @NotNull
            public final byte[] invoke(@NotNull byte[] payload) {
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                return this.this$0.getKeyManager().sign(this.$kid, payload);
            }
        };
        return new Pair((Object)signer2, (Object)verificationMethod);
    }

    public static /* synthetic */ Pair getSigner$default(BearerDid bearerDid, VMSelector vMSelector, int n, Object object) {
        if ((n & 1) != 0) {
            vMSelector = null;
        }
        return bearerDid.getSigner(vMSelector);
    }

    @NotNull
    public final PortableDid export() {
        if (!(this.keyManager instanceof KeyExporter)) {
            boolean $i$a$-check-BearerDid$export$22 = false;
            String $i$a$-check-BearerDid$export$22 = "KeyManager must implement KeyExporter to export keys";
            throw new IllegalStateException($i$a$-check-BearerDid$export$22.toString());
        }
        KeyManager keyManager = this.keyManager;
        Intrinsics.checkNotNull((Object)keyManager, (String)"null cannot be cast to non-null type web5.sdk.crypto.KeyExporter");
        KeyExporter keyExporter = (KeyExporter)keyManager;
        List privateKeys = new ArrayList();
        List<VerificationMethod> list = this.document.getVerificationMethod();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String keyAlias;
                Object keyAliasResult;
                Object object;
                VerificationMethod vm = (VerificationMethod)element$iv;
                boolean bl = false;
                BearerDid bearerDid = this;
                try {
                    BearerDid $this$export_u24lambda_u243_u24lambda_u241 = bearerDid;
                    boolean bl2 = false;
                    Jwk jwk = vm.getPublicKeyJwk();
                    object = Result.constructor-impl((Object)(jwk != null ? jwk.computeThumbprint() : null));
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                if (!Result.isSuccess-impl((Object)(keyAliasResult = object))) continue;
                String string = keyAlias = (String)(Result.isFailure-impl((Object)keyAliasResult) ? null : keyAliasResult);
                Intrinsics.checkNotNull((Object)string);
                Jwk key = keyExporter.exportKey(string.toString());
                boolean bl3 = false;
                privateKeys.add(key);
            }
        }
        String string = this.uri;
        DidDocument didDocument = this.document;
        Map map = MapsKt.emptyMap();
        return new PortableDid(string, privateKeys, didDocument, map);
    }

    @JvmOverloads
    @NotNull
    public final Pair<Function1<byte[], byte[]>, VerificationMethod> getSigner() {
        return BearerDid.getSigner$default(this, null, 1, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lweb5/sdk/dids/did/BearerDid$Companion;", "", "()V", "import", "Lweb5/sdk/dids/did/BearerDid;", "portableDid", "Lweb5/sdk/dids/did/PortableDid;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "web5-dids"})
    @SourceDebugExtension(value={"SMAP\nBearerDid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BearerDid.kt\nweb5/sdk/dids/did/BearerDid$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1726#2,3:155\n*S KotlinDebug\n*F\n+ 1 BearerDid.kt\nweb5/sdk/dids/did/BearerDid$Companion\n*L\n135#1:155,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        @NotNull
        public final BearerDid import(@NotNull PortableDid portableDid, @NotNull KeyManager keyManager) {
            boolean allVerificationMethodsHavePublicKey;
            block9: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
                Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
                if (!(keyManager instanceof KeyImporter)) {
                    boolean $i$a$-check-BearerDid$Companion$import$42 = false;
                    String $i$a$-check-BearerDid$Companion$import$42 = "KeyManager must implement KeyImporter to import keys";
                    throw new IllegalStateException($i$a$-check-BearerDid$Companion$import$42.toString());
                }
                List<VerificationMethod> list = portableDid.getDocument().getVerificationMethod();
                if (!(!(list != null ? list.size() == 0 : false))) {
                    boolean $i$a$-check-BearerDid$Companion$import$52 = false;
                    String $i$a$-check-BearerDid$Companion$import$52 = "PortableDID must contain at least one verification method";
                    throw new IllegalStateException($i$a$-check-BearerDid$Companion$import$52.toString());
                }
                List<VerificationMethod> $i$a$-check-BearerDid$Companion$import$52 = portableDid.getDocument().getVerificationMethod();
                if ($i$a$-check-BearerDid$Companion$import$52 != null) {
                    void $this$all$iv;
                    Iterable iterable = $i$a$-check-BearerDid$Companion$import$52;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            VerificationMethod vm = (VerificationMethod)element$iv;
                            boolean bl2 = false;
                            if (vm.getPublicKeyJwk() != null) continue;
                            bl = false;
                            break block9;
                        }
                        bl = true;
                    }
                } else {
                    bl = allVerificationMethodsHavePublicKey = false;
                }
            }
            if (!allVerificationMethodsHavePublicKey) {
                boolean $i$a$-check-BearerDid$Companion$import$62 = false;
                String $i$a$-check-BearerDid$Companion$import$62 = "Each VerificationMethod must contain a public key in Jwk format.";
                throw new IllegalStateException($i$a$-check-BearerDid$Companion$import$62.toString());
            }
            Did did = Did.Parser.parse(portableDid.getUri());
            for (Jwk key : portableDid.getPrivateKeys()) {
                KeyImporter keyImporter = (KeyImporter)keyManager;
                keyImporter.importKey(key);
            }
            return new BearerDid(portableDid.getUri(), did, keyManager, portableDid.getDocument());
        }

        public static /* synthetic */ BearerDid import$default(Companion companion, PortableDid portableDid, KeyManager keyManager, int n, Object object) {
            if ((n & 2) != 0) {
                keyManager = (KeyManager)new InMemoryKeyManager();
            }
            return companion.import(portableDid, keyManager);
        }

        @JvmOverloads
        @NotNull
        public final BearerDid import(@NotNull PortableDid portableDid) {
            Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
            return web5.sdk.dids.did.BearerDid$Companion.import$default(this, portableDid, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

