/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.key;

import io.ipfs.multibase.Multibase;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.common.Varint;
import web5.sdk.crypto.AlgorithmId;
import web5.sdk.crypto.Crypto;
import web5.sdk.crypto.InMemoryKeyManager;
import web5.sdk.crypto.KeyGenerator;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.Secp256k1;
import web5.sdk.crypto.jwk.Jwk;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.did.BearerDid;
import web5.sdk.dids.did.PortableDid;
import web5.sdk.dids.didcore.Did;
import web5.sdk.dids.didcore.DidDocument;
import web5.sdk.dids.didcore.Purpose;
import web5.sdk.dids.didcore.VerificationMethod;
import web5.sdk.dids.exceptions.InvalidMethodNameException;
import web5.sdk.dids.methods.key.CreateDidKeyOptions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lweb5/sdk/dids/methods/key/DidKey;", "", "uri", "", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "(Ljava/lang/String;Lweb5/sdk/crypto/KeyManager;)V", "getKeyManager", "()Lweb5/sdk/crypto/KeyManager;", "getUri", "()Ljava/lang/String;", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "Companion", "web5-dids"})
public final class DidKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String uri;
    @NotNull
    private final KeyManager keyManager;
    @NotNull
    public static final String methodName = "key";

    public DidKey(@NotNull String uri, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        this.uri = uri;
        this.keyManager = keyManager;
    }

    @NotNull
    public final String getUri() {
        return this.uri;
    }

    @NotNull
    public final KeyManager getKeyManager() {
        return this.keyManager;
    }

    @NotNull
    public final DidResolutionResult resolve() {
        return Companion.resolve(this.uri);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lweb5/sdk/dids/methods/key/DidKey$Companion;", "", "()V", "methodName", "", "create", "Lweb5/sdk/dids/did/BearerDid;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "options", "Lweb5/sdk/dids/methods/key/CreateDidKeyOptions;", "import", "portableDid", "Lweb5/sdk/dids/did/PortableDid;", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "did", "web5-dids"})
    @SourceDebugExtension(value={"SMAP\nDidKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidKey.kt\nweb5/sdk/dids/methods/key/DidKey$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final BearerDid create(@NotNull KeyManager keyManager, @Nullable CreateDidKeyOptions options) {
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            CreateDidKeyOptions createDidKeyOptions = options;
            if (createDidKeyOptions == null) {
                createDidKeyOptions = new CreateDidKeyOptions(null, 1, null);
            }
            CreateDidKeyOptions opts = createDidKeyOptions;
            String keyAlias = KeyManager.DefaultImpls.generatePrivateKey$default((KeyManager)keyManager, (AlgorithmId)opts.getAlgorithmId(), null, (int)2, null);
            Jwk publicKey = keyManager.getPublicKey(keyAlias);
            byte[] publicKeyBytes = Crypto.INSTANCE.publicKeyToBytes(publicKey);
            if (opts.getAlgorithmId() == AlgorithmId.secp256k1) {
                publicKeyBytes = Secp256k1.INSTANCE.compressPublicKey(publicKeyBytes);
            }
            Integer n = Crypto.INSTANCE.getAlgorithmMultiCodec(opts.getAlgorithmId());
            if (n == null) {
                throw new UnsupportedOperationException(opts.getAlgorithmId().getCurveName() + " curve not supported");
            }
            int multiCodec = n;
            byte[] multiCodecBytes = Varint.INSTANCE.encode(multiCodec);
            byte[] idBytes = ArraysKt.plus((byte[])multiCodecBytes, (byte[])publicKeyBytes);
            String multibaseEncodedId = Multibase.encode((Multibase.Base)Multibase.Base.Base58BTC, (byte[])idBytes);
            String didUrl = "did:key:" + multibaseEncodedId;
            Intrinsics.checkNotNull((Object)multibaseEncodedId);
            Did did = new Did(didUrl, didUrl, DidKey.methodName, multibaseEncodedId, null, null, null, null, 240, null);
            DidResolutionResult resolutionResult = this.resolve(didUrl);
            if (!(resolutionResult.getDidDocument() != null)) {
                boolean bl = false;
                String string = "DidDocument not found";
                throw new IllegalStateException(string.toString());
            }
            return new BearerDid(didUrl, did, keyManager, resolutionResult.getDidDocument());
        }

        public static /* synthetic */ BearerDid create$default(Companion companion, KeyManager keyManager, CreateDidKeyOptions createDidKeyOptions, int n, Object object) {
            if ((n & 2) != 0) {
                createDidKeyOptions = null;
            }
            return companion.create(keyManager, createDidKeyOptions);
        }

        @NotNull
        public final DidResolutionResult resolve(@NotNull String did) {
            Intrinsics.checkNotNullParameter((Object)did, (String)"did");
            Did parsedDid = Did.Parser.parse(did);
            if (!Intrinsics.areEqual((Object)parsedDid.getMethod(), (Object)DidKey.methodName)) {
                boolean bl = false;
                throw new IllegalArgumentException("expected did:key");
            }
            String id = parsedDid.getId();
            byte[] idBytes = Multibase.decode((String)id);
            Intrinsics.checkNotNull((Object)idBytes);
            Pair pair = Varint.INSTANCE.decode(idBytes);
            int multiCodec = ((Number)pair.component1()).intValue();
            int numBytes = ((Number)pair.component2()).intValue();
            byte[] publicKeyBytes = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])idBytes, (int)numBytes));
            KeyGenerator keyGenerator = Crypto.INSTANCE.getKeyGenerator(multiCodec);
            if (keyGenerator.getAlgorithm() == Secp256k1.INSTANCE.getAlgorithm()) {
                publicKeyBytes = Secp256k1.INSTANCE.inflatePublicKey(publicKeyBytes);
            }
            Jwk publicKeyJwk = keyGenerator.bytesToPublicKey(publicKeyBytes);
            String verificationMethodId = parsedDid.getUri() + "#" + id;
            VerificationMethod verificationMethod = new VerificationMethod.Builder().id(verificationMethodId).publicKeyJwk(publicKeyJwk).controller(did).type("JsonWebKey").build();
            Object[] objectArray = new Purpose[]{Purpose.AssertionMethod, Purpose.Authentication, Purpose.KeyAgreement, Purpose.CapabilityDelegation, Purpose.CapabilityInvocation};
            DidDocument didDocument = new DidDocument.Builder().id(did).verificationMethodForPurposes(verificationMethod, CollectionsKt.listOf((Object[])objectArray)).build();
            return new DidResolutionResult("https://w3id.org/did-resolution/v1", didDocument, null, null, 12, null);
        }

        @JvmOverloads
        @NotNull
        public final BearerDid import(@NotNull PortableDid portableDid, @NotNull KeyManager keyManager) {
            Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            Did parsedDid = Did.Parser.parse(portableDid.getUri());
            if (!Intrinsics.areEqual((Object)parsedDid.getMethod(), (Object)DidKey.methodName)) {
                throw new InvalidMethodNameException("Method not supported");
            }
            BearerDid bearerDid = BearerDid.Companion.import(portableDid, keyManager);
            List<VerificationMethod> list = bearerDid.getDocument().getVerificationMethod();
            if (!(list != null ? list.size() == 1 : false)) {
                boolean bl = false;
                String string = "DidKey DID document must contain exactly one verification method";
                throw new IllegalStateException(string.toString());
            }
            return bearerDid;
        }

        public static /* synthetic */ BearerDid import$default(Companion companion, PortableDid portableDid, KeyManager keyManager, int n, Object object) {
            if ((n & 2) != 0) {
                keyManager = (KeyManager)new InMemoryKeyManager();
            }
            return companion.import(portableDid, keyManager);
        }

        @JvmOverloads
        @NotNull
        public final BearerDid create(@NotNull KeyManager keyManager) {
            Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
            return web5.sdk.dids.methods.key.DidKey$Companion.create$default(this, keyManager, null, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final BearerDid import(@NotNull PortableDid portableDid) {
            Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
            return web5.sdk.dids.methods.key.DidKey$Companion.import$default(this, portableDid, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

