/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.engine.okhttp.OkHttp;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.ResponseException;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.serialization.Configuration;
import io.ktor.serialization.jackson.JacksonConverterKt;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.common.Json;
import web5.sdk.crypto.InMemoryKeyManager;
import web5.sdk.crypto.KeyManager;
import web5.sdk.dids.DidResolutionResult;
import web5.sdk.dids.ResolutionError;
import web5.sdk.dids.did.BearerDid;
import web5.sdk.dids.did.PortableDid;
import web5.sdk.dids.didcore.Did;
import web5.sdk.dids.didcore.DidDocument;
import web5.sdk.dids.exceptions.ParserException;
import web5.sdk.dids.methods.web.DidWebApi;
import web5.sdk.dids.methods.web.DidWebApiConfiguration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u001e\u001f\u00a8\u0006 "}, d2={"Lweb5/sdk/dids/methods/web/DidWebApi;", "", "configuration", "Lweb5/sdk/dids/methods/web/DidWebApiConfiguration;", "(Lweb5/sdk/dids/methods/web/DidWebApiConfiguration;)V", "client", "Lio/ktor/client/HttpClient;", "engine", "Lio/ktor/client/engine/HttpClientEngine;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "decodeId", "parsedDid", "Lweb5/sdk/dids/didcore/Did;", "import", "Lweb5/sdk/dids/did/BearerDid;", "portableDid", "Lweb5/sdk/dids/did/PortableDid;", "keyManager", "Lweb5/sdk/crypto/KeyManager;", "resolve", "Lweb5/sdk/dids/DidResolutionResult;", "did", "resolveInternal", "Lweb5/sdk/dids/methods/web/DidWeb$Default;", "Lweb5/sdk/dids/methods/web/DidWebApiImpl;", "web5-dids"})
public abstract class DidWebApi {
    @NotNull
    private final String methodName;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private final ObjectMapper mapper = Json.INSTANCE.getJsonMapper();
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final HttpClient client;

    private DidWebApi(DidWebApiConfiguration configuration) {
        this.methodName = "web";
        HttpClientEngine httpClientEngine = configuration.getEngine();
        if (httpClientEngine == null) {
            httpClientEngine = OkHttp.INSTANCE.create((Function1)engine.1.INSTANCE);
        }
        this.engine = httpClientEngine;
        this.client = HttpClientKt.HttpClient((HttpClientEngine)this.engine, (Function1)new Function1<HttpClientConfig<?>, Unit>(this){
            final /* synthetic */ DidWebApi this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HttpClientConfig<?> $this$HttpClient) {
                Intrinsics.checkNotNullParameter($this$HttpClient, (String)"$this$HttpClient");
                $this$HttpClient.install((HttpClientPlugin)ContentNegotiation.Plugin, (Function1)new Function1<ContentNegotiation.Config, Unit>(this.this$0){
                    final /* synthetic */ DidWebApi this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ContentNegotiation.Config $this$install) {
                        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
                        JacksonConverterKt.jackson$default((Configuration)((Configuration)$this$install), null, (boolean)false, (Function1)((Function1)new Function1<ObjectMapper, Unit>(this.this$0){
                            final /* synthetic */ DidWebApi this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ObjectMapper $this$jackson) {
                                Intrinsics.checkNotNullParameter((Object)$this$jackson, (String)"$this$jackson");
                                DidWebApi.access$getMapper$p(this.this$0);
                            }
                        }), (int)3, null);
                    }
                });
            }
        });
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final DidResolutionResult resolve(@NotNull String did) {
        DidResolutionResult didResolutionResult;
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        try {
            didResolutionResult = this.resolveInternal(did);
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, (Function0)new Function0<Object>(did, e){
                final /* synthetic */ String $did;
                final /* synthetic */ Exception $e;
                {
                    this.$did = $did;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "resolving DID " + this.$did + " failed, " + this.$e.getMessage();
                }
            });
            didResolutionResult = DidResolutionResult.Companion.fromResolutionError(ResolutionError.INTERNAL_ERROR);
        }
        return didResolutionResult;
    }

    @JvmOverloads
    @NotNull
    public final BearerDid import(@NotNull PortableDid portableDid, @NotNull KeyManager keyManager) {
        Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
        Intrinsics.checkNotNullParameter((Object)keyManager, (String)"keyManager");
        return BearerDid.Companion.import(portableDid, keyManager);
    }

    public static /* synthetic */ BearerDid import$default(DidWebApi didWebApi, PortableDid portableDid, KeyManager keyManager, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: import");
        }
        if ((n & 2) != 0) {
            keyManager = (KeyManager)new InMemoryKeyManager();
        }
        return didWebApi.import(portableDid, keyManager);
    }

    private final DidResolutionResult resolveInternal(String did) {
        HttpResponse httpResponse;
        Did did2;
        try {
            did2 = Did.Parser.parse(did);
        }
        catch (ParserException parserException) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.INVALID_DID);
        }
        Did parsedDid = did2;
        if (!Intrinsics.areEqual((Object)parsedDid.getMethod(), (Object)this.methodName)) {
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.METHOD_NOT_SUPPORTED);
        }
        String docURL = this.decodeId(parsedDid);
        try {
            httpResponse = (HttpResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, docURL, null){
                int label;
                final /* synthetic */ DidWebApi this$0;
                final /* synthetic */ String $docURL;
                {
                    this.this$0 = $receiver;
                    this.$docURL = $docURL;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$get$iv$iv$iv;
                            HttpRequestBuilder httpRequestBuilder;
                            void $this$get$iv;
                            ResultKt.throwOnFailure((Object)object);
                            HttpClient httpClient = DidWebApi.access$getClient$p(this.this$0);
                            String urlString$iv = this.$docURL;
                            boolean $i$f$get = false;
                            void $this$get$iv$iv = $this$get$iv;
                            boolean $i$f$get2 = false;
                            void var7_10 = $this$get$iv$iv;
                            HttpRequestBuilder $this$get_u24lambda_u244$iv = httpRequestBuilder = new HttpRequestBuilder();
                            boolean bl = false;
                            HttpRequestKt.url((HttpRequestBuilder)$this$get_u24lambda_u244$iv, (String)urlString$iv);
                            HttpRequestBuilder $this$invokeSuspend_u24lambda_u240 = $this$get_u24lambda_u244$iv;
                            boolean bl2 = false;
                            HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$invokeSuspend_u24lambda_u240), (ContentType)ContentType.Application.INSTANCE.getJson());
                            HttpRequestBuilder builder$iv$iv$iv = httpRequestBuilder;
                            boolean $i$f$get3 = false;
                            builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                            void $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                            boolean $i$f$request = false;
                            this.label = 1;
                            Object object3 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$get = false;
                            boolean $i$f$get4 = false;
                            boolean $i$f$get5 = false;
                            boolean $i$f$request = false;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (UnknownHostException e) {
            this.logger.warn((Throwable)e, (Function0)new Function0<Object>(did, e){
                final /* synthetic */ String $did;
                final /* synthetic */ UnknownHostException $e;
                {
                    this.$did = $did;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "failed to make GET request to " + this.$did + " doc URL, " + this.$e.getMessage();
                }
            });
            return DidResolutionResult.Companion.fromResolutionError(ResolutionError.NOT_FOUND);
        }
        HttpResponse resp2 = httpResponse;
        String body2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(resp2, null){
            int label;
            final /* synthetic */ HttpResponse $resp;
            {
                this.$resp = $resp;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpResponseKt.bodyAsText$default((HttpResponse)this.$resp, null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!HttpStatusCodeKt.isSuccess((HttpStatusCode)resp2.getStatus())) {
            throw new ResponseException(resp2, "resolution error response: '" + body2 + "'");
        }
        return new DidResolutionResult(null, (DidDocument)this.mapper.readValue(body2, DidDocument.class), null, null, 13, null);
    }

    private final String decodeId(Did parsedDid) {
        StringBuilder stringBuilder;
        String domainNameWithPath = StringsKt.replace$default((String)parsedDid.getId(), (String)":", (String)"/", (boolean)false, (int)4, null);
        String decodedDomain = URLDecoder.decode(domainNameWithPath, Charsets.UTF_8);
        URL url = new URL("https://" + decodedDomain);
        StringBuilder $this$decodeId_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$decodeId_u24lambda_u240.append(Intrinsics.areEqual((Object)url.getHost(), (Object)"localhost") || Intrinsics.areEqual((Object)url.getHost(), (Object)"127.0.0.1") ? "http://" : "https://");
        $this$decodeId_u24lambda_u240.append(decodedDomain);
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (((CharSequence)string).length() == 0) {
            $this$decodeId_u24lambda_u240.append("/.well-known");
        }
        $this$decodeId_u24lambda_u240.append("/did.json");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @JvmOverloads
    @NotNull
    public final BearerDid import(@NotNull PortableDid portableDid) {
        Intrinsics.checkNotNullParameter((Object)portableDid, (String)"portableDid");
        return DidWebApi.import$default(this, portableDid, null, 2, null);
    }

    public /* synthetic */ DidWebApi(DidWebApiConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(configuration);
    }

    public static final /* synthetic */ HttpClient access$getClient$p(DidWebApi $this) {
        return $this.client;
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(DidWebApi $this) {
        return $this.mapper;
    }
}

