/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.keymanager.aws;

import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.CreateAliasRequest;
import com.amazonaws.services.kms.model.CreateKeyRequest;
import com.amazonaws.services.kms.model.CreateKeyResult;
import com.amazonaws.services.kms.model.DescribeKeyRequest;
import com.amazonaws.services.kms.model.DescribeKeyResult;
import com.amazonaws.services.kms.model.GetPublicKeyRequest;
import com.amazonaws.services.kms.model.GetPublicKeyResult;
import com.amazonaws.services.kms.model.KeySpec;
import com.amazonaws.services.kms.model.KeyUsageType;
import com.amazonaws.services.kms.model.MessageType;
import com.amazonaws.services.kms.model.SignRequest;
import com.amazonaws.services.kms.model.SignResult;
import com.amazonaws.services.kms.model.SigningAlgorithmSpec;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.impl.ECDSA;
import com.nimbusds.jose.jwk.ECKey;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.crypto.AlgorithmId;
import web5.sdk.crypto.Jwa;
import web5.sdk.crypto.JwaCurve;
import web5.sdk.crypto.KeyGenOptions;
import web5.sdk.crypto.KeyManager;
import web5.sdk.crypto.jwk.Jwk;
import web5.sdk.keymanager.aws.AwsKeyManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001)B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010!\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020 H\u0016J\u0018\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0002J\f\u0010'\u001a\u00020\f*\u00020 H\u0002J\f\u0010(\u001a\u00020\u000e*\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lweb5/sdk/keymanager/aws/AwsKeyManager;", "Lweb5/sdk/crypto/KeyManager;", "kmsClient", "Lcom/amazonaws/services/kms/AWSKMS;", "(Lcom/amazonaws/services/kms/AWSKMS;)V", "algorithmDetails", "", "Lweb5/sdk/crypto/AlgorithmId;", "Lweb5/sdk/keymanager/aws/AwsKeyManager$AlgorithmDetails;", "convertToJavaPublicKey", "Ljava/security/PublicKey;", "publicKeyDerBytes", "Ljava/nio/ByteBuffer;", "fetchKeySpec", "Lcom/amazonaws/services/kms/model/KeySpec;", "keyAlias", "", "generatePrivateKey", "algorithmId", "options", "Lweb5/sdk/crypto/KeyGenOptions;", "getAlgorithmDetails", "keySpec", "getDeterministicAlias", "publicKey", "Lweb5/sdk/crypto/jwk/Jwk;", "getPublicKey", "setKeyAlias", "", "existingAlias", "newAlias", "shaDigest", "", "signingInput", "sign", "transcodeDerSignatureToConcat", "derSignature", "algorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "asByteBuffer", "enum", "AlgorithmDetails", "web5-keymanager-aws"})
@SourceDebugExtension(value={"SMAP\nAwsKeyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsKeyManager.kt\nweb5/sdk/keymanager/aws/AwsKeyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n288#2,2:227\n*S KotlinDebug\n*F\n+ 1 AwsKeyManager.kt\nweb5/sdk/keymanager/aws/AwsKeyManager\n*L\n93#1:227,2\n*E\n"})
public final class AwsKeyManager
implements KeyManager {
    @NotNull
    private final AWSKMS kmsClient;
    @NotNull
    private final Map<AlgorithmId, AlgorithmDetails> algorithmDetails;

    @JvmOverloads
    public AwsKeyManager(@NotNull AWSKMS kmsClient) {
        Intrinsics.checkNotNullParameter((Object)kmsClient, (String)"kmsClient");
        this.kmsClient = kmsClient;
        this.algorithmDetails = MapsKt.mapOf((Pair)TuplesKt.to((Object)AlgorithmId.secp256k1, (Object)new AlgorithmDetails(Jwa.ES256K, JwaCurve.secp256k1, KeySpec.ECC_SECG_P256K1, SigningAlgorithmSpec.ECDSA_SHA_256, (Function0<? extends ExtendedDigest>)((Function0)algorithmDetails.1.INSTANCE))));
    }

    public /* synthetic */ AwsKeyManager(AWSKMS aWSKMS, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Object object = AWSKMSClientBuilder.standard().build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
            aWSKMS = (AWSKMS)object;
        }
        this(aWSKMS);
    }

    private final AlgorithmDetails getAlgorithmDetails(AlgorithmId algorithmId) {
        AlgorithmDetails algorithmDetails2 = this.algorithmDetails.get(algorithmId);
        if (algorithmDetails2 == null) {
            throw new IllegalArgumentException("Algorithm " + algorithmId.getAlgorithmName() + " is not supported");
        }
        return algorithmDetails2;
    }

    private final AlgorithmDetails getAlgorithmDetails(KeySpec keySpec) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.algorithmDetails.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AlgorithmDetails it = (AlgorithmDetails)element$iv;
                boolean bl = false;
                if (!(it.getKeySpec() == keySpec)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        AlgorithmDetails algorithmDetails2 = v0;
        if (algorithmDetails2 == null) {
            throw new IllegalArgumentException("KeySpec " + keySpec + " is not supported");
        }
        return algorithmDetails2;
    }

    @NotNull
    public String generatePrivateKey(@NotNull AlgorithmId algorithmId, @Nullable KeyGenOptions options) {
        Intrinsics.checkNotNullParameter((Object)algorithmId, (String)"algorithmId");
        KeySpec keySpec = this.getAlgorithmDetails(algorithmId).getKeySpec();
        CreateKeyRequest createKeyRequest = new CreateKeyRequest().withKeySpec(keySpec).withKeyUsage(KeyUsageType.SIGN_VERIFY);
        CreateKeyResult createKeyResponse = this.kmsClient.createKey(createKeyRequest);
        String keyId = createKeyResponse.getKeyMetadata().getKeyId();
        Intrinsics.checkNotNull((Object)keyId);
        Jwk publicKey = this.getPublicKey(keyId);
        String alias = this.getDeterministicAlias(publicKey);
        this.setKeyAlias(keyId, alias);
        return alias;
    }

    @NotNull
    public Jwk getPublicKey(@NotNull String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        GetPublicKeyRequest getPublicKeyRequest = new GetPublicKeyRequest().withKeyId(keyAlias);
        GetPublicKeyResult publicKeyResponse = this.kmsClient.getPublicKey(getPublicKeyRequest);
        ByteBuffer byteBuffer = publicKeyResponse.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getPublicKey(...)");
        PublicKey publicKey = this.convertToJavaPublicKey(byteBuffer);
        String string = publicKeyResponse.getKeySpec();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeySpec(...)");
        AlgorithmDetails algorithmDetails2 = this.getAlgorithmDetails(this.enum(string));
        if (!(publicKey instanceof ECPublicKey)) {
            throw new IllegalArgumentException("Unknown key type " + publicKey);
        }
        ECKey key = new ECKey.Builder(JwaCurve.Companion.toNimbusCurve(algorithmDetails2.getCurve()), (ECPublicKey)publicKey).build();
        String string2 = key.getCurve().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Jwk.Builder builder = new Jwk.Builder("EC", string2);
        String string3 = key.getX().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        Jwk.Builder builder2 = builder.x(string3);
        String string4 = key.getY().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        Jwk.Builder jwkBuilder = builder2.y(string4);
        return jwkBuilder.build();
    }

    @NotNull
    public byte[] sign(@NotNull String keyAlias, @NotNull byte[] signingInput) {
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkNotNullParameter((Object)signingInput, (String)"signingInput");
        KeySpec keySpec = this.fetchKeySpec(keyAlias);
        AlgorithmDetails algorithmDetails2 = this.getAlgorithmDetails(keySpec);
        byte[] hashedMessage = this.shaDigest(algorithmDetails2, signingInput);
        SignRequest signRequest = new SignRequest().withKeyId(keyAlias).withMessageType(MessageType.DIGEST).withMessage(this.asByteBuffer(hashedMessage)).withSigningAlgorithm(algorithmDetails2.getSigningAlgorithm());
        SignResult signResponse = this.kmsClient.sign(signRequest);
        byte[] derSignatureBytes = signResponse.getSignature().array();
        Intrinsics.checkNotNull((Object)derSignatureBytes);
        return this.transcodeDerSignatureToConcat(derSignatureBytes, Jwa.Companion.toJwsAlgorithm(algorithmDetails2.getAlgorithm()));
    }

    @NotNull
    public String getDeterministicAlias(@NotNull Jwk publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        String jwkThumbprint = publicKey.computeThumbprint();
        return "alias/" + jwkThumbprint;
    }

    private final void setKeyAlias(String existingAlias, String newAlias) {
        CreateAliasRequest createAliasRequest = new CreateAliasRequest().withAliasName(newAlias).withTargetKeyId(existingAlias);
        this.kmsClient.createAlias(createAliasRequest);
    }

    private final PublicKey convertToJavaPublicKey(ByteBuffer publicKeyDerBytes) {
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKeyDerBytes.array());
        PublicKey publicKey = new JcaPEMKeyConverter().getPublicKey(publicKeyInfo);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublicKey(...)");
        return publicKey;
    }

    private final KeySpec fetchKeySpec(String keyAlias) {
        DescribeKeyRequest describeKeyRequest = new DescribeKeyRequest().withKeyId(keyAlias);
        DescribeKeyResult describeKeyResponse = this.kmsClient.describeKey(describeKeyRequest);
        String string = describeKeyResponse.getKeyMetadata().getKeySpec();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeySpec(...)");
        return this.enum(string);
    }

    private final byte[] shaDigest(AlgorithmDetails algorithmDetails2, byte[] signingInput) {
        ExtendedDigest digest = (ExtendedDigest)algorithmDetails2.getNewDigest().invoke();
        digest.update(signingInput, 0, signingInput.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    private final ByteBuffer asByteBuffer(byte[] $this$asByteBuffer) {
        ByteBuffer byteBuffer = ByteBuffer.wrap($this$asByteBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return byteBuffer;
    }

    private final KeySpec enum(String $this$enum) {
        KeySpec keySpec = KeySpec.fromValue((String)$this$enum);
        Intrinsics.checkNotNullExpressionValue((Object)keySpec, (String)"fromValue(...)");
        return keySpec;
    }

    private final byte[] transcodeDerSignatureToConcat(byte[] derSignature, JWSAlgorithm algorithm) {
        int signatureLength = ECDSA.getSignatureByteArrayLength((JWSAlgorithm)algorithm);
        byte[] jwsSignature = ECDSA.transcodeSignatureToConcat((byte[])derSignature, (int)signatureLength);
        ECDSA.ensureLegalSignature((byte[])jwsSignature, (JWSAlgorithm)algorithm);
        Intrinsics.checkNotNull((Object)jwsSignature);
        return jwsSignature;
    }

    @JvmOverloads
    public AwsKeyManager() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JA\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lweb5/sdk/keymanager/aws/AwsKeyManager$AlgorithmDetails;", "", "algorithm", "Lweb5/sdk/crypto/Jwa;", "curve", "Lweb5/sdk/crypto/JwaCurve;", "keySpec", "Lcom/amazonaws/services/kms/model/KeySpec;", "signingAlgorithm", "Lcom/amazonaws/services/kms/model/SigningAlgorithmSpec;", "newDigest", "Lkotlin/Function0;", "Lorg/bouncycastle/crypto/ExtendedDigest;", "(Lweb5/sdk/crypto/Jwa;Lweb5/sdk/crypto/JwaCurve;Lcom/amazonaws/services/kms/model/KeySpec;Lcom/amazonaws/services/kms/model/SigningAlgorithmSpec;Lkotlin/jvm/functions/Function0;)V", "getAlgorithm", "()Lweb5/sdk/crypto/Jwa;", "getCurve", "()Lweb5/sdk/crypto/JwaCurve;", "getKeySpec", "()Lcom/amazonaws/services/kms/model/KeySpec;", "getNewDigest", "()Lkotlin/jvm/functions/Function0;", "getSigningAlgorithm", "()Lcom/amazonaws/services/kms/model/SigningAlgorithmSpec;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "web5-keymanager-aws"})
    private static final class AlgorithmDetails {
        @NotNull
        private final Jwa algorithm;
        @NotNull
        private final JwaCurve curve;
        @NotNull
        private final KeySpec keySpec;
        @NotNull
        private final SigningAlgorithmSpec signingAlgorithm;
        @NotNull
        private final Function0<ExtendedDigest> newDigest;

        public AlgorithmDetails(@NotNull Jwa algorithm, @NotNull JwaCurve curve, @NotNull KeySpec keySpec, @NotNull SigningAlgorithmSpec signingAlgorithm, @NotNull Function0<? extends ExtendedDigest> newDigest) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
            Intrinsics.checkNotNullParameter((Object)signingAlgorithm, (String)"signingAlgorithm");
            Intrinsics.checkNotNullParameter(newDigest, (String)"newDigest");
            this.algorithm = algorithm;
            this.curve = curve;
            this.keySpec = keySpec;
            this.signingAlgorithm = signingAlgorithm;
            this.newDigest = newDigest;
        }

        @NotNull
        public final Jwa getAlgorithm() {
            return this.algorithm;
        }

        @NotNull
        public final JwaCurve getCurve() {
            return this.curve;
        }

        @NotNull
        public final KeySpec getKeySpec() {
            return this.keySpec;
        }

        @NotNull
        public final SigningAlgorithmSpec getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        @NotNull
        public final Function0<ExtendedDigest> getNewDigest() {
            return this.newDigest;
        }

        @NotNull
        public final Jwa component1() {
            return this.algorithm;
        }

        @NotNull
        public final JwaCurve component2() {
            return this.curve;
        }

        @NotNull
        public final KeySpec component3() {
            return this.keySpec;
        }

        @NotNull
        public final SigningAlgorithmSpec component4() {
            return this.signingAlgorithm;
        }

        @NotNull
        public final Function0<ExtendedDigest> component5() {
            return this.newDigest;
        }

        @NotNull
        public final AlgorithmDetails copy(@NotNull Jwa algorithm, @NotNull JwaCurve curve, @NotNull KeySpec keySpec, @NotNull SigningAlgorithmSpec signingAlgorithm, @NotNull Function0<? extends ExtendedDigest> newDigest) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
            Intrinsics.checkNotNullParameter((Object)signingAlgorithm, (String)"signingAlgorithm");
            Intrinsics.checkNotNullParameter(newDigest, (String)"newDigest");
            return new AlgorithmDetails(algorithm, curve, keySpec, signingAlgorithm, newDigest);
        }

        public static /* synthetic */ AlgorithmDetails copy$default(AlgorithmDetails algorithmDetails2, Jwa jwa, JwaCurve jwaCurve, KeySpec keySpec, SigningAlgorithmSpec signingAlgorithmSpec, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                jwa = algorithmDetails2.algorithm;
            }
            if ((n & 2) != 0) {
                jwaCurve = algorithmDetails2.curve;
            }
            if ((n & 4) != 0) {
                keySpec = algorithmDetails2.keySpec;
            }
            if ((n & 8) != 0) {
                signingAlgorithmSpec = algorithmDetails2.signingAlgorithm;
            }
            if ((n & 0x10) != 0) {
                function0 = algorithmDetails2.newDigest;
            }
            return algorithmDetails2.copy(jwa, jwaCurve, keySpec, signingAlgorithmSpec, function0);
        }

        @NotNull
        public String toString() {
            return "AlgorithmDetails(algorithm=" + this.algorithm + ", curve=" + this.curve + ", keySpec=" + this.keySpec + ", signingAlgorithm=" + this.signingAlgorithm + ", newDigest=" + this.newDigest + ")";
        }

        public int hashCode() {
            int result = this.algorithm.hashCode();
            result = result * 31 + this.curve.hashCode();
            result = result * 31 + this.keySpec.hashCode();
            result = result * 31 + this.signingAlgorithm.hashCode();
            result = result * 31 + this.newDigest.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AlgorithmDetails)) {
                return false;
            }
            AlgorithmDetails algorithmDetails2 = (AlgorithmDetails)other;
            if (this.algorithm != algorithmDetails2.algorithm) {
                return false;
            }
            if (this.curve != algorithmDetails2.curve) {
                return false;
            }
            if (this.keySpec != algorithmDetails2.keySpec) {
                return false;
            }
            if (this.signingAlgorithm != algorithmDetails2.signingAlgorithm) {
                return false;
            }
            return Intrinsics.areEqual(this.newDigest, algorithmDetails2.newDigest);
        }
    }
}

