/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.crypto.keys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import web5.sdk.Web5Exception;
import web5.sdk.crypto.keys.Jwk;
import web5.sdk.crypto.keys.KeyExporter;
import web5.sdk.crypto.keys.KeyManager;
import web5.sdk.crypto.signers.ToOuterSigner;
import web5.sdk.rust.JwkData;
import web5.sdk.rust.Signer;
import web5.sdk.rust.Web5Exception;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lweb5/sdk/crypto/keys/InMemoryKeyManager;", "Lweb5/sdk/crypto/keys/KeyManager;", "Lweb5/sdk/crypto/keys/KeyExporter;", "privateJwks", "", "Lweb5/sdk/crypto/keys/Jwk;", "(Ljava/util/List;)V", "rustCoreInMemoryKeyManager", "Lweb5/sdk/rust/InMemoryKeyManager;", "exportPrivateJwks", "getSigner", "Lweb5/sdk/crypto/signers/Signer;", "publicJwk", "importPrivateJwk", "privateJwk", "web5"})
@SourceDebugExtension(value={"SMAP\nInMemoryKeyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryKeyManager.kt\nweb5/sdk/crypto/keys/InMemoryKeyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1855#2,2:62\n1549#2:64\n1620#2,3:65\n*S KotlinDebug\n*F\n+ 1 InMemoryKeyManager.kt\nweb5/sdk/crypto/keys/InMemoryKeyManager\n*L\n18#1:62,2\n56#1:64\n56#1:65,3\n*E\n"})
public final class InMemoryKeyManager
implements KeyManager,
KeyExporter {
    @NotNull
    private final web5.sdk.rust.InMemoryKeyManager rustCoreInMemoryKeyManager;

    public InMemoryKeyManager(@NotNull List<Jwk> privateJwks) {
        Intrinsics.checkNotNullParameter(privateJwks, "privateJwks");
        this.rustCoreInMemoryKeyManager = new web5.sdk.rust.InMemoryKeyManager();
        Iterable $this$forEach$iv = privateJwks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Jwk it = (Jwk)element$iv;
            boolean bl = false;
            this.rustCoreInMemoryKeyManager.importPrivateJwk(it.getRustCoreJwkData$web5());
        }
    }

    @Override
    @NotNull
    public Jwk importPrivateJwk(@NotNull Jwk privateJwk) {
        Intrinsics.checkNotNullParameter(privateJwk, "privateJwk");
        try {
            JwkData rustCoreJwkData = this.rustCoreInMemoryKeyManager.importPrivateJwk(privateJwk.getRustCoreJwkData$web5());
            return Jwk.Companion.fromRustCoreJwkData$web5(rustCoreJwkData);
        }
        catch (Web5Exception.Exception e) {
            throw Web5Exception.Companion.fromRustCore$web5(e);
        }
    }

    @Override
    @NotNull
    public web5.sdk.crypto.signers.Signer getSigner(@NotNull Jwk publicJwk) {
        Intrinsics.checkNotNullParameter(publicJwk, "publicJwk");
        try {
            Signer rustCoreSigner = this.rustCoreInMemoryKeyManager.getSigner(publicJwk.getRustCoreJwkData$web5());
            return new ToOuterSigner(rustCoreSigner);
        }
        catch (Web5Exception.Exception e) {
            throw Web5Exception.Companion.fromRustCore$web5(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Jwk> exportPrivateJwks() {
        try {
            void $this$mapTo$iv$iv;
            List<JwkData> rustCorePrivateJwksData = this.rustCoreInMemoryKeyManager.exportPrivateJwks();
            Iterable $this$map$iv = rustCorePrivateJwksData;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JwkData jwkData = (JwkData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Jwk.Companion.fromRustCoreJwkData$web5((JwkData)it));
            }
            return (List)destination$iv$iv;
        }
        catch (Web5Exception.Exception e) {
            throw Web5Exception.Companion.fromRustCore$web5(e);
        }
    }
}

