/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.crypto.keys;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import web5.sdk.crypto.keys.Jwk;
import web5.sdk.crypto.keys.KeyManager;
import web5.sdk.crypto.signers.ToOuterSigner;
import web5.sdk.rust.JwkData;
import web5.sdk.rust.Signer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lweb5/sdk/crypto/keys/ToOuterKeyManager;", "Lweb5/sdk/crypto/keys/KeyManager;", "rustCoreKeyManager", "Lweb5/sdk/rust/KeyManager;", "(Lweb5/sdk/rust/KeyManager;)V", "getSigner", "Lweb5/sdk/crypto/signers/Signer;", "publicJwk", "Lweb5/sdk/crypto/keys/Jwk;", "importPrivateJwk", "privateJwk", "web5"})
public final class ToOuterKeyManager
implements KeyManager {
    @NotNull
    private final web5.sdk.rust.KeyManager rustCoreKeyManager;

    public ToOuterKeyManager(@NotNull web5.sdk.rust.KeyManager rustCoreKeyManager) {
        Intrinsics.checkNotNullParameter(rustCoreKeyManager, "rustCoreKeyManager");
        this.rustCoreKeyManager = rustCoreKeyManager;
    }

    @Override
    @NotNull
    public Jwk importPrivateJwk(@NotNull Jwk privateJwk) {
        Intrinsics.checkNotNullParameter(privateJwk, "privateJwk");
        JwkData rustCoreJwkData = this.rustCoreKeyManager.importPrivateJwk(privateJwk.getRustCoreJwkData$web5());
        return Jwk.Companion.fromRustCoreJwkData$web5(rustCoreJwkData);
    }

    @Override
    @NotNull
    public web5.sdk.crypto.signers.Signer getSigner(@NotNull Jwk publicJwk) {
        Intrinsics.checkNotNullParameter(publicJwk, "publicJwk");
        Signer rustCoreSigner = this.rustCoreKeyManager.getSigner(publicJwk.getRustCoreJwkData$web5());
        return new ToOuterSigner(rustCoreSigner);
    }
}

