/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.crypto.signers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import web5.sdk.Web5Exception;
import web5.sdk.crypto.keys.Jwk;
import web5.sdk.crypto.signers.Signer;
import web5.sdk.rust.Web5Exception;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lweb5/sdk/crypto/signers/Secp256k1Signer;", "Lweb5/sdk/crypto/signers/Signer;", "privateJwk", "Lweb5/sdk/crypto/keys/Jwk;", "(Lweb5/sdk/crypto/keys/Jwk;)V", "rustCoreSigner", "Lweb5/sdk/rust/Secp256k1Signer;", "sign", "", "payload", "web5"})
public final class Secp256k1Signer
implements Signer {
    @NotNull
    private final web5.sdk.rust.Secp256k1Signer rustCoreSigner;

    public Secp256k1Signer(@NotNull Jwk privateJwk) {
        Intrinsics.checkNotNullParameter(privateJwk, "privateJwk");
        this.rustCoreSigner = new web5.sdk.rust.Secp256k1Signer(privateJwk.getRustCoreJwkData$web5());
    }

    @Override
    @NotNull
    public byte[] sign(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        try {
            return this.rustCoreSigner.sign(payload);
        }
        catch (Web5Exception.Exception e) {
            throw Web5Exception.Companion.fromRustCore$web5(e);
        }
    }
}

