/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.crypto.verifiers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import web5.sdk.Web5Exception;
import web5.sdk.crypto.keys.Jwk;
import web5.sdk.crypto.verifiers.Verifier;
import web5.sdk.rust.Web5Exception;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lweb5/sdk/crypto/verifiers/Secp256k1Verifier;", "Lweb5/sdk/crypto/verifiers/Verifier;", "publicJwk", "Lweb5/sdk/crypto/keys/Jwk;", "(Lweb5/sdk/crypto/keys/Jwk;)V", "rustCoreVerifier", "Lweb5/sdk/rust/Secp256k1Verifier;", "verify", "", "message", "", "signature", "web5"})
public final class Secp256k1Verifier
implements Verifier {
    @NotNull
    private final web5.sdk.rust.Secp256k1Verifier rustCoreVerifier;

    public Secp256k1Verifier(@NotNull Jwk publicJwk) {
        Intrinsics.checkNotNullParameter(publicJwk, "publicJwk");
        this.rustCoreVerifier = new web5.sdk.rust.Secp256k1Verifier(publicJwk.getRustCoreJwkData$web5());
    }

    @Override
    public void verify(@NotNull byte[] message, @NotNull byte[] signature2) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        try {
            this.rustCoreVerifier.verify(message, signature2);
        }
        catch (Web5Exception.Exception e) {
            throw Web5Exception.Companion.fromRustCore$web5(e);
        }
    }
}

