/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.dids.methods.jwk;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.Web5Exception;
import web5.sdk.crypto.DsaKt;
import web5.sdk.crypto.keys.KeyManager;
import web5.sdk.crypto.keys.ToInnerKeyManager;
import web5.sdk.dids.BearerDid;
import web5.sdk.dids.ResolutionResult;
import web5.sdk.dids.methods.jwk.DidJwkCreateOptions;
import web5.sdk.rust.Dsa;
import web5.sdk.rust.UniFFIKt;
import web5.sdk.rust.Web5Exception;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lweb5/sdk/dids/methods/jwk/DidJwk;", "", "()V", "Companion", "web5"})
public final class DidJwk {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final ResolutionResult resolve(@NotNull String uri) {
        return Companion.resolve(uri);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lweb5/sdk/dids/methods/jwk/DidJwk$Companion;", "", "()V", "create", "Lweb5/sdk/dids/BearerDid;", "options", "Lweb5/sdk/dids/methods/jwk/DidJwkCreateOptions;", "resolve", "Lweb5/sdk/dids/ResolutionResult;", "uri", "", "web5"})
    @SourceDebugExtension(value={"SMAP\nDidJwk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidJwk.kt\nweb5/sdk/dids/methods/jwk/DidJwk$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BearerDid create(@Nullable DidJwkCreateOptions options2) {
            try {
                web5.sdk.rust.DidJwkCreateOptions didJwkCreateOptions;
                DidJwkCreateOptions didJwkCreateOptions2 = options2;
                if (didJwkCreateOptions2 != null) {
                    Dsa dsa;
                    ToInnerKeyManager toInnerKeyManager;
                    Object it;
                    DidJwkCreateOptions opts = didJwkCreateOptions2;
                    boolean bl = false;
                    KeyManager keyManager = opts.getKeyManager();
                    if (keyManager != null) {
                        it = keyManager;
                        boolean bl2 = false;
                        toInnerKeyManager = new ToInnerKeyManager((KeyManager)it);
                    } else {
                        toInnerKeyManager = null;
                    }
                    web5.sdk.rust.KeyManager keyManager2 = toInnerKeyManager;
                    web5.sdk.crypto.Dsa dsa2 = opts.getDsa();
                    if (dsa2 != null) {
                        it = dsa2;
                        web5.sdk.rust.KeyManager keyManager3 = keyManager2;
                        boolean bl3 = false;
                        dsa = DsaKt.dsaToRustCore((web5.sdk.crypto.Dsa)((Object)it));
                        keyManager2 = keyManager3;
                    } else {
                        dsa = null;
                    }
                    Dsa dsa3 = dsa;
                    web5.sdk.rust.KeyManager keyManager4 = keyManager2;
                    didJwkCreateOptions = new web5.sdk.rust.DidJwkCreateOptions(keyManager4, dsa3);
                } else {
                    didJwkCreateOptions = null;
                }
                web5.sdk.rust.DidJwkCreateOptions rustCoreOptions = didJwkCreateOptions;
                web5.sdk.rust.BearerDid rustCoreBearerDid = UniFFIKt.didJwkCreate(rustCoreOptions);
                return BearerDid.Companion.fromRustCoreBearerDid$web5(rustCoreBearerDid);
            }
            catch (Web5Exception.Exception e) {
                throw Web5Exception.Companion.fromRustCore$web5(e);
            }
        }

        public static /* synthetic */ BearerDid create$default(Companion companion, DidJwkCreateOptions didJwkCreateOptions, int n, Object object) {
            if ((n & 1) != 0) {
                didJwkCreateOptions = null;
            }
            return companion.create(didJwkCreateOptions);
        }

        @JvmStatic
        @NotNull
        public final ResolutionResult resolve(@NotNull String uri) {
            Intrinsics.checkNotNullParameter(uri, "uri");
            try {
                web5.sdk.rust.ResolutionResult rustCoreResolutionResult = UniFFIKt.didJwkResolve(uri);
                return ResolutionResult.Companion.fromRustCoreResolutionResult$web5(rustCoreResolutionResult);
            }
            catch (Web5Exception.Exception e) {
                throw Web5Exception.Companion.fromRustCore$web5(e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

