/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.rust;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\b\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\b\u0010\b\u001a\u00020\u0006H\u0000\"\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"logLevel", "", "getLogLevel", "()Ljava/lang/String;", "detectSystemTarget", "log", "", "message", "setJNALibraryPath", "web5"})
public final class SystemTargetKt {
    @Nullable
    private static final String logLevel;

    @Nullable
    public static final String getLogLevel() {
        return logLevel;
    }

    public static final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (Intrinsics.areEqual(logLevel, "debug")) {
            System.out.println((Object)("web5 sdk SystemArchitecture " + message));
        }
    }

    public static final void setJNALibraryPath() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource("web5_uniffi_x86_64_pc_windows_msvc.dll");
        if (resource == null) {
            throw new IllegalStateException("Native library not found in resources!");
        }
        String decodedPath = URLDecoder.decode(resource.getPath(), "UTF-8");
        File file = new File(decodedPath).getParentFile();
        System.setProperty("jna.library.path", file.getAbsolutePath());
    }

    @NotNull
    public static final String detectSystemTarget() {
        String string;
        String arch;
        block18: {
            block17: {
                String string2;
                block16: {
                    block15: {
                        string2 = System.getProperty("os.arch");
                        if (string2 == null) break block15;
                        String string3 = string2.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                        string2 = string3;
                        if (string3 != null) break block16;
                    }
                    throw new Exception("Unable to get OS arch");
                }
                arch = string2;
                string = System.getProperty("os.name");
                if (string == null) break block17;
                String string4 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                string = string4;
                if (string4 != null) break block18;
            }
            throw new Exception("Unable to get OS name");
        }
        String name = string;
        SystemTargetKt.log("System architecture: " + arch);
        SystemTargetKt.log("Operating system name: " + name);
        if (StringsKt.contains$default((CharSequence)name, "mac", false, 2, null) && StringsKt.contains$default((CharSequence)arch, "aarch64", false, 2, null)) {
            return "web5_uniffi_aarch64_apple_darwin";
        }
        if (StringsKt.contains$default((CharSequence)name, "mac", false, 2, null) && StringsKt.contains$default((CharSequence)arch, "x86_64", false, 2, null)) {
            return "web5_uniffi_x86_64_apple_darwin";
        }
        if (StringsKt.contains$default((CharSequence)name, "linux", false, 2, null) && StringsKt.contains$default((CharSequence)arch, "amd64", false, 2, null)) {
            File osRelease = new File("/etc/os-release");
            if (osRelease.exists()) {
                String string5;
                String string6 = FilesKt.readText$default(osRelease, null, 1, null).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string6, "toLowerCase(...)");
                String osReleaseContent = string6;
                SystemTargetKt.log("OS release content: " + osReleaseContent);
                if (StringsKt.contains$default((CharSequence)osReleaseContent, "ubuntu", false, 2, null)) {
                    string5 = "web5_uniffi_x86_64_unknown_linux_gnu";
                } else if (StringsKt.contains$default((CharSequence)osReleaseContent, "alpine", false, 2, null)) {
                    string5 = "web5_uniffi_x86_64_unknown_linux_musl";
                } else {
                    throw new Exception("Unsupported OS arch " + osReleaseContent);
                }
                return string5;
            }
            throw new Exception("Linux /etc/os-release not found");
        }
        if (StringsKt.contains$default((CharSequence)name, "windows", false, 2, null)) {
            SystemTargetKt.setJNALibraryPath();
            return "web5_uniffi_x86_64_pc_windows_msvc";
        }
        throw new Exception("Unsupported OS arch " + arch + " " + name);
    }

    static {
        String string;
        String string2 = System.getenv("WEB5_SDK_LOG_LEVEL");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        } else {
            string = null;
        }
        logLevel = string;
    }
}

