/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.vc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import web5.sdk.vc.Issuer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lweb5/sdk/vc/IssuerDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lweb5/sdk/vc/Issuer;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "web5"})
public final class IssuerDeserializer
extends JsonDeserializer<Issuer> {
    @Override
    @NotNull
    public Issuer deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Issuer issuer;
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(ctxt, "ctxt");
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isTextual()) {
            String string = node.asText();
            Intrinsics.checkNotNullExpressionValue(string, "asText(...)");
            issuer = new Issuer.StringIssuer(string);
        } else {
            String id = node.get("id").asText();
            String name = node.get("name").asText();
            Map additionalProperties = new LinkedHashMap();
            node.fields().forEachRemaining(arg_0 -> IssuerDeserializer.deserialize$lambda$0(new Function1<Map.Entry<String, JsonNode>, Unit>((Map<String, Object>)additionalProperties){
                final /* synthetic */ Map<String, Object> $additionalProperties;
                {
                    this.$additionalProperties = $additionalProperties;
                    super(1);
                }

                public final void invoke(Map.Entry<String, JsonNode> entry) {
                    Intrinsics.checkNotNull(entry);
                    String key = entry.getKey();
                    JsonNode value = entry.getValue();
                    if (!Intrinsics.areEqual(key, "id") && !Intrinsics.areEqual(key, "name")) {
                        Intrinsics.checkNotNull(key);
                        Intrinsics.checkNotNull(value);
                        this.$additionalProperties.put(key, value);
                    }
                }
            }, arg_0));
            Intrinsics.checkNotNull(id);
            Intrinsics.checkNotNull(name);
            issuer = new Issuer.ObjectIssuer(id, name, additionalProperties);
        }
        return issuer;
    }

    private static final void deserialize$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }
}

