// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package web5.sdk.rust;

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_web5_uniffi_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_web5_uniffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus();
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback);
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "web5_uniffi_aarch64_apple_darwin"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(detectSystemTarget(), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}
internal interface UniffiCallbackInterfaceKeyExporterMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceKeyManagerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`publicJwk`: RustBuffer.ByValue,`uniffiOutReturn`: PointerByReference,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceKeyManagerMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`privateJwk`: RustBuffer.ByValue,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSignerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`payload`: RustBuffer.ByValue,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceVerifierMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`signature`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
@Structure.FieldOrder("exportPrivateJwks", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceKeyExporter(
    @JvmField internal var `exportPrivateJwks`: UniffiCallbackInterfaceKeyExporterMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `exportPrivateJwks`: UniffiCallbackInterfaceKeyExporterMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceKeyExporter(`exportPrivateJwks`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceKeyExporter) {
        `exportPrivateJwks` = other.`exportPrivateJwks`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("getSigner", "importPrivateJwk", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceKeyManager(
    @JvmField internal var `getSigner`: UniffiCallbackInterfaceKeyManagerMethod0? = null,
    @JvmField internal var `importPrivateJwk`: UniffiCallbackInterfaceKeyManagerMethod1? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `getSigner`: UniffiCallbackInterfaceKeyManagerMethod0? = null,
        `importPrivateJwk`: UniffiCallbackInterfaceKeyManagerMethod1? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceKeyManager(`getSigner`,`importPrivateJwk`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceKeyManager) {
        `getSigner` = other.`getSigner`
        `importPrivateJwk` = other.`importPrivateJwk`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("sign", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceSigner(
    @JvmField internal var `sign`: UniffiCallbackInterfaceSignerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `sign`: UniffiCallbackInterfaceSignerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceSigner(`sign`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceSigner) {
        `sign` = other.`sign`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("verify", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceVerifier(
    @JvmField internal var `verify`: UniffiCallbackInterfaceVerifierMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `verify`: UniffiCallbackInterfaceVerifierMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceVerifier(`verify`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceVerifier) {
        `verify` = other.`verify`
        `uniffiFree` = other.`uniffiFree`
    }

}
































































































































































































































// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            loadIndirect<UniffiLib>(componentName = "web5")
            .also { lib: UniffiLib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                uniffiCallbackInterfaceKeyExporter.register(lib)
                uniffiCallbackInterfaceKeyManager.register(lib)
                uniffiCallbackInterfaceSigner.register(lib)
                uniffiCallbackInterfaceVerifier.register(lib)
                }
        }
        
        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    fun uniffi_web5_uniffi_fn_clone_bearerdid(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_bearerdid(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_bearerdid_from_portable_did(`portableDid`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_constructor_bearerdid_new(`did`: RustBuffer.ByValue,`document`: RustBuffer.ByValue,`keyManager`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_bearerdid_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_bearerdid_get_signer(`ptr`: Pointer,`verificationMethodId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_bearerdid_to_portable_did(`ptr`: Pointer,`keyExporter`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_clone_did(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_did(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_did_new(`uri`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_did_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_document(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_document(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_document_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_constructor_document_new(`data`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_document_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_document_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_ed25519signer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_ed25519signer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_ed25519signer_new(`privateKey`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_ed25519signer_sign(`ptr`: Pointer,`payload`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_ed25519verifier(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_ed25519verifier(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_ed25519verifier_new(`publicJwk`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_ed25519verifier_verify(`ptr`: Pointer,`message`: RustBuffer.ByValue,`signature`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_clone_inmemorykeymanager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_inmemorykeymanager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_inmemorykeymanager_new(uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_inmemorykeymanager_export_private_jwks(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_inmemorykeymanager_get_as_key_manager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_inmemorykeymanager_get_signer(`ptr`: Pointer,`publicJwk`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_inmemorykeymanager_import_private_jwk(`ptr`: Pointer,`privateJwk`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_jwk(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_jwk(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_jwk_new(`data`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_jwk_compute_thumbprint(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_jwk_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_keyexporter(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_keyexporter(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_init_callback_vtable_keyexporter(`vtable`: UniffiVTableCallbackInterfaceKeyExporter,
    ): Unit
    fun uniffi_web5_uniffi_fn_method_keyexporter_export_private_jwks(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_keymanager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_keymanager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_init_callback_vtable_keymanager(`vtable`: UniffiVTableCallbackInterfaceKeyManager,
    ): Unit
    fun uniffi_web5_uniffi_fn_method_keymanager_get_signer(`ptr`: Pointer,`publicJwk`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_keymanager_import_private_jwk(`ptr`: Pointer,`privateJwk`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_portabledid(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_portabledid(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_portabledid_from_json_string(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_constructor_portabledid_new(`didUri`: RustBuffer.ByValue,`document`: RustBuffer.ByValue,`privateJwks`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_portabledid_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_portabledid_to_json_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_presentationdefinition(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_presentationdefinition(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_presentationdefinition_new(`jsonSerializedPresentationDefinition`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_presentationdefinition_create_presentation_from_credentials(`ptr`: Pointer,`vcJwts`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_presentationdefinition_get_json_serialized_presentation_definition(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_presentationdefinition_select_credentials(`ptr`: Pointer,`vcJwts`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_resolutionresult(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_resolutionresult(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_resolutionresult_resolve(`uri`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_resolutionresult_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_secp256k1signer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_secp256k1signer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_secp256k1signer_new(`privateKey`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_secp256k1signer_sign(`ptr`: Pointer,`payload`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_secp256k1verifier(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_secp256k1verifier(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_secp256k1verifier_new(`publicJwk`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_secp256k1verifier_verify(`ptr`: Pointer,`message`: RustBuffer.ByValue,`signature`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_clone_signer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_signer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_init_callback_vtable_signer(`vtable`: UniffiVTableCallbackInterfaceSigner,
    ): Unit
    fun uniffi_web5_uniffi_fn_method_signer_sign(`ptr`: Pointer,`payload`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_statuslistcredential(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_statuslistcredential(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_statuslistcredential_create(`jsonSerializedIssuer`: RustBuffer.ByValue,`statusPurpose`: RustBuffer.ByValue,`disabledCredentials`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_statuslistcredential_get_base(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_statuslistcredential_is_disabled(`ptr`: Pointer,`credential`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_web5_uniffi_fn_clone_verifiablecredential(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_verifiablecredential(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_verifiablecredential_create(`jsonSerializedIssuer`: RustBuffer.ByValue,`jsonSerializedCredentialSubject`: RustBuffer.ByValue,`options`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_constructor_verifiablecredential_from_vc_jwt(`vcJwt`: RustBuffer.ByValue,`verify`: Byte,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_verifiablecredential_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_verifiablecredential_sign(`ptr`: Pointer,`bearerDid`: Pointer,`verificationMethodId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_verifiablepresentation(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_verifiablepresentation(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_constructor_verifiablepresentation_create(`holder`: RustBuffer.ByValue,`vcJwts`: RustBuffer.ByValue,`options`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_constructor_verifiablepresentation_from_vp_jwt(`vpJwt`: RustBuffer.ByValue,`verify`: Byte,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_method_verifiablepresentation_get_data(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_method_verifiablepresentation_sign(`ptr`: Pointer,`bearerDid`: Pointer,`verificationMethodId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_clone_verifier(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_free_verifier(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_init_callback_vtable_verifier(`vtable`: UniffiVTableCallbackInterfaceVerifier,
    ): Unit
    fun uniffi_web5_uniffi_fn_method_verifier_verify(`ptr`: Pointer,`message`: RustBuffer.ByValue,`signature`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_func_did_dht_create(`options`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_func_did_dht_publish(`bearerDid`: Pointer,`gatewayUrl`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_fn_func_did_dht_resolve(`uri`: RustBuffer.ByValue,`gatewayUrl`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_func_did_jwk_create(`options`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_func_did_jwk_resolve(`uri`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_func_did_web_create(`domain`: RustBuffer.ByValue,`options`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_func_did_web_resolve(`uri`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_web5_uniffi_fn_func_ed25519_generator_generate(uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_web5_uniffi_fn_func_secp256k1_generator_generate(uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_web5_uniffi_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_web5_uniffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_web5_uniffi_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun ffi_web5_uniffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_web5_uniffi_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_u8(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_u8(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun ffi_web5_uniffi_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_i8(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_i8(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun ffi_web5_uniffi_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_u16(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_u16(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Short
    fun ffi_web5_uniffi_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_i16(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_i16(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Short
    fun ffi_web5_uniffi_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_u32(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_u32(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun ffi_web5_uniffi_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_i32(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_i32(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun ffi_web5_uniffi_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_u64(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_u64(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun ffi_web5_uniffi_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_i64(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_i64(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun ffi_web5_uniffi_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_f32(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_f32(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Float
    fun ffi_web5_uniffi_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_f64(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_f64(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Double
    fun ffi_web5_uniffi_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_pointer(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_pointer(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun ffi_web5_uniffi_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_web5_uniffi_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_cancel_void(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_free_void(`handle`: Long,
    ): Unit
    fun ffi_web5_uniffi_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_web5_uniffi_checksum_func_did_dht_create(
    ): Short
    fun uniffi_web5_uniffi_checksum_func_did_dht_publish(
    ): Short
    fun uniffi_web5_uniffi_checksum_func_did_dht_resolve(
    ): Short
    fun uniffi_web5_uniffi_checksum_func_did_jwk_create(
    ): Short
    fun uniffi_web5_uniffi_checksum_func_did_jwk_resolve(
    ): Short
    fun uniffi_web5_uniffi_checksum_func_did_web_create(
    ): Short
    fun uniffi_web5_uniffi_checksum_func_did_web_resolve(
    ): Short
    fun uniffi_web5_uniffi_checksum_func_ed25519_generator_generate(
    ): Short
    fun uniffi_web5_uniffi_checksum_func_secp256k1_generator_generate(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_bearerdid_get_data(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_bearerdid_get_signer(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_bearerdid_to_portable_did(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_did_get_data(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_document_get_data(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_document_to_json_string(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_ed25519signer_sign(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_ed25519verifier_verify(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_inmemorykeymanager_export_private_jwks(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_inmemorykeymanager_get_as_key_manager(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_inmemorykeymanager_get_signer(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_inmemorykeymanager_import_private_jwk(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_jwk_compute_thumbprint(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_jwk_get_data(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_keyexporter_export_private_jwks(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_keymanager_get_signer(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_keymanager_import_private_jwk(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_portabledid_get_data(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_portabledid_to_json_string(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_presentationdefinition_create_presentation_from_credentials(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_presentationdefinition_get_json_serialized_presentation_definition(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_presentationdefinition_select_credentials(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_resolutionresult_get_data(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_secp256k1signer_sign(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_secp256k1verifier_verify(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_signer_sign(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_statuslistcredential_get_base(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_statuslistcredential_is_disabled(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_verifiablecredential_get_data(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_verifiablecredential_sign(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_verifiablepresentation_get_data(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_verifiablepresentation_sign(
    ): Short
    fun uniffi_web5_uniffi_checksum_method_verifier_verify(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_bearerdid_from_portable_did(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_bearerdid_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_did_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_document_from_json_string(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_document_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_ed25519signer_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_ed25519verifier_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_inmemorykeymanager_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_jwk_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_portabledid_from_json_string(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_portabledid_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_presentationdefinition_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_resolutionresult_resolve(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_secp256k1signer_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_secp256k1verifier_new(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_statuslistcredential_create(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_verifiablecredential_create(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_verifiablecredential_from_vc_jwt(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_verifiablepresentation_create(
    ): Short
    fun uniffi_web5_uniffi_checksum_constructor_verifiablepresentation_from_vp_jwt(
    ): Short
    fun ffi_web5_uniffi_uniffi_contract_version(
    ): Int
    
}

private fun uniffiCheckContractApiVersion(lib: UniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 26
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_web5_uniffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: UniffiLib) {
    if (lib.uniffi_web5_uniffi_checksum_func_did_dht_create() != 3925.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_func_did_dht_publish() != 17158.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_func_did_dht_resolve() != 56140.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_func_did_jwk_create() != 64914.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_func_did_jwk_resolve() != 47278.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_func_did_web_create() != 8722.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_func_did_web_resolve() != 15538.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_func_ed25519_generator_generate() != 57849.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_func_secp256k1_generator_generate() != 50489.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_bearerdid_get_data() != 23985.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_bearerdid_get_signer() != 38083.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_bearerdid_to_portable_did() != 34661.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_did_get_data() != 55630.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_document_get_data() != 16490.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_document_to_json_string() != 29709.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_ed25519signer_sign() != 7079.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_ed25519verifier_verify() != 54498.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_inmemorykeymanager_export_private_jwks() != 31062.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_inmemorykeymanager_get_as_key_manager() != 57819.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_inmemorykeymanager_get_signer() != 64632.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_inmemorykeymanager_import_private_jwk() != 1224.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_jwk_compute_thumbprint() != 15254.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_jwk_get_data() != 12450.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_keyexporter_export_private_jwks() != 35665.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_keymanager_get_signer() != 27148.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_keymanager_import_private_jwk() != 6800.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_portabledid_get_data() != 27045.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_portabledid_to_json_string() != 53673.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_presentationdefinition_create_presentation_from_credentials() != 27580.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_presentationdefinition_get_json_serialized_presentation_definition() != 52261.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_presentationdefinition_select_credentials() != 27039.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_resolutionresult_get_data() != 57220.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_secp256k1signer_sign() != 17108.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_secp256k1verifier_verify() != 38282.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_signer_sign() != 5738.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_statuslistcredential_get_base() != 15197.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_statuslistcredential_is_disabled() != 23900.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_verifiablecredential_get_data() != 24514.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_verifiablecredential_sign() != 21705.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_verifiablepresentation_get_data() != 41102.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_verifiablepresentation_sign() != 52190.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_method_verifier_verify() != 51688.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_bearerdid_from_portable_did() != 49122.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_bearerdid_new() != 20412.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_did_new() != 60730.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_document_from_json_string() != 35057.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_document_new() != 10173.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_ed25519signer_new() != 48464.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_ed25519verifier_new() != 21891.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_inmemorykeymanager_new() != 16598.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_jwk_new() != 59888.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_portabledid_from_json_string() != 64165.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_portabledid_new() != 4603.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_presentationdefinition_new() != 13282.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_resolutionresult_resolve() != 11404.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_secp256k1signer_new() != 58975.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_secp256k1verifier_new() != 20759.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_statuslistcredential_create() != 49374.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_verifiablecredential_create() != 31236.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_verifiablecredential_from_vc_jwt() != 8044.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_verifiablepresentation_create() != 14449.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_web5_uniffi_checksum_constructor_verifiablepresentation_from_vp_jwt() != 35213.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Async support

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/** Used to instantiate an interface without an actual pointer, for fakes in tests, mostly. */
object NoPointer

public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): ULong {
        return 4UL + value.size.toULong()
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


public object FfiConverterTimestamp: FfiConverterRustBuffer<java.time.Instant> {
    override fun read(buf: ByteBuffer): java.time.Instant {
        val seconds = buf.getLong()
        // Type mismatch (should be u32) but we check for overflow/underflow below
        val nanoseconds = buf.getInt().toLong()
        if (nanoseconds < 0) {
            throw java.time.DateTimeException("Instant nanoseconds exceed minimum or maximum supported by uniffi")
        }
        if (seconds >= 0) {
            return java.time.Instant.EPOCH.plus(java.time.Duration.ofSeconds(seconds, nanoseconds))
        } else {
            return java.time.Instant.EPOCH.minus(java.time.Duration.ofSeconds(-seconds, nanoseconds))
        }
    }

    // 8 bytes for seconds, 4 bytes for nanoseconds
    override fun allocationSize(value: java.time.Instant) = 12UL

    override fun write(value: java.time.Instant, buf: ByteBuffer) {
        var epochOffset = java.time.Duration.between(java.time.Instant.EPOCH, value)

        var sign = 1
        if (epochOffset.isNegative()) {
            sign = -1
            epochOffset = epochOffset.negated()
        }

        if (epochOffset.nano < 0) {
            // Java docs provide guarantee that nano will always be positive, so this should be impossible
            // See: https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html
            throw IllegalArgumentException("Invalid timestamp, nano value must be non-negative")
        }

        buf.putLong(sign * epochOffset.seconds)
        // Type mismatch (should be u32) but since values will always be between 0 and 999,999,999 it should be OK
        buf.putInt(epochOffset.nano)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


// The cleaner interface for Object finalization code to run.
// This is the entry point to any implementation that we're using.
//
// The cleaner registers objects and returns cleanables, so now we are
// defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
// different implmentations available at compile time.
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.
private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    try {
        // For safety's sake: if the library hasn't been run in android_cleaner = true
        // mode, but is being run on Android, then we still need to think about
        // Android API versions.
        // So we check if java.lang.ref.Cleaner is there, and use that…
        java.lang.Class.forName("java.lang.ref.Cleaner")
        JavaLangRefCleaner()
    } catch (e: ClassNotFoundException) {
        // … otherwise, fallback to the JNA cleaner.
        UniffiJnaCleaner()
    }

private class JavaLangRefCleaner : UniffiCleaner {
    val cleaner = java.lang.ref.Cleaner.create()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        JavaLangRefCleanable(cleaner.register(value, cleanUpTask))
}

private class JavaLangRefCleanable(
    val cleanable: java.lang.ref.Cleaner.Cleanable
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}
public interface BearerDidInterface {
    
    fun `getData`(): BearerDidData
    
    fun `getSigner`(`verificationMethodId`: kotlin.String): Signer
    
    fun `toPortableDid`(`keyExporter`: KeyExporter): PortableDid
    
    companion object
}

open class BearerDid: Disposable, AutoCloseable, BearerDidInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`did`: DidData, `document`: DocumentData, `keyManager`: KeyManager) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_bearerdid_new(
        FfiConverterTypeDidData.lower(`did`),FfiConverterTypeDocumentData.lower(`document`),FfiConverterTypeKeyManager.lower(`keyManager`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_bearerdid(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_bearerdid(pointer!!, status)
        }
    }

    override fun `getData`(): BearerDidData {
            return FfiConverterTypeBearerDidData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_bearerdid_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `getSigner`(`verificationMethodId`: kotlin.String): Signer {
            return FfiConverterTypeSigner.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_bearerdid_get_signer(
        it, FfiConverterString.lower(`verificationMethodId`),_status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `toPortableDid`(`keyExporter`: KeyExporter): PortableDid {
            return FfiConverterTypePortableDid.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_bearerdid_to_portable_did(
        it, FfiConverterTypeKeyExporter.lower(`keyExporter`),_status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(Web5Exception::class) fun `fromPortableDid`(`portableDid`: PortableDid): BearerDid {
            return FfiConverterTypeBearerDid.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_bearerdid_from_portable_did(
        FfiConverterTypePortableDid.lower(`portableDid`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeBearerDid: FfiConverter<BearerDid, Pointer> {

    override fun lower(value: BearerDid): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): BearerDid {
        return BearerDid(value)
    }

    override fun read(buf: ByteBuffer): BearerDid {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: BearerDid) = 8UL

    override fun write(value: BearerDid, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface DidInterface {
    
    fun `getData`(): DidData
    
    companion object
}

open class Did: Disposable, AutoCloseable, DidInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`uri`: kotlin.String) :
        this(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_did_new(
        FfiConverterString.lower(`uri`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_did(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_did(pointer!!, status)
        }
    }

    override fun `getData`(): DidData {
            return FfiConverterTypeDidData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_did_get_data(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeDid: FfiConverter<Did, Pointer> {

    override fun lower(value: Did): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Did {
        return Did(value)
    }

    override fun read(buf: ByteBuffer): Did {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Did) = 8UL

    override fun write(value: Did, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface DocumentInterface {
    
    fun `getData`(): DocumentData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class Document: Disposable, AutoCloseable, DocumentInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`data`: DocumentData) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_document_new(
        FfiConverterTypeDocumentData.lower(`data`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_document(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_document(pointer!!, status)
        }
    }

    override fun `getData`(): DocumentData {
            return FfiConverterTypeDocumentData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_document_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_document_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(Web5Exception::class) fun `fromJsonString`(`json`: kotlin.String): Document {
            return FfiConverterTypeDocument.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_document_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeDocument: FfiConverter<Document, Pointer> {

    override fun lower(value: Document): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Document {
        return Document(value)
    }

    override fun read(buf: ByteBuffer): Document {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Document) = 8UL

    override fun write(value: Document, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface Ed25519SignerInterface {
    
    fun `sign`(`payload`: kotlin.ByteArray): kotlin.ByteArray
    
    companion object
}

open class Ed25519Signer: Disposable, AutoCloseable, Ed25519SignerInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`privateKey`: JwkData) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_ed25519signer_new(
        FfiConverterTypeJwkData.lower(`privateKey`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_ed25519signer(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_ed25519signer(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `sign`(`payload`: kotlin.ByteArray): kotlin.ByteArray {
            return FfiConverterByteArray.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_ed25519signer_sign(
        it, FfiConverterByteArray.lower(`payload`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeEd25519Signer: FfiConverter<Ed25519Signer, Pointer> {

    override fun lower(value: Ed25519Signer): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Ed25519Signer {
        return Ed25519Signer(value)
    }

    override fun read(buf: ByteBuffer): Ed25519Signer {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Ed25519Signer) = 8UL

    override fun write(value: Ed25519Signer, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface Ed25519VerifierInterface {
    
    fun `verify`(`message`: kotlin.ByteArray, `signature`: kotlin.ByteArray)
    
    companion object
}

open class Ed25519Verifier: Disposable, AutoCloseable, Ed25519VerifierInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`publicJwk`: JwkData) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_ed25519verifier_new(
        FfiConverterTypeJwkData.lower(`publicJwk`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_ed25519verifier(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_ed25519verifier(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `verify`(`message`: kotlin.ByteArray, `signature`: kotlin.ByteArray)
        = 
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_ed25519verifier_verify(
        it, FfiConverterByteArray.lower(`message`),FfiConverterByteArray.lower(`signature`),_status)
}
    }
    
    

    

    
    
    companion object
    
}

public object FfiConverterTypeEd25519Verifier: FfiConverter<Ed25519Verifier, Pointer> {

    override fun lower(value: Ed25519Verifier): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Ed25519Verifier {
        return Ed25519Verifier(value)
    }

    override fun read(buf: ByteBuffer): Ed25519Verifier {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Ed25519Verifier) = 8UL

    override fun write(value: Ed25519Verifier, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface InMemoryKeyManagerInterface {
    
    fun `exportPrivateJwks`(): List<JwkData>
    
    fun `getAsKeyManager`(): KeyManager
    
    fun `getSigner`(`publicJwk`: JwkData): Signer
    
    fun `importPrivateJwk`(`privateJwk`: JwkData): JwkData
    
    companion object
}

open class InMemoryKeyManager: Disposable, AutoCloseable, InMemoryKeyManagerInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_inmemorykeymanager_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_inmemorykeymanager(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_inmemorykeymanager(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `exportPrivateJwks`(): List<JwkData> {
            return FfiConverterSequenceTypeJwkData.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_inmemorykeymanager_export_private_jwks(
        it, _status)
}
    }
    )
    }
    

    override fun `getAsKeyManager`(): KeyManager {
            return FfiConverterTypeKeyManager.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_inmemorykeymanager_get_as_key_manager(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `getSigner`(`publicJwk`: JwkData): Signer {
            return FfiConverterTypeSigner.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_inmemorykeymanager_get_signer(
        it, FfiConverterTypeJwkData.lower(`publicJwk`),_status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `importPrivateJwk`(`privateJwk`: JwkData): JwkData {
            return FfiConverterTypeJwkData.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_inmemorykeymanager_import_private_jwk(
        it, FfiConverterTypeJwkData.lower(`privateJwk`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeInMemoryKeyManager: FfiConverter<InMemoryKeyManager, Pointer> {

    override fun lower(value: InMemoryKeyManager): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): InMemoryKeyManager {
        return InMemoryKeyManager(value)
    }

    override fun read(buf: ByteBuffer): InMemoryKeyManager {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: InMemoryKeyManager) = 8UL

    override fun write(value: InMemoryKeyManager, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface JwkInterface {
    
    fun `computeThumbprint`(): kotlin.String
    
    fun `getData`(): JwkData
    
    companion object
}

open class Jwk: Disposable, AutoCloseable, JwkInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`data`: JwkData) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_jwk_new(
        FfiConverterTypeJwkData.lower(`data`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_jwk(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_jwk(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `computeThumbprint`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_jwk_compute_thumbprint(
        it, _status)
}
    }
    )
    }
    

    override fun `getData`(): JwkData {
            return FfiConverterTypeJwkData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_jwk_get_data(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeJwk: FfiConverter<Jwk, Pointer> {

    override fun lower(value: Jwk): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Jwk {
        return Jwk(value)
    }

    override fun read(buf: ByteBuffer): Jwk {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Jwk) = 8UL

    override fun write(value: Jwk, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface KeyExporter {
    
    fun `exportPrivateJwks`(): List<JwkData>
    
    companion object
}

open class KeyExporterImpl: Disposable, AutoCloseable, KeyExporter {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_keyexporter(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_keyexporter(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `exportPrivateJwks`(): List<JwkData> {
            return FfiConverterSequenceTypeJwkData.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_keyexporter_export_private_jwks(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}
// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

public abstract class FfiConverterCallbackInterface<CallbackInterface: Any>: FfiConverter<CallbackInterface, Long> {
    internal val handleMap = UniffiHandleMap<CallbackInterface>()

    internal fun drop(handle: Long) {
        handleMap.remove(handle)
    }

    override fun lift(value: Long): CallbackInterface {
        return handleMap.get(value)
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) = handleMap.insert(value)

    override fun allocationSize(value: CallbackInterface) = 8UL

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}

// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceKeyExporter {
    internal object `exportPrivateJwks`: UniffiCallbackInterfaceKeyExporterMethod0 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeKeyExporter.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`exportPrivateJwks`(
                )
            }
            val writeReturn = { value: List<JwkData> -> uniffiOutReturn.setValue(FfiConverterSequenceTypeJwkData.lower(value)) }
            uniffiTraitInterfaceCallWithError(
                uniffiCallStatus,
                makeCall,
                writeReturn,
                { e: Web5Exception -> FfiConverterTypeWeb5Error.lower(e) }
            )
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeKeyExporter.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceKeyExporter.UniffiByValue(
        `exportPrivateJwks`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_web5_uniffi_fn_init_callback_vtable_keyexporter(vtable)
    }
}

public object FfiConverterTypeKeyExporter: FfiConverter<KeyExporter, Pointer> {
    internal val handleMap = UniffiHandleMap<KeyExporter>()

    override fun lower(value: KeyExporter): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): KeyExporter {
        return KeyExporterImpl(value)
    }

    override fun read(buf: ByteBuffer): KeyExporter {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: KeyExporter) = 8UL

    override fun write(value: KeyExporter, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface KeyManager {
    
    fun `getSigner`(`publicJwk`: JwkData): Signer
    
    fun `importPrivateJwk`(`privateJwk`: JwkData): JwkData
    
    companion object
}

open class KeyManagerImpl: Disposable, AutoCloseable, KeyManager {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_keymanager(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_keymanager(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `getSigner`(`publicJwk`: JwkData): Signer {
            return FfiConverterTypeSigner.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_keymanager_get_signer(
        it, FfiConverterTypeJwkData.lower(`publicJwk`),_status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `importPrivateJwk`(`privateJwk`: JwkData): JwkData {
            return FfiConverterTypeJwkData.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_keymanager_import_private_jwk(
        it, FfiConverterTypeJwkData.lower(`privateJwk`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}


// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceKeyManager {
    internal object `getSigner`: UniffiCallbackInterfaceKeyManagerMethod0 {
        override fun callback(`uniffiHandle`: Long,`publicJwk`: RustBuffer.ByValue,`uniffiOutReturn`: PointerByReference,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeKeyManager.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`getSigner`(
                    FfiConverterTypeJwkData.lift(`publicJwk`),
                )
            }
            val writeReturn = { value: Signer -> uniffiOutReturn.setValue(FfiConverterTypeSigner.lower(value)) }
            uniffiTraitInterfaceCallWithError(
                uniffiCallStatus,
                makeCall,
                writeReturn,
                { e: Web5Exception -> FfiConverterTypeWeb5Error.lower(e) }
            )
        }
    }
    internal object `importPrivateJwk`: UniffiCallbackInterfaceKeyManagerMethod1 {
        override fun callback(`uniffiHandle`: Long,`privateJwk`: RustBuffer.ByValue,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeKeyManager.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`importPrivateJwk`(
                    FfiConverterTypeJwkData.lift(`privateJwk`),
                )
            }
            val writeReturn = { value: JwkData -> uniffiOutReturn.setValue(FfiConverterTypeJwkData.lower(value)) }
            uniffiTraitInterfaceCallWithError(
                uniffiCallStatus,
                makeCall,
                writeReturn,
                { e: Web5Exception -> FfiConverterTypeWeb5Error.lower(e) }
            )
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeKeyManager.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceKeyManager.UniffiByValue(
        `getSigner`,
        `importPrivateJwk`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_web5_uniffi_fn_init_callback_vtable_keymanager(vtable)
    }
}

public object FfiConverterTypeKeyManager: FfiConverter<KeyManager, Pointer> {
    internal val handleMap = UniffiHandleMap<KeyManager>()

    override fun lower(value: KeyManager): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): KeyManager {
        return KeyManagerImpl(value)
    }

    override fun read(buf: ByteBuffer): KeyManager {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: KeyManager) = 8UL

    override fun write(value: KeyManager, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface PortableDidInterface {
    
    fun `getData`(): PortableDidData
    
    fun `toJsonString`(): kotlin.String
    
    companion object
}

open class PortableDid: Disposable, AutoCloseable, PortableDidInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`didUri`: kotlin.String, `document`: DocumentData, `privateJwks`: List<JwkData>) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_portabledid_new(
        FfiConverterString.lower(`didUri`),FfiConverterTypeDocumentData.lower(`document`),FfiConverterSequenceTypeJwkData.lower(`privateJwks`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_portabledid(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_portabledid(pointer!!, status)
        }
    }

    override fun `getData`(): PortableDidData {
            return FfiConverterTypePortableDidData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_portabledid_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `toJsonString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_portabledid_to_json_string(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(Web5Exception::class) fun `fromJsonString`(`json`: kotlin.String): PortableDid {
            return FfiConverterTypePortableDid.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_portabledid_from_json_string(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypePortableDid: FfiConverter<PortableDid, Pointer> {

    override fun lower(value: PortableDid): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): PortableDid {
        return PortableDid(value)
    }

    override fun read(buf: ByteBuffer): PortableDid {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: PortableDid) = 8UL

    override fun write(value: PortableDid, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface PresentationDefinitionInterface {
    
    fun `createPresentationFromCredentials`(`vcJwts`: List<kotlin.String>): kotlin.String
    
    fun `getJsonSerializedPresentationDefinition`(): kotlin.String
    
    fun `selectCredentials`(`vcJwts`: List<kotlin.String>): List<kotlin.String>
    
    companion object
}

open class PresentationDefinition: Disposable, AutoCloseable, PresentationDefinitionInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`jsonSerializedPresentationDefinition`: kotlin.String) :
        this(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_presentationdefinition_new(
        FfiConverterString.lower(`jsonSerializedPresentationDefinition`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_presentationdefinition(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_presentationdefinition(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `createPresentationFromCredentials`(`vcJwts`: List<kotlin.String>): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_presentationdefinition_create_presentation_from_credentials(
        it, FfiConverterSequenceString.lower(`vcJwts`),_status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `getJsonSerializedPresentationDefinition`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_presentationdefinition_get_json_serialized_presentation_definition(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `selectCredentials`(`vcJwts`: List<kotlin.String>): List<kotlin.String> {
            return FfiConverterSequenceString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_presentationdefinition_select_credentials(
        it, FfiConverterSequenceString.lower(`vcJwts`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypePresentationDefinition: FfiConverter<PresentationDefinition, Pointer> {

    override fun lower(value: PresentationDefinition): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): PresentationDefinition {
        return PresentationDefinition(value)
    }

    override fun read(buf: ByteBuffer): PresentationDefinition {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: PresentationDefinition) = 8UL

    override fun write(value: PresentationDefinition, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ResolutionResultInterface {
    
    fun `getData`(): ResolutionResultData
    
    companion object
}

open class ResolutionResult: Disposable, AutoCloseable, ResolutionResultInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_resolutionresult(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_resolutionresult(pointer!!, status)
        }
    }

    override fun `getData`(): ResolutionResultData {
            return FfiConverterTypeResolutionResultData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_resolutionresult_get_data(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
         fun `resolve`(`uri`: kotlin.String): ResolutionResult {
            return FfiConverterTypeResolutionResult.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_resolutionresult_resolve(
        FfiConverterString.lower(`uri`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeResolutionResult: FfiConverter<ResolutionResult, Pointer> {

    override fun lower(value: ResolutionResult): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ResolutionResult {
        return ResolutionResult(value)
    }

    override fun read(buf: ByteBuffer): ResolutionResult {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ResolutionResult) = 8UL

    override fun write(value: ResolutionResult, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface Secp256k1SignerInterface {
    
    fun `sign`(`payload`: kotlin.ByteArray): kotlin.ByteArray
    
    companion object
}

open class Secp256k1Signer: Disposable, AutoCloseable, Secp256k1SignerInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`privateKey`: JwkData) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_secp256k1signer_new(
        FfiConverterTypeJwkData.lower(`privateKey`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_secp256k1signer(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_secp256k1signer(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `sign`(`payload`: kotlin.ByteArray): kotlin.ByteArray {
            return FfiConverterByteArray.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_secp256k1signer_sign(
        it, FfiConverterByteArray.lower(`payload`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeSecp256k1Signer: FfiConverter<Secp256k1Signer, Pointer> {

    override fun lower(value: Secp256k1Signer): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Secp256k1Signer {
        return Secp256k1Signer(value)
    }

    override fun read(buf: ByteBuffer): Secp256k1Signer {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Secp256k1Signer) = 8UL

    override fun write(value: Secp256k1Signer, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface Secp256k1VerifierInterface {
    
    fun `verify`(`message`: kotlin.ByteArray, `signature`: kotlin.ByteArray)
    
    companion object
}

open class Secp256k1Verifier: Disposable, AutoCloseable, Secp256k1VerifierInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`publicJwk`: JwkData) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_secp256k1verifier_new(
        FfiConverterTypeJwkData.lower(`publicJwk`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_secp256k1verifier(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_secp256k1verifier(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `verify`(`message`: kotlin.ByteArray, `signature`: kotlin.ByteArray)
        = 
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_secp256k1verifier_verify(
        it, FfiConverterByteArray.lower(`message`),FfiConverterByteArray.lower(`signature`),_status)
}
    }
    
    

    

    
    
    companion object
    
}

public object FfiConverterTypeSecp256k1Verifier: FfiConverter<Secp256k1Verifier, Pointer> {

    override fun lower(value: Secp256k1Verifier): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Secp256k1Verifier {
        return Secp256k1Verifier(value)
    }

    override fun read(buf: ByteBuffer): Secp256k1Verifier {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Secp256k1Verifier) = 8UL

    override fun write(value: Secp256k1Verifier, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface Signer {
    
    fun `sign`(`payload`: kotlin.ByteArray): kotlin.ByteArray
    
    companion object
}

open class SignerImpl: Disposable, AutoCloseable, Signer {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_signer(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_signer(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `sign`(`payload`: kotlin.ByteArray): kotlin.ByteArray {
            return FfiConverterByteArray.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_signer_sign(
        it, FfiConverterByteArray.lower(`payload`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}


// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceSigner {
    internal object `sign`: UniffiCallbackInterfaceSignerMethod0 {
        override fun callback(`uniffiHandle`: Long,`payload`: RustBuffer.ByValue,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeSigner.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`sign`(
                    FfiConverterByteArray.lift(`payload`),
                )
            }
            val writeReturn = { value: kotlin.ByteArray -> uniffiOutReturn.setValue(FfiConverterByteArray.lower(value)) }
            uniffiTraitInterfaceCallWithError(
                uniffiCallStatus,
                makeCall,
                writeReturn,
                { e: Web5Exception -> FfiConverterTypeWeb5Error.lower(e) }
            )
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeSigner.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceSigner.UniffiByValue(
        `sign`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_web5_uniffi_fn_init_callback_vtable_signer(vtable)
    }
}

public object FfiConverterTypeSigner: FfiConverter<Signer, Pointer> {
    internal val handleMap = UniffiHandleMap<Signer>()

    override fun lower(value: Signer): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): Signer {
        return SignerImpl(value)
    }

    override fun read(buf: ByteBuffer): Signer {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Signer) = 8UL

    override fun write(value: Signer, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface StatusListCredentialInterface {
    
    fun `getBase`(): VerifiableCredential
    
    fun `isDisabled`(`credential`: VerifiableCredential): kotlin.Boolean
    
    companion object
}

open class StatusListCredential: Disposable, AutoCloseable, StatusListCredentialInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_statuslistcredential(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_statuslistcredential(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `getBase`(): VerifiableCredential {
            return FfiConverterTypeVerifiableCredential.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_statuslistcredential_get_base(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `isDisabled`(`credential`: VerifiableCredential): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_statuslistcredential_is_disabled(
        it, FfiConverterTypeVerifiableCredential.lower(`credential`),_status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(Web5Exception::class) fun `create`(`jsonSerializedIssuer`: kotlin.String, `statusPurpose`: kotlin.String, `disabledCredentials`: List<VerifiableCredential>?): StatusListCredential {
            return FfiConverterTypeStatusListCredential.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_statuslistcredential_create(
        FfiConverterString.lower(`jsonSerializedIssuer`),FfiConverterString.lower(`statusPurpose`),FfiConverterOptionalSequenceTypeVerifiableCredential.lower(`disabledCredentials`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeStatusListCredential: FfiConverter<StatusListCredential, Pointer> {

    override fun lower(value: StatusListCredential): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): StatusListCredential {
        return StatusListCredential(value)
    }

    override fun read(buf: ByteBuffer): StatusListCredential {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: StatusListCredential) = 8UL

    override fun write(value: StatusListCredential, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface VerifiableCredentialInterface {
    
    fun `getData`(): VerifiableCredentialData
    
    fun `sign`(`bearerDid`: BearerDid, `verificationMethodId`: kotlin.String?): kotlin.String
    
    companion object
}

open class VerifiableCredential: Disposable, AutoCloseable, VerifiableCredentialInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_verifiablecredential(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_verifiablecredential(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `getData`(): VerifiableCredentialData {
            return FfiConverterTypeVerifiableCredentialData.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_verifiablecredential_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `sign`(`bearerDid`: BearerDid, `verificationMethodId`: kotlin.String?): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_verifiablecredential_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),FfiConverterOptionalString.lower(`verificationMethodId`),_status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(Web5Exception::class) fun `create`(`jsonSerializedIssuer`: kotlin.String, `jsonSerializedCredentialSubject`: kotlin.String, `options`: VerifiableCredentialCreateOptionsData?): VerifiableCredential {
            return FfiConverterTypeVerifiableCredential.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_verifiablecredential_create(
        FfiConverterString.lower(`jsonSerializedIssuer`),FfiConverterString.lower(`jsonSerializedCredentialSubject`),FfiConverterOptionalTypeVerifiableCredentialCreateOptionsData.lower(`options`),_status)
}
    )
    }
    

        
    @Throws(Web5Exception::class) fun `fromVcJwt`(`vcJwt`: kotlin.String, `verify`: kotlin.Boolean): VerifiableCredential {
            return FfiConverterTypeVerifiableCredential.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_verifiablecredential_from_vc_jwt(
        FfiConverterString.lower(`vcJwt`),FfiConverterBoolean.lower(`verify`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeVerifiableCredential: FfiConverter<VerifiableCredential, Pointer> {

    override fun lower(value: VerifiableCredential): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): VerifiableCredential {
        return VerifiableCredential(value)
    }

    override fun read(buf: ByteBuffer): VerifiableCredential {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: VerifiableCredential) = 8UL

    override fun write(value: VerifiableCredential, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface VerifiablePresentationInterface {
    
    fun `getData`(): VerifiablePresentationData
    
    fun `sign`(`bearerDid`: BearerDid, `verificationMethodId`: kotlin.String?): kotlin.String
    
    companion object
}

open class VerifiablePresentation: Disposable, AutoCloseable, VerifiablePresentationInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_verifiablepresentation(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_verifiablepresentation(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `getData`(): VerifiablePresentationData {
            return FfiConverterTypeVerifiablePresentationData.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_verifiablepresentation_get_data(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(Web5Exception::class)override fun `sign`(`bearerDid`: BearerDid, `verificationMethodId`: kotlin.String?): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_verifiablepresentation_sign(
        it, FfiConverterTypeBearerDid.lower(`bearerDid`),FfiConverterOptionalString.lower(`verificationMethodId`),_status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(Web5Exception::class) fun `create`(`holder`: kotlin.String, `vcJwts`: List<kotlin.String>, `options`: VerifiablePresentationCreateOptionsData?): VerifiablePresentation {
            return FfiConverterTypeVerifiablePresentation.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_verifiablepresentation_create(
        FfiConverterString.lower(`holder`),FfiConverterSequenceString.lower(`vcJwts`),FfiConverterOptionalTypeVerifiablePresentationCreateOptionsData.lower(`options`),_status)
}
    )
    }
    

        
    @Throws(Web5Exception::class) fun `fromVpJwt`(`vpJwt`: kotlin.String, `verify`: kotlin.Boolean): VerifiablePresentation {
            return FfiConverterTypeVerifiablePresentation.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_constructor_verifiablepresentation_from_vp_jwt(
        FfiConverterString.lower(`vpJwt`),FfiConverterBoolean.lower(`verify`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeVerifiablePresentation: FfiConverter<VerifiablePresentation, Pointer> {

    override fun lower(value: VerifiablePresentation): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): VerifiablePresentation {
        return VerifiablePresentation(value)
    }

    override fun read(buf: ByteBuffer): VerifiablePresentation {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: VerifiablePresentation) = 8UL

    override fun write(value: VerifiablePresentation, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface Verifier {
    
    fun `verify`(`message`: kotlin.ByteArray, `signature`: kotlin.ByteArray)
    
    companion object
}

open class VerifierImpl: Disposable, AutoCloseable, Verifier {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_free_verifier(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_clone_verifier(pointer!!, status)
        }
    }

    
    @Throws(Web5Exception::class)override fun `verify`(`message`: kotlin.ByteArray, `signature`: kotlin.ByteArray)
        = 
    callWithPointer {
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_method_verifier_verify(
        it, FfiConverterByteArray.lower(`message`),FfiConverterByteArray.lower(`signature`),_status)
}
    }
    
    

    

    
    
    companion object
    
}


// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceVerifier {
    internal object `verify`: UniffiCallbackInterfaceVerifierMethod0 {
        override fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`signature`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeVerifier.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`verify`(
                    FfiConverterByteArray.lift(`message`),
                    FfiConverterByteArray.lift(`signature`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCallWithError(
                uniffiCallStatus,
                makeCall,
                writeReturn,
                { e: Web5Exception -> FfiConverterTypeWeb5Error.lower(e) }
            )
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeVerifier.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceVerifier.UniffiByValue(
        `verify`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_web5_uniffi_fn_init_callback_vtable_verifier(vtable)
    }
}

public object FfiConverterTypeVerifier: FfiConverter<Verifier, Pointer> {
    internal val handleMap = UniffiHandleMap<Verifier>()

    override fun lower(value: Verifier): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): Verifier {
        return VerifierImpl(value)
    }

    override fun read(buf: ByteBuffer): Verifier {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Verifier) = 8UL

    override fun write(value: Verifier, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class BearerDidData (
    var `did`: DidData, 
    var `document`: DocumentData, 
    var `keyManager`: KeyManager
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`did`, 
        this.`document`, 
        this.`keyManager`)
    }
    
    companion object
}

public object FfiConverterTypeBearerDidData: FfiConverterRustBuffer<BearerDidData> {
    override fun read(buf: ByteBuffer): BearerDidData {
        return BearerDidData(
            FfiConverterTypeDidData.read(buf),
            FfiConverterTypeDocumentData.read(buf),
            FfiConverterTypeKeyManager.read(buf),
        )
    }

    override fun allocationSize(value: BearerDidData) = (
            FfiConverterTypeDidData.allocationSize(value.`did`) +
            FfiConverterTypeDocumentData.allocationSize(value.`document`) +
            FfiConverterTypeKeyManager.allocationSize(value.`keyManager`)
    )

    override fun write(value: BearerDidData, buf: ByteBuffer) {
            FfiConverterTypeDidData.write(value.`did`, buf)
            FfiConverterTypeDocumentData.write(value.`document`, buf)
            FfiConverterTypeKeyManager.write(value.`keyManager`, buf)
    }
}



data class CredentialSchemaData (
    var `id`: kotlin.String, 
    var `type`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeCredentialSchemaData: FfiConverterRustBuffer<CredentialSchemaData> {
    override fun read(buf: ByteBuffer): CredentialSchemaData {
        return CredentialSchemaData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: CredentialSchemaData) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`type`)
    )

    override fun write(value: CredentialSchemaData, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`type`, buf)
    }
}



data class CredentialStatusData (
    var `id`: kotlin.String, 
    var `type`: kotlin.String, 
    var `statusPurpose`: kotlin.String, 
    var `statusListIndex`: kotlin.String, 
    var `statusListCredential`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeCredentialStatusData: FfiConverterRustBuffer<CredentialStatusData> {
    override fun read(buf: ByteBuffer): CredentialStatusData {
        return CredentialStatusData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: CredentialStatusData) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`type`) +
            FfiConverterString.allocationSize(value.`statusPurpose`) +
            FfiConverterString.allocationSize(value.`statusListIndex`) +
            FfiConverterString.allocationSize(value.`statusListCredential`)
    )

    override fun write(value: CredentialStatusData, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`type`, buf)
            FfiConverterString.write(value.`statusPurpose`, buf)
            FfiConverterString.write(value.`statusListIndex`, buf)
            FfiConverterString.write(value.`statusListCredential`, buf)
    }
}



data class DidData (
    var `uri`: kotlin.String, 
    var `url`: kotlin.String, 
    var `method`: kotlin.String, 
    var `id`: kotlin.String, 
    var `params`: Map<kotlin.String, kotlin.String>?, 
    var `path`: kotlin.String?, 
    var `query`: kotlin.String?, 
    var `fragment`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeDidData: FfiConverterRustBuffer<DidData> {
    override fun read(buf: ByteBuffer): DidData {
        return DidData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalMapStringString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: DidData) = (
            FfiConverterString.allocationSize(value.`uri`) +
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterString.allocationSize(value.`method`) +
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalMapStringString.allocationSize(value.`params`) +
            FfiConverterOptionalString.allocationSize(value.`path`) +
            FfiConverterOptionalString.allocationSize(value.`query`) +
            FfiConverterOptionalString.allocationSize(value.`fragment`)
    )

    override fun write(value: DidData, buf: ByteBuffer) {
            FfiConverterString.write(value.`uri`, buf)
            FfiConverterString.write(value.`url`, buf)
            FfiConverterString.write(value.`method`, buf)
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalMapStringString.write(value.`params`, buf)
            FfiConverterOptionalString.write(value.`path`, buf)
            FfiConverterOptionalString.write(value.`query`, buf)
            FfiConverterOptionalString.write(value.`fragment`, buf)
    }
}



data class DidDhtCreateOptions (
    var `publish`: kotlin.Boolean?, 
    var `gatewayUrl`: kotlin.String?, 
    var `keyManager`: KeyManager?, 
    var `service`: List<ServiceData>?, 
    var `controller`: List<kotlin.String>?, 
    var `alsoKnownAs`: List<kotlin.String>?, 
    var `verificationMethod`: List<VerificationMethodData>?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`publish`, 
        this.`gatewayUrl`, 
        this.`keyManager`, 
        this.`service`, 
        this.`controller`, 
        this.`alsoKnownAs`, 
        this.`verificationMethod`)
    }
    
    companion object
}

public object FfiConverterTypeDidDhtCreateOptions: FfiConverterRustBuffer<DidDhtCreateOptions> {
    override fun read(buf: ByteBuffer): DidDhtCreateOptions {
        return DidDhtCreateOptions(
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypeKeyManager.read(buf),
            FfiConverterOptionalSequenceTypeServiceData.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceTypeVerificationMethodData.read(buf),
        )
    }

    override fun allocationSize(value: DidDhtCreateOptions) = (
            FfiConverterOptionalBoolean.allocationSize(value.`publish`) +
            FfiConverterOptionalString.allocationSize(value.`gatewayUrl`) +
            FfiConverterOptionalTypeKeyManager.allocationSize(value.`keyManager`) +
            FfiConverterOptionalSequenceTypeServiceData.allocationSize(value.`service`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`controller`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`alsoKnownAs`) +
            FfiConverterOptionalSequenceTypeVerificationMethodData.allocationSize(value.`verificationMethod`)
    )

    override fun write(value: DidDhtCreateOptions, buf: ByteBuffer) {
            FfiConverterOptionalBoolean.write(value.`publish`, buf)
            FfiConverterOptionalString.write(value.`gatewayUrl`, buf)
            FfiConverterOptionalTypeKeyManager.write(value.`keyManager`, buf)
            FfiConverterOptionalSequenceTypeServiceData.write(value.`service`, buf)
            FfiConverterOptionalSequenceString.write(value.`controller`, buf)
            FfiConverterOptionalSequenceString.write(value.`alsoKnownAs`, buf)
            FfiConverterOptionalSequenceTypeVerificationMethodData.write(value.`verificationMethod`, buf)
    }
}



data class DidJwkCreateOptions (
    var `keyManager`: KeyManager?, 
    var `dsa`: Dsa?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`keyManager`, 
        this.`dsa`)
    }
    
    companion object
}

public object FfiConverterTypeDidJwkCreateOptions: FfiConverterRustBuffer<DidJwkCreateOptions> {
    override fun read(buf: ByteBuffer): DidJwkCreateOptions {
        return DidJwkCreateOptions(
            FfiConverterOptionalTypeKeyManager.read(buf),
            FfiConverterOptionalTypeDsa.read(buf),
        )
    }

    override fun allocationSize(value: DidJwkCreateOptions) = (
            FfiConverterOptionalTypeKeyManager.allocationSize(value.`keyManager`) +
            FfiConverterOptionalTypeDsa.allocationSize(value.`dsa`)
    )

    override fun write(value: DidJwkCreateOptions, buf: ByteBuffer) {
            FfiConverterOptionalTypeKeyManager.write(value.`keyManager`, buf)
            FfiConverterOptionalTypeDsa.write(value.`dsa`, buf)
    }
}



data class DidWebCreateOptions (
    var `keyManager`: KeyManager?, 
    var `dsa`: Dsa?, 
    var `service`: List<ServiceData>?, 
    var `controller`: List<kotlin.String>?, 
    var `alsoKnownAs`: List<kotlin.String>?, 
    var `verificationMethod`: List<VerificationMethodData>?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`keyManager`, 
        this.`dsa`, 
        this.`service`, 
        this.`controller`, 
        this.`alsoKnownAs`, 
        this.`verificationMethod`)
    }
    
    companion object
}

public object FfiConverterTypeDidWebCreateOptions: FfiConverterRustBuffer<DidWebCreateOptions> {
    override fun read(buf: ByteBuffer): DidWebCreateOptions {
        return DidWebCreateOptions(
            FfiConverterOptionalTypeKeyManager.read(buf),
            FfiConverterOptionalTypeDsa.read(buf),
            FfiConverterOptionalSequenceTypeServiceData.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceTypeVerificationMethodData.read(buf),
        )
    }

    override fun allocationSize(value: DidWebCreateOptions) = (
            FfiConverterOptionalTypeKeyManager.allocationSize(value.`keyManager`) +
            FfiConverterOptionalTypeDsa.allocationSize(value.`dsa`) +
            FfiConverterOptionalSequenceTypeServiceData.allocationSize(value.`service`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`controller`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`alsoKnownAs`) +
            FfiConverterOptionalSequenceTypeVerificationMethodData.allocationSize(value.`verificationMethod`)
    )

    override fun write(value: DidWebCreateOptions, buf: ByteBuffer) {
            FfiConverterOptionalTypeKeyManager.write(value.`keyManager`, buf)
            FfiConverterOptionalTypeDsa.write(value.`dsa`, buf)
            FfiConverterOptionalSequenceTypeServiceData.write(value.`service`, buf)
            FfiConverterOptionalSequenceString.write(value.`controller`, buf)
            FfiConverterOptionalSequenceString.write(value.`alsoKnownAs`, buf)
            FfiConverterOptionalSequenceTypeVerificationMethodData.write(value.`verificationMethod`, buf)
    }
}



data class DocumentData (
    var `id`: kotlin.String, 
    var `context`: List<kotlin.String>?, 
    var `controller`: List<kotlin.String>?, 
    var `alsoKnownAs`: List<kotlin.String>?, 
    var `verificationMethod`: List<VerificationMethodData>, 
    var `authentication`: List<kotlin.String>?, 
    var `assertionMethod`: List<kotlin.String>?, 
    var `keyAgreement`: List<kotlin.String>?, 
    var `capabilityInvocation`: List<kotlin.String>?, 
    var `capabilityDelegation`: List<kotlin.String>?, 
    var `service`: List<ServiceData>?
) {
    
    companion object
}

public object FfiConverterTypeDocumentData: FfiConverterRustBuffer<DocumentData> {
    override fun read(buf: ByteBuffer): DocumentData {
        return DocumentData(
            FfiConverterString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterSequenceTypeVerificationMethodData.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceTypeServiceData.read(buf),
        )
    }

    override fun allocationSize(value: DocumentData) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`context`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`controller`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`alsoKnownAs`) +
            FfiConverterSequenceTypeVerificationMethodData.allocationSize(value.`verificationMethod`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`authentication`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`assertionMethod`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`keyAgreement`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`capabilityInvocation`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`capabilityDelegation`) +
            FfiConverterOptionalSequenceTypeServiceData.allocationSize(value.`service`)
    )

    override fun write(value: DocumentData, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalSequenceString.write(value.`context`, buf)
            FfiConverterOptionalSequenceString.write(value.`controller`, buf)
            FfiConverterOptionalSequenceString.write(value.`alsoKnownAs`, buf)
            FfiConverterSequenceTypeVerificationMethodData.write(value.`verificationMethod`, buf)
            FfiConverterOptionalSequenceString.write(value.`authentication`, buf)
            FfiConverterOptionalSequenceString.write(value.`assertionMethod`, buf)
            FfiConverterOptionalSequenceString.write(value.`keyAgreement`, buf)
            FfiConverterOptionalSequenceString.write(value.`capabilityInvocation`, buf)
            FfiConverterOptionalSequenceString.write(value.`capabilityDelegation`, buf)
            FfiConverterOptionalSequenceTypeServiceData.write(value.`service`, buf)
    }
}



data class DocumentMetadataData (
    var `created`: kotlin.String?, 
    var `updated`: kotlin.String?, 
    var `deactivated`: kotlin.Boolean?, 
    var `nextUpdate`: kotlin.String?, 
    var `versionId`: kotlin.String?, 
    var `nextVersionId`: kotlin.String?, 
    var `equivalentId`: List<kotlin.String>?, 
    var `canonicalId`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeDocumentMetadataData: FfiConverterRustBuffer<DocumentMetadataData> {
    override fun read(buf: ByteBuffer): DocumentMetadataData {
        return DocumentMetadataData(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: DocumentMetadataData) = (
            FfiConverterOptionalString.allocationSize(value.`created`) +
            FfiConverterOptionalString.allocationSize(value.`updated`) +
            FfiConverterOptionalBoolean.allocationSize(value.`deactivated`) +
            FfiConverterOptionalString.allocationSize(value.`nextUpdate`) +
            FfiConverterOptionalString.allocationSize(value.`versionId`) +
            FfiConverterOptionalString.allocationSize(value.`nextVersionId`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`equivalentId`) +
            FfiConverterOptionalString.allocationSize(value.`canonicalId`)
    )

    override fun write(value: DocumentMetadataData, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`created`, buf)
            FfiConverterOptionalString.write(value.`updated`, buf)
            FfiConverterOptionalBoolean.write(value.`deactivated`, buf)
            FfiConverterOptionalString.write(value.`nextUpdate`, buf)
            FfiConverterOptionalString.write(value.`versionId`, buf)
            FfiConverterOptionalString.write(value.`nextVersionId`, buf)
            FfiConverterOptionalSequenceString.write(value.`equivalentId`, buf)
            FfiConverterOptionalString.write(value.`canonicalId`, buf)
    }
}



data class JwkData (
    var `alg`: kotlin.String?, 
    var `kty`: kotlin.String, 
    var `crv`: kotlin.String, 
    var `d`: kotlin.String?, 
    var `x`: kotlin.String, 
    var `y`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeJwkData: FfiConverterRustBuffer<JwkData> {
    override fun read(buf: ByteBuffer): JwkData {
        return JwkData(
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: JwkData) = (
            FfiConverterOptionalString.allocationSize(value.`alg`) +
            FfiConverterString.allocationSize(value.`kty`) +
            FfiConverterString.allocationSize(value.`crv`) +
            FfiConverterOptionalString.allocationSize(value.`d`) +
            FfiConverterString.allocationSize(value.`x`) +
            FfiConverterOptionalString.allocationSize(value.`y`)
    )

    override fun write(value: JwkData, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`alg`, buf)
            FfiConverterString.write(value.`kty`, buf)
            FfiConverterString.write(value.`crv`, buf)
            FfiConverterOptionalString.write(value.`d`, buf)
            FfiConverterString.write(value.`x`, buf)
            FfiConverterOptionalString.write(value.`y`, buf)
    }
}



data class PortableDidData (
    var `didUri`: kotlin.String, 
    var `document`: DocumentData, 
    var `privateJwks`: List<JwkData>
) {
    
    companion object
}

public object FfiConverterTypePortableDidData: FfiConverterRustBuffer<PortableDidData> {
    override fun read(buf: ByteBuffer): PortableDidData {
        return PortableDidData(
            FfiConverterString.read(buf),
            FfiConverterTypeDocumentData.read(buf),
            FfiConverterSequenceTypeJwkData.read(buf),
        )
    }

    override fun allocationSize(value: PortableDidData) = (
            FfiConverterString.allocationSize(value.`didUri`) +
            FfiConverterTypeDocumentData.allocationSize(value.`document`) +
            FfiConverterSequenceTypeJwkData.allocationSize(value.`privateJwks`)
    )

    override fun write(value: PortableDidData, buf: ByteBuffer) {
            FfiConverterString.write(value.`didUri`, buf)
            FfiConverterTypeDocumentData.write(value.`document`, buf)
            FfiConverterSequenceTypeJwkData.write(value.`privateJwks`, buf)
    }
}



data class ResolutionMetadataData (
    var `error`: ResolutionMetadataError?
) {
    
    companion object
}

public object FfiConverterTypeResolutionMetadataData: FfiConverterRustBuffer<ResolutionMetadataData> {
    override fun read(buf: ByteBuffer): ResolutionMetadataData {
        return ResolutionMetadataData(
            FfiConverterOptionalTypeResolutionMetadataError.read(buf),
        )
    }

    override fun allocationSize(value: ResolutionMetadataData) = (
            FfiConverterOptionalTypeResolutionMetadataError.allocationSize(value.`error`)
    )

    override fun write(value: ResolutionMetadataData, buf: ByteBuffer) {
            FfiConverterOptionalTypeResolutionMetadataError.write(value.`error`, buf)
    }
}



data class ResolutionResultData (
    var `document`: DocumentData?, 
    var `documentMetadata`: DocumentMetadataData?, 
    var `resolutionMetadata`: ResolutionMetadataData
) {
    
    companion object
}

public object FfiConverterTypeResolutionResultData: FfiConverterRustBuffer<ResolutionResultData> {
    override fun read(buf: ByteBuffer): ResolutionResultData {
        return ResolutionResultData(
            FfiConverterOptionalTypeDocumentData.read(buf),
            FfiConverterOptionalTypeDocumentMetadataData.read(buf),
            FfiConverterTypeResolutionMetadataData.read(buf),
        )
    }

    override fun allocationSize(value: ResolutionResultData) = (
            FfiConverterOptionalTypeDocumentData.allocationSize(value.`document`) +
            FfiConverterOptionalTypeDocumentMetadataData.allocationSize(value.`documentMetadata`) +
            FfiConverterTypeResolutionMetadataData.allocationSize(value.`resolutionMetadata`)
    )

    override fun write(value: ResolutionResultData, buf: ByteBuffer) {
            FfiConverterOptionalTypeDocumentData.write(value.`document`, buf)
            FfiConverterOptionalTypeDocumentMetadataData.write(value.`documentMetadata`, buf)
            FfiConverterTypeResolutionMetadataData.write(value.`resolutionMetadata`, buf)
    }
}



data class ServiceData (
    var `id`: kotlin.String, 
    var `type`: kotlin.String, 
    var `serviceEndpoint`: List<kotlin.String>
) {
    
    companion object
}

public object FfiConverterTypeServiceData: FfiConverterRustBuffer<ServiceData> {
    override fun read(buf: ByteBuffer): ServiceData {
        return ServiceData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: ServiceData) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`type`) +
            FfiConverterSequenceString.allocationSize(value.`serviceEndpoint`)
    )

    override fun write(value: ServiceData, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`type`, buf)
            FfiConverterSequenceString.write(value.`serviceEndpoint`, buf)
    }
}



data class VerifiableCredentialCreateOptionsData (
    var `id`: kotlin.String?, 
    var `context`: List<kotlin.String>?, 
    var `type`: List<kotlin.String>?, 
    var `issuanceDate`: java.time.Instant?, 
    var `expirationDate`: java.time.Instant?, 
    var `credentialStatus`: CredentialStatusData?, 
    var `credentialSchema`: CredentialSchemaData?, 
    var `jsonSerializedEvidence`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeVerifiableCredentialCreateOptionsData: FfiConverterRustBuffer<VerifiableCredentialCreateOptionsData> {
    override fun read(buf: ByteBuffer): VerifiableCredentialCreateOptionsData {
        return VerifiableCredentialCreateOptionsData(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalTimestamp.read(buf),
            FfiConverterOptionalTimestamp.read(buf),
            FfiConverterOptionalTypeCredentialStatusData.read(buf),
            FfiConverterOptionalTypeCredentialSchemaData.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: VerifiableCredentialCreateOptionsData) = (
            FfiConverterOptionalString.allocationSize(value.`id`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`context`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`type`) +
            FfiConverterOptionalTimestamp.allocationSize(value.`issuanceDate`) +
            FfiConverterOptionalTimestamp.allocationSize(value.`expirationDate`) +
            FfiConverterOptionalTypeCredentialStatusData.allocationSize(value.`credentialStatus`) +
            FfiConverterOptionalTypeCredentialSchemaData.allocationSize(value.`credentialSchema`) +
            FfiConverterOptionalString.allocationSize(value.`jsonSerializedEvidence`)
    )

    override fun write(value: VerifiableCredentialCreateOptionsData, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`id`, buf)
            FfiConverterOptionalSequenceString.write(value.`context`, buf)
            FfiConverterOptionalSequenceString.write(value.`type`, buf)
            FfiConverterOptionalTimestamp.write(value.`issuanceDate`, buf)
            FfiConverterOptionalTimestamp.write(value.`expirationDate`, buf)
            FfiConverterOptionalTypeCredentialStatusData.write(value.`credentialStatus`, buf)
            FfiConverterOptionalTypeCredentialSchemaData.write(value.`credentialSchema`, buf)
            FfiConverterOptionalString.write(value.`jsonSerializedEvidence`, buf)
    }
}



data class VerifiableCredentialData (
    var `context`: List<kotlin.String>, 
    var `type`: List<kotlin.String>, 
    var `id`: kotlin.String, 
    var `jsonSerializedIssuer`: kotlin.String, 
    var `jsonSerializedCredentialSubject`: kotlin.String, 
    var `issuanceDate`: java.time.Instant, 
    var `expirationDate`: java.time.Instant?, 
    var `credentialStatus`: CredentialStatusData?, 
    var `credentialSchema`: CredentialSchemaData?, 
    var `jsonSerializedEvidence`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeVerifiableCredentialData: FfiConverterRustBuffer<VerifiableCredentialData> {
    override fun read(buf: ByteBuffer): VerifiableCredentialData {
        return VerifiableCredentialData(
            FfiConverterSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTimestamp.read(buf),
            FfiConverterOptionalTimestamp.read(buf),
            FfiConverterOptionalTypeCredentialStatusData.read(buf),
            FfiConverterOptionalTypeCredentialSchemaData.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: VerifiableCredentialData) = (
            FfiConverterSequenceString.allocationSize(value.`context`) +
            FfiConverterSequenceString.allocationSize(value.`type`) +
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`jsonSerializedIssuer`) +
            FfiConverterString.allocationSize(value.`jsonSerializedCredentialSubject`) +
            FfiConverterTimestamp.allocationSize(value.`issuanceDate`) +
            FfiConverterOptionalTimestamp.allocationSize(value.`expirationDate`) +
            FfiConverterOptionalTypeCredentialStatusData.allocationSize(value.`credentialStatus`) +
            FfiConverterOptionalTypeCredentialSchemaData.allocationSize(value.`credentialSchema`) +
            FfiConverterOptionalString.allocationSize(value.`jsonSerializedEvidence`)
    )

    override fun write(value: VerifiableCredentialData, buf: ByteBuffer) {
            FfiConverterSequenceString.write(value.`context`, buf)
            FfiConverterSequenceString.write(value.`type`, buf)
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`jsonSerializedIssuer`, buf)
            FfiConverterString.write(value.`jsonSerializedCredentialSubject`, buf)
            FfiConverterTimestamp.write(value.`issuanceDate`, buf)
            FfiConverterOptionalTimestamp.write(value.`expirationDate`, buf)
            FfiConverterOptionalTypeCredentialStatusData.write(value.`credentialStatus`, buf)
            FfiConverterOptionalTypeCredentialSchemaData.write(value.`credentialSchema`, buf)
            FfiConverterOptionalString.write(value.`jsonSerializedEvidence`, buf)
    }
}



data class VerifiablePresentationCreateOptionsData (
    var `id`: kotlin.String?, 
    var `context`: List<kotlin.String>?, 
    var `type`: List<kotlin.String>?, 
    var `issuanceDate`: java.time.Instant?, 
    var `expirationDate`: java.time.Instant?, 
    var `jsonSerializedAdditionalData`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeVerifiablePresentationCreateOptionsData: FfiConverterRustBuffer<VerifiablePresentationCreateOptionsData> {
    override fun read(buf: ByteBuffer): VerifiablePresentationCreateOptionsData {
        return VerifiablePresentationCreateOptionsData(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalTimestamp.read(buf),
            FfiConverterOptionalTimestamp.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: VerifiablePresentationCreateOptionsData) = (
            FfiConverterOptionalString.allocationSize(value.`id`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`context`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`type`) +
            FfiConverterOptionalTimestamp.allocationSize(value.`issuanceDate`) +
            FfiConverterOptionalTimestamp.allocationSize(value.`expirationDate`) +
            FfiConverterOptionalString.allocationSize(value.`jsonSerializedAdditionalData`)
    )

    override fun write(value: VerifiablePresentationCreateOptionsData, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`id`, buf)
            FfiConverterOptionalSequenceString.write(value.`context`, buf)
            FfiConverterOptionalSequenceString.write(value.`type`, buf)
            FfiConverterOptionalTimestamp.write(value.`issuanceDate`, buf)
            FfiConverterOptionalTimestamp.write(value.`expirationDate`, buf)
            FfiConverterOptionalString.write(value.`jsonSerializedAdditionalData`, buf)
    }
}



data class VerifiablePresentationData (
    var `context`: List<kotlin.String>, 
    var `id`: kotlin.String, 
    var `type`: List<kotlin.String>, 
    var `holder`: kotlin.String, 
    var `issuanceDate`: java.time.Instant, 
    var `expirationDate`: java.time.Instant?, 
    var `verifiableCredential`: List<kotlin.String>, 
    var `jsonSerializedAdditionalData`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeVerifiablePresentationData: FfiConverterRustBuffer<VerifiablePresentationData> {
    override fun read(buf: ByteBuffer): VerifiablePresentationData {
        return VerifiablePresentationData(
            FfiConverterSequenceString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTimestamp.read(buf),
            FfiConverterOptionalTimestamp.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: VerifiablePresentationData) = (
            FfiConverterSequenceString.allocationSize(value.`context`) +
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterSequenceString.allocationSize(value.`type`) +
            FfiConverterString.allocationSize(value.`holder`) +
            FfiConverterTimestamp.allocationSize(value.`issuanceDate`) +
            FfiConverterOptionalTimestamp.allocationSize(value.`expirationDate`) +
            FfiConverterSequenceString.allocationSize(value.`verifiableCredential`) +
            FfiConverterOptionalString.allocationSize(value.`jsonSerializedAdditionalData`)
    )

    override fun write(value: VerifiablePresentationData, buf: ByteBuffer) {
            FfiConverterSequenceString.write(value.`context`, buf)
            FfiConverterString.write(value.`id`, buf)
            FfiConverterSequenceString.write(value.`type`, buf)
            FfiConverterString.write(value.`holder`, buf)
            FfiConverterTimestamp.write(value.`issuanceDate`, buf)
            FfiConverterOptionalTimestamp.write(value.`expirationDate`, buf)
            FfiConverterSequenceString.write(value.`verifiableCredential`, buf)
            FfiConverterOptionalString.write(value.`jsonSerializedAdditionalData`, buf)
    }
}



data class VerificationMethodData (
    var `id`: kotlin.String, 
    var `type`: kotlin.String, 
    var `controller`: kotlin.String, 
    var `publicKeyJwk`: JwkData
) {
    
    companion object
}

public object FfiConverterTypeVerificationMethodData: FfiConverterRustBuffer<VerificationMethodData> {
    override fun read(buf: ByteBuffer): VerificationMethodData {
        return VerificationMethodData(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTypeJwkData.read(buf),
        )
    }

    override fun allocationSize(value: VerificationMethodData) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`type`) +
            FfiConverterString.allocationSize(value.`controller`) +
            FfiConverterTypeJwkData.allocationSize(value.`publicKeyJwk`)
    )

    override fun write(value: VerificationMethodData, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`type`, buf)
            FfiConverterString.write(value.`controller`, buf)
            FfiConverterTypeJwkData.write(value.`publicKeyJwk`, buf)
    }
}




enum class Dsa {
    
    ED25519,
    SECP256K1;
    companion object
}


public object FfiConverterTypeDsa: FfiConverterRustBuffer<Dsa> {
    override fun read(buf: ByteBuffer) = try {
        Dsa.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: Dsa) = 4UL

    override fun write(value: Dsa, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class ResolutionMetadataError {
    
    INVALID_DID,
    NOT_FOUND,
    REPRESENTATION_NOT_SUPPORTED,
    METHOD_NOT_SUPPORTED,
    INVALID_DID_DOCUMENT,
    INVALID_PUBLIC_KEY,
    INVALID_DID_DOCUMENT_LENGTH,
    INTERNAL_ERROR;
    companion object
}


public object FfiConverterTypeResolutionMetadataError: FfiConverterRustBuffer<ResolutionMetadataError> {
    override fun read(buf: ByteBuffer) = try {
        ResolutionMetadataError.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: ResolutionMetadataError) = 4UL

    override fun write(value: ResolutionMetadataError, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class Web5Exception: Exception() {
    
    class Exception(
        
        val `variant`: kotlin.String, 
        
        val `msg`: kotlin.String
        ) : Web5Exception() {
        override val message
            get() = "variant=${ `variant` }, msg=${ `msg` }"
    }
    

    companion object ErrorHandler : UniffiRustCallStatusErrorHandler<Web5Exception> {
        override fun lift(error_buf: RustBuffer.ByValue): Web5Exception = FfiConverterTypeWeb5Error.lift(error_buf)
    }

    
}

public object FfiConverterTypeWeb5Error : FfiConverterRustBuffer<Web5Exception> {
    override fun read(buf: ByteBuffer): Web5Exception {
        

        return when(buf.getInt()) {
            1 -> Web5Exception.Exception(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: Web5Exception): ULong {
        return when(value) {
            is Web5Exception.Exception -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`variant`)
                + FfiConverterString.allocationSize(value.`msg`)
            )
        }
    }

    override fun write(value: Web5Exception, buf: ByteBuffer) {
        when(value) {
            is Web5Exception.Exception -> {
                buf.putInt(1)
                FfiConverterString.write(value.`variant`, buf)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




public object FfiConverterOptionalBoolean: FfiConverterRustBuffer<kotlin.Boolean?> {
    override fun read(buf: ByteBuffer): kotlin.Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: kotlin.Boolean?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(value: kotlin.Boolean?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}




public object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTimestamp: FfiConverterRustBuffer<java.time.Instant?> {
    override fun read(buf: ByteBuffer): java.time.Instant? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTimestamp.read(buf)
    }

    override fun allocationSize(value: java.time.Instant?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTimestamp.allocationSize(value)
        }
    }

    override fun write(value: java.time.Instant?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTimestamp.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeKeyManager: FfiConverterRustBuffer<KeyManager?> {
    override fun read(buf: ByteBuffer): KeyManager? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeKeyManager.read(buf)
    }

    override fun allocationSize(value: KeyManager?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeKeyManager.allocationSize(value)
        }
    }

    override fun write(value: KeyManager?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeKeyManager.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeCredentialSchemaData: FfiConverterRustBuffer<CredentialSchemaData?> {
    override fun read(buf: ByteBuffer): CredentialSchemaData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeCredentialSchemaData.read(buf)
    }

    override fun allocationSize(value: CredentialSchemaData?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeCredentialSchemaData.allocationSize(value)
        }
    }

    override fun write(value: CredentialSchemaData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeCredentialSchemaData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeCredentialStatusData: FfiConverterRustBuffer<CredentialStatusData?> {
    override fun read(buf: ByteBuffer): CredentialStatusData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeCredentialStatusData.read(buf)
    }

    override fun allocationSize(value: CredentialStatusData?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeCredentialStatusData.allocationSize(value)
        }
    }

    override fun write(value: CredentialStatusData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeCredentialStatusData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeDidDhtCreateOptions: FfiConverterRustBuffer<DidDhtCreateOptions?> {
    override fun read(buf: ByteBuffer): DidDhtCreateOptions? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDidDhtCreateOptions.read(buf)
    }

    override fun allocationSize(value: DidDhtCreateOptions?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDidDhtCreateOptions.allocationSize(value)
        }
    }

    override fun write(value: DidDhtCreateOptions?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDidDhtCreateOptions.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeDidJwkCreateOptions: FfiConverterRustBuffer<DidJwkCreateOptions?> {
    override fun read(buf: ByteBuffer): DidJwkCreateOptions? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDidJwkCreateOptions.read(buf)
    }

    override fun allocationSize(value: DidJwkCreateOptions?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDidJwkCreateOptions.allocationSize(value)
        }
    }

    override fun write(value: DidJwkCreateOptions?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDidJwkCreateOptions.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeDidWebCreateOptions: FfiConverterRustBuffer<DidWebCreateOptions?> {
    override fun read(buf: ByteBuffer): DidWebCreateOptions? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDidWebCreateOptions.read(buf)
    }

    override fun allocationSize(value: DidWebCreateOptions?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDidWebCreateOptions.allocationSize(value)
        }
    }

    override fun write(value: DidWebCreateOptions?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDidWebCreateOptions.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeDocumentData: FfiConverterRustBuffer<DocumentData?> {
    override fun read(buf: ByteBuffer): DocumentData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDocumentData.read(buf)
    }

    override fun allocationSize(value: DocumentData?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDocumentData.allocationSize(value)
        }
    }

    override fun write(value: DocumentData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDocumentData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeDocumentMetadataData: FfiConverterRustBuffer<DocumentMetadataData?> {
    override fun read(buf: ByteBuffer): DocumentMetadataData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDocumentMetadataData.read(buf)
    }

    override fun allocationSize(value: DocumentMetadataData?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDocumentMetadataData.allocationSize(value)
        }
    }

    override fun write(value: DocumentMetadataData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDocumentMetadataData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeVerifiableCredentialCreateOptionsData: FfiConverterRustBuffer<VerifiableCredentialCreateOptionsData?> {
    override fun read(buf: ByteBuffer): VerifiableCredentialCreateOptionsData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVerifiableCredentialCreateOptionsData.read(buf)
    }

    override fun allocationSize(value: VerifiableCredentialCreateOptionsData?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeVerifiableCredentialCreateOptionsData.allocationSize(value)
        }
    }

    override fun write(value: VerifiableCredentialCreateOptionsData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVerifiableCredentialCreateOptionsData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeVerifiablePresentationCreateOptionsData: FfiConverterRustBuffer<VerifiablePresentationCreateOptionsData?> {
    override fun read(buf: ByteBuffer): VerifiablePresentationCreateOptionsData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVerifiablePresentationCreateOptionsData.read(buf)
    }

    override fun allocationSize(value: VerifiablePresentationCreateOptionsData?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeVerifiablePresentationCreateOptionsData.allocationSize(value)
        }
    }

    override fun write(value: VerifiablePresentationCreateOptionsData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVerifiablePresentationCreateOptionsData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeDsa: FfiConverterRustBuffer<Dsa?> {
    override fun read(buf: ByteBuffer): Dsa? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDsa.read(buf)
    }

    override fun allocationSize(value: Dsa?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDsa.allocationSize(value)
        }
    }

    override fun write(value: Dsa?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDsa.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeResolutionMetadataError: FfiConverterRustBuffer<ResolutionMetadataError?> {
    override fun read(buf: ByteBuffer): ResolutionMetadataError? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeResolutionMetadataError.read(buf)
    }

    override fun allocationSize(value: ResolutionMetadataError?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeResolutionMetadataError.allocationSize(value)
        }
    }

    override fun write(value: ResolutionMetadataError?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeResolutionMetadataError.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceString: FfiConverterRustBuffer<List<kotlin.String>?> {
    override fun read(buf: ByteBuffer): List<kotlin.String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceString.read(buf)
    }

    override fun allocationSize(value: List<kotlin.String>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceString.allocationSize(value)
        }
    }

    override fun write(value: List<kotlin.String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeVerifiableCredential: FfiConverterRustBuffer<List<VerifiableCredential>?> {
    override fun read(buf: ByteBuffer): List<VerifiableCredential>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeVerifiableCredential.read(buf)
    }

    override fun allocationSize(value: List<VerifiableCredential>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeVerifiableCredential.allocationSize(value)
        }
    }

    override fun write(value: List<VerifiableCredential>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeVerifiableCredential.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeServiceData: FfiConverterRustBuffer<List<ServiceData>?> {
    override fun read(buf: ByteBuffer): List<ServiceData>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeServiceData.read(buf)
    }

    override fun allocationSize(value: List<ServiceData>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeServiceData.allocationSize(value)
        }
    }

    override fun write(value: List<ServiceData>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeServiceData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeVerificationMethodData: FfiConverterRustBuffer<List<VerificationMethodData>?> {
    override fun read(buf: ByteBuffer): List<VerificationMethodData>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeVerificationMethodData.read(buf)
    }

    override fun allocationSize(value: List<VerificationMethodData>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeVerificationMethodData.allocationSize(value)
        }
    }

    override fun write(value: List<VerificationMethodData>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeVerificationMethodData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalMapStringString: FfiConverterRustBuffer<Map<kotlin.String, kotlin.String>?> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, kotlin.String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterMapStringString.read(buf)
    }

    override fun allocationSize(value: Map<kotlin.String, kotlin.String>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterMapStringString.allocationSize(value)
        }
    }

    override fun write(value: Map<kotlin.String, kotlin.String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterMapStringString.write(value, buf)
        }
    }
}




public object FfiConverterSequenceString: FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: ByteBuffer): List<kotlin.String> {
        val len = buf.getInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeVerifiableCredential: FfiConverterRustBuffer<List<VerifiableCredential>> {
    override fun read(buf: ByteBuffer): List<VerifiableCredential> {
        val len = buf.getInt()
        return List<VerifiableCredential>(len) {
            FfiConverterTypeVerifiableCredential.read(buf)
        }
    }

    override fun allocationSize(value: List<VerifiableCredential>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeVerifiableCredential.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<VerifiableCredential>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeVerifiableCredential.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeJwkData: FfiConverterRustBuffer<List<JwkData>> {
    override fun read(buf: ByteBuffer): List<JwkData> {
        val len = buf.getInt()
        return List<JwkData>(len) {
            FfiConverterTypeJwkData.read(buf)
        }
    }

    override fun allocationSize(value: List<JwkData>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeJwkData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<JwkData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeJwkData.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeServiceData: FfiConverterRustBuffer<List<ServiceData>> {
    override fun read(buf: ByteBuffer): List<ServiceData> {
        val len = buf.getInt()
        return List<ServiceData>(len) {
            FfiConverterTypeServiceData.read(buf)
        }
    }

    override fun allocationSize(value: List<ServiceData>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeServiceData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ServiceData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeServiceData.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeVerificationMethodData: FfiConverterRustBuffer<List<VerificationMethodData>> {
    override fun read(buf: ByteBuffer): List<VerificationMethodData> {
        val len = buf.getInt()
        return List<VerificationMethodData>(len) {
            FfiConverterTypeVerificationMethodData.read(buf)
        }
    }

    override fun allocationSize(value: List<VerificationMethodData>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeVerificationMethodData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<VerificationMethodData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeVerificationMethodData.write(it, buf)
        }
    }
}



public object FfiConverterMapStringString: FfiConverterRustBuffer<Map<kotlin.String, kotlin.String>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, kotlin.String> {
        val len = buf.getInt()
        return buildMap<kotlin.String, kotlin.String>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterString.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, kotlin.String>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterString.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<kotlin.String, kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterString.write(v, buf)
        }
    }
}
    @Throws(Web5Exception::class) fun `didDhtCreate`(`options`: DidDhtCreateOptions?): BearerDid {
            return FfiConverterTypeBearerDid.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_did_dht_create(
        FfiConverterOptionalTypeDidDhtCreateOptions.lower(`options`),_status)
}
    )
    }
    

    @Throws(Web5Exception::class) fun `didDhtPublish`(`bearerDid`: BearerDid, `gatewayUrl`: kotlin.String?)
        = 
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_did_dht_publish(
        FfiConverterTypeBearerDid.lower(`bearerDid`),FfiConverterOptionalString.lower(`gatewayUrl`),_status)
}
    
    
 fun `didDhtResolve`(`uri`: kotlin.String, `gatewayUrl`: kotlin.String?): ResolutionResult {
            return FfiConverterTypeResolutionResult.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_did_dht_resolve(
        FfiConverterString.lower(`uri`),FfiConverterOptionalString.lower(`gatewayUrl`),_status)
}
    )
    }
    

    @Throws(Web5Exception::class) fun `didJwkCreate`(`options`: DidJwkCreateOptions?): BearerDid {
            return FfiConverterTypeBearerDid.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_did_jwk_create(
        FfiConverterOptionalTypeDidJwkCreateOptions.lower(`options`),_status)
}
    )
    }
    
 fun `didJwkResolve`(`uri`: kotlin.String): ResolutionResult {
            return FfiConverterTypeResolutionResult.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_did_jwk_resolve(
        FfiConverterString.lower(`uri`),_status)
}
    )
    }
    

    @Throws(Web5Exception::class) fun `didWebCreate`(`domain`: kotlin.String, `options`: DidWebCreateOptions?): BearerDid {
            return FfiConverterTypeBearerDid.lift(
    uniffiRustCallWithError(Web5Exception) { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_did_web_create(
        FfiConverterString.lower(`domain`),FfiConverterOptionalTypeDidWebCreateOptions.lower(`options`),_status)
}
    )
    }
    
 fun `didWebResolve`(`uri`: kotlin.String): ResolutionResult {
            return FfiConverterTypeResolutionResult.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_did_web_resolve(
        FfiConverterString.lower(`uri`),_status)
}
    )
    }
    
 fun `ed25519GeneratorGenerate`(): JwkData {
            return FfiConverterTypeJwkData.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_ed25519_generator_generate(
        _status)
}
    )
    }
    
 fun `secp256k1GeneratorGenerate`(): JwkData {
            return FfiConverterTypeJwkData.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_web5_uniffi_fn_func_secp256k1_generator_generate(
        _status)
}
    )
    }
    


