/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.fn.Fn0;
import xyz.cofe.fn.Fn1;
import xyz.cofe.fn.Fn2;
import xyz.cofe.text.template.TemplateASTVisitor;
import xyz.cofe.text.template.ast.Block;
import xyz.cofe.text.template.ast.Code;
import xyz.cofe.text.template.ast.Escape;
import xyz.cofe.text.template.ast.Text;

public class EvalVisitor<ResultType, EvalCode, EvalText>
extends TemplateASTVisitor {
    public Fn1<String, EvalText> evalText;
    public Fn1<String, EvalCode> evalCode;
    public Fn0<ResultType> initResult;
    public Fn2<ResultType, EvalText, ResultType> appendText;
    public Fn2<ResultType, EvalCode, ResultType> appendCode;
    public List<Fn0> funs = new ArrayList<Fn0>();
    public Map<Fn0, Boolean> funAsCode = new LinkedHashMap<Fn0, Boolean>();
    public boolean codeContext = false;
    public StringBuilder sbCode = new StringBuilder();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(EvalVisitor.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(EvalVisitor.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(EvalVisitor.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(EvalVisitor.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(EvalVisitor.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(EvalVisitor.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(EvalVisitor.class.getName()).log(Level.SEVERE, null, ex);
    }

    @Override
    public void visit(Text text) {
        if (this.codeContext) {
            this.sbCode.append(text.token.getMatchedText());
        } else {
            final String srcText = text.token.getMatchedText();
            Fn0 f = new Fn0<EvalText>(){

                public EvalText apply() {
                    return EvalVisitor.this.evalText.apply((Object)srcText);
                }
            };
            this.funs.add(f);
            this.funAsCode.put(f, false);
        }
    }

    @Override
    public void visit(Escape escape) {
        if (this.codeContext) {
            this.sbCode.append(escape.token.getMatchedText());
        } else {
            String srcText = escape.token.getMatchedText();
            for (Map.Entry<String, String> en : escape.rewriteMap.entrySet()) {
                srcText = srcText.replace(en.getKey(), en.getValue());
            }
            final String rewritedText = srcText;
            Fn0 f = new Fn0<EvalText>(){

                public EvalText apply() {
                    return EvalVisitor.this.evalText.apply((Object)rewritedText);
                }
            };
            this.funs.add(f);
            this.funAsCode.put(f, false);
        }
    }

    @Override
    public void enter(Block block) {
        if (this.codeContext) {
            this.sbCode.append(block.begin.getMatchedText());
        } else {
            final String srccode = block.begin.getMatchedText();
            Fn0 f = new Fn0<EvalText>(){

                public EvalText apply() {
                    return EvalVisitor.this.evalText.apply((Object)srccode);
                }
            };
            this.funs.add(f);
            this.funAsCode.put(f, false);
        }
    }

    @Override
    public void exit(Block block) {
        if (this.codeContext) {
            this.sbCode.append(block.end.getMatchedText());
        } else {
            final String srccode = block.end.getMatchedText();
            Fn0 f = new Fn0<EvalText>(){

                public EvalText apply() {
                    return EvalVisitor.this.evalText.apply((Object)srccode);
                }
            };
            this.funs.add(f);
            this.funAsCode.put(f, false);
        }
    }

    @Override
    public void enter(Code code) {
        this.codeContext = true;
        this.sbCode.setLength(0);
    }

    @Override
    public void exit(Code code) {
        this.codeContext = false;
        if (this.sbCode.length() > 0) {
            final String srccode = this.sbCode.toString();
            Fn0 f = new Fn0<EvalCode>(){

                public EvalCode apply() {
                    return EvalVisitor.this.evalCode.apply((Object)srccode);
                }
            };
            this.funs.add(f);
            this.funAsCode.put(f, true);
        }
    }
}

