/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import xyz.cofe.fn.Pair;
import xyz.cofe.iter.Eterable;
import xyz.cofe.simpletypes.SimpleTypes;
import xyz.cofe.text.template.SetOwner;
import xyz.cofe.text.template.ValueController;

public class PropertyController
implements ValueController,
SetOwner {
    private Object owner;
    private Class type;
    private Method set;
    private Method get;
    private String name;

    public PropertyController(Object objOwner, String name, Class type, Method set, Method get) {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (get == null) {
            throw new IllegalArgumentException("get == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.name = name;
        this.owner = objOwner;
        this.type = type;
        this.set = set;
        this.get = get;
    }

    public Method getGetMethod() {
        return this.get;
    }

    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object newOwner) {
        this.owner = newOwner;
    }

    public Method getSetMethod() {
        return this.set;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Object getValue() throws Throwable {
        return this.get.invoke(this.owner, new Object[0]);
    }

    @Override
    public void setValue(Object value) throws Throwable {
        this.set.invoke(this.owner, value);
    }

    public static Map<String, ValueController> buildControllersMap(Object obj) {
        Eterable<ValueController> ctrollers = PropertyController.buildControllers(obj);
        HashMap<String, ValueController> res = new HashMap<String, ValueController>();
        if (ctrollers == null) {
            return res;
        }
        for (ValueController vc : ctrollers) {
            res.put(vc.getName(), vc);
        }
        return res;
    }

    public static Eterable<PropertyController> buildPropertiesList(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        ArrayList<PropertyController> props = new ArrayList<PropertyController>();
        ArrayList<Pair> methods = new ArrayList<Pair>();
        Method[] _methods = cls.getMethods();
        for (Method m : _methods) {
            String name = m.getName();
            Class<?> methodReturn = m.getReturnType();
            boolean toLower = false;
            if (name.startsWith("get") && name.length() > 3) {
                name = name.substring(3);
                toLower = true;
            } else if (name.startsWith("is") && name.length() > 2 && SimpleTypes.isBoolean(methodReturn)) {
                name = name.substring(2);
                toLower = true;
            } else if (name.startsWith("set") && name.length() > 3) {
                name = name.substring(3);
                toLower = true;
            }
            if (toLower && name.length() > 0 && Character.isUpperCase(name.charAt(0))) {
                String newName = "" + Character.toLowerCase(name.charAt(0));
                if (name.length() > 1) {
                    newName = newName + name.substring(1);
                }
                name = newName;
            }
            Method f_m = m;
            String f_name = name;
            Pair v = Pair.of((Object)f_name, (Object)f_m);
            methods.add(v);
        }
        for (Pair pmGet : methods) {
            Class<?>[] paramsGet;
            Method mGet = (Method)pmGet.b();
            Class<?> ret = mGet.getReturnType();
            if (SimpleTypes.isVoid(ret) || (paramsGet = mGet.getParameterTypes()).length != 0 || !mGet.getName().startsWith("get") && (!mGet.getName().startsWith("is") || !SimpleTypes.isBoolean(ret))) continue;
            for (Pair pmSet : methods) {
                Class<?> param;
                Class<?>[] paramsSet;
                Method mSet = (Method)pmSet.b();
                if (!mSet.getName().startsWith("set") || (paramsSet = mSet.getParameterTypes()).length != 1 || !(param = paramsSet[0]).equals(ret)) continue;
                String pnA = (String)pmGet.a();
                String pnB = (String)pmSet.a();
                if (pnA == null || pnB == null || !pnA.equals(pnB)) continue;
                PropertyController pController = new PropertyController(null, pnA, ret, mSet, mGet);
                props.add(pController);
            }
        }
        return Eterable.of(props);
    }

    public static Eterable<ValueController> buildControllers(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj == null");
        }
        Class<?> cOType = obj.getClass();
        Eterable<PropertyController> itr = PropertyController.buildPropertiesList(cOType);
        for (Object o : itr) {
            if (!(o instanceof PropertyController)) continue;
            ((PropertyController)o).setOwner(obj);
        }
        return itr;
    }
}

