/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Pointer;
import xyz.cofe.fn.Fn0;
import xyz.cofe.fn.Fn1;
import xyz.cofe.fn.Fn2;
import xyz.cofe.text.lex.Token;
import xyz.cofe.text.template.EvalVisitor;
import xyz.cofe.text.template.TemplateLexer;
import xyz.cofe.text.template.ast.AstNode;
import xyz.cofe.text.template.ast.Block;
import xyz.cofe.text.template.ast.BlockBody;
import xyz.cofe.text.template.ast.Code;
import xyz.cofe.text.template.ast.Escape;
import xyz.cofe.text.template.ast.Sequence;
import xyz.cofe.text.template.ast.Text;

public class TemplateParser {
    protected LinkedHashMap<String, String> escapeRewriteMap;
    protected String[] codeBeginLexems;
    protected String[] escapeLexems;
    protected String[] blockBeginLexems;
    protected String[] blockEndLexems;
    protected LinkedHashMap<String, String> currentEscapeRewriteMap;
    protected final Fn1<Pointer<Token>, AstNode> start_code = ptr -> {
        AstNode c = this.code((Pointer<Token>)ptr);
        if (c == null) {
            return null;
        }
        AstNode n = this.start((Pointer<Token>)ptr);
        if (n == null) {
            return c;
        }
        return new Sequence(c, n);
    };
    protected final Fn1<Pointer<Token>, AstNode> start_any = ptr -> {
        Token t = (Token)ptr.lookup(0);
        Text text = new Text(t);
        ptr.move(1);
        AstNode v = this.start((Pointer<Token>)ptr);
        if (v == null) {
            return text;
        }
        return new Sequence(text, v);
    };
    protected final Fn1<Pointer<Token>, AstNode> start_escape = new Fn1<Pointer<Token>, AstNode>(){

        public AstNode apply(Pointer<Token> ptr) {
            Token t = (Token)ptr.lookup(0);
            Escape esc = new Escape(t, TemplateParser.this.currentEscapeRewriteMap);
            ptr.move(1);
            AstNode v = TemplateParser.this.start(ptr);
            if (v == null) {
                return esc;
            }
            return new Sequence(esc, v);
        }
    };
    protected final Map<String, Fn1<Pointer<Token>, AstNode>> start_patterns = this.map("codeBegin", this.start_code).map("anyChar", this.start_any).map("blockBegin", this.start_any).map("blockEnd", this.start_any).map("escape", this.start_escape);

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TemplateParser.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected synchronized LinkedHashMap<String, String> getEscapeRewriteMap() {
        if (this.escapeRewriteMap != null) {
            return this.escapeRewriteMap;
        }
        this.escapeRewriteMap = this.createEscapeRewriteMap();
        return this.escapeRewriteMap;
    }

    protected synchronized LinkedHashMap<String, String> createEscapeRewriteMap() {
        LinkedHashMap<String, String> escapeRewriteMap = new LinkedHashMap<String, String>();
        escapeRewriteMap.put("\\${", "${");
        escapeRewriteMap.put("\\$", "$");
        escapeRewriteMap.put("\\\\", "\\");
        return escapeRewriteMap;
    }

    protected String[] getCodeBeginLexems() {
        if (this.codeBeginLexems != null) {
            return this.codeBeginLexems;
        }
        this.codeBeginLexems = new String[]{"${"};
        return this.codeBeginLexems;
    }

    protected String[] getEscapeLexems() {
        if (this.escapeLexems != null) {
            return this.escapeLexems;
        }
        this.escapeLexems = new String[]{"\\${", "\\$", "\\\\"};
        return this.escapeLexems;
    }

    protected String[] getBlockBeginLexems() {
        if (this.blockBeginLexems != null) {
            return this.blockBeginLexems;
        }
        this.blockBeginLexems = new String[]{"{"};
        return this.blockBeginLexems;
    }

    protected String[] getBlockEndLexems() {
        if (this.blockEndLexems != null) {
            return this.blockEndLexems;
        }
        this.blockEndLexems = new String[]{"}"};
        return this.blockEndLexems;
    }

    public <ResultType, EvalCode, EvalText> Fn0<ResultType> eval(AstNode tree, Fn1<String, EvalText> evalText, Fn1<String, EvalCode> evalCode, Fn0<ResultType> initResult, Fn2<ResultType, EvalText, ResultType> appendText, Fn2<ResultType, EvalCode, ResultType> appendCode) {
        ArrayList<Fn0> funs = new ArrayList<Fn0>();
        LinkedHashMap<Fn0, Boolean> funAsCode = new LinkedHashMap<Fn0, Boolean>();
        EvalVisitor ev = new EvalVisitor();
        ev.appendCode = appendCode;
        ev.appendText = appendText;
        ev.initResult = initResult;
        ev.evalCode = evalCode;
        ev.evalText = evalText;
        ev.funAsCode = funAsCode;
        ev.funs = funs;
        ev.codeContext = false;
        ev.sbCode = new StringBuilder();
        EvalVisitor.visit(tree, ev);
        return () -> {
            Object res = initResult.apply();
            for (Fn0 f : funs) {
                if (((Boolean)funAsCode.get(f)).booleanValue()) {
                    res = appendCode.apply(res, f.apply());
                    continue;
                }
                res = appendText.apply(res, f.apply());
            }
            return res;
        };
    }

    public Fn0<String> evalAndPrint(AstNode tree, Fn1<String, String> evalCode) {
        if (tree == null) {
            throw new IllegalArgumentException("tree==null");
        }
        if (evalCode == null) {
            throw new IllegalArgumentException("evalCode==null");
        }
        return this.eval(tree, arg -> arg, evalCode, () -> "", (src, append) -> src + append, (src, append) -> src + append);
    }

    public Fn0<String> evalAndPrint(AstNode tree, Fn1<String, String> evalText, Fn1<String, String> evalCode) {
        if (tree == null) {
            throw new IllegalArgumentException("tree==null");
        }
        if (evalCode == null) {
            throw new IllegalArgumentException("evalCode==null");
        }
        if (evalText == null) {
            throw new IllegalArgumentException("evalText==null");
        }
        return this.eval(tree, evalText, evalCode, () -> "", (src, append) -> src + append, (src, append) -> src + append);
    }

    public synchronized AstNode parse(String source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.currentEscapeRewriteMap = new LinkedHashMap<String, String>(this.getEscapeRewriteMap());
        TemplateLexer lexer = new TemplateLexer(this.getCodeBeginLexems(), this.getEscapeLexems(), this.getBlockBeginLexems(), this.getBlockEndLexems());
        List tokens = lexer.parse(source);
        Pointer ptr = new Pointer(tokens);
        AstNode v = this.start((Pointer<Token>)ptr);
        return v;
    }

    protected <K, V> Mapping<K, V> map(K k, V v) {
        Mapping<K, V> m = new Mapping<K, V>();
        m.put(k, v);
        return m;
    }

    private static boolean in(String id, String ... arr) {
        return xyz.cofe.text.Text.in((String)id, (String[])arr);
    }

    protected synchronized AstNode start(Pointer<Token> ptr) {
        Token t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        String id = t.getId();
        for (Map.Entry<String, Fn1<Pointer<Token>, AstNode>> me : this.start_patterns.entrySet()) {
            String mid = me.getKey();
            Fn1<Pointer<Token>, AstNode> fn = me.getValue();
            if (!mid.equals(id)) continue;
            return (AstNode)fn.apply(ptr);
        }
        return null;
    }

    private synchronized AstNode code(Pointer<Token> ptr) {
        Token t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        String id = t.getId();
        if (!id.equals("codeBegin")) {
            return null;
        }
        ptr.push();
        ptr.move(1);
        BlockBody blockBody = this.blockBody(ptr);
        if (blockBody == null) {
            ptr.restore();
            return null;
        }
        Token tEnd = (Token)ptr.lookup(0);
        if (tEnd == null) {
            ptr.restore();
            return null;
        }
        if (!tEnd.getId().equals("blockEnd")) {
            ptr.restore();
            return null;
        }
        ptr.pop();
        ptr.move(1);
        return new Code(t, blockBody, tEnd);
    }

    private synchronized BlockBody blockBody(Pointer<Token> ptr) {
        Token t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        String id = t.getId();
        if (TemplateParser.in(id, "anyChar")) {
            Text txt = new Text(t);
            ptr.move(1);
            BlockBody v = this.blockBody(ptr);
            if (v == null) {
                return new BlockBody(txt);
            }
            return new BlockBody(new Sequence(txt, v));
        }
        if (TemplateParser.in(id, "escape")) {
            Escape esc = new Escape(t, this.currentEscapeRewriteMap);
            ptr.move(1);
            BlockBody v = this.blockBody(ptr);
            if (v == null) {
                return new BlockBody(esc);
            }
            return new BlockBody(new Sequence(esc, v));
        }
        if (TemplateParser.in(id, "blockBegin")) {
            Block v = this.block(ptr);
            if (v == null) {
                return null;
            }
            BlockBody bb = this.blockBody(ptr);
            if (bb == null) {
                return new BlockBody(v);
            }
            return new BlockBody(new Sequence(v, bb));
        }
        return null;
    }

    private synchronized Block block(Pointer<Token> ptr) {
        Token t0 = (Token)ptr.lookup(0);
        if (t0 == null) {
            return null;
        }
        String id0 = t0.getId();
        if (!TemplateParser.in(id0, "blockBegin")) {
            return null;
        }
        ptr.push();
        ptr.move(1);
        BlockBody body = this.blockBody(ptr);
        if (body == null) {
            ptr.restore();
            return null;
        }
        Token t1 = (Token)ptr.lookup(0);
        String id1 = t1.getId();
        if (!TemplateParser.in(id1, "blockEnd")) {
            ptr.restore();
            return null;
        }
        ptr.pop();
        ptr.move(1);
        return new Block(t0, body, t1);
    }

    protected class Mapping<K, V>
    extends LinkedHashMap<K, V> {
        protected Mapping() {
        }

        public Mapping<K, V> map(K k, V v) {
            this.put(k, v);
            return this;
        }
    }
}

