/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.iter.Eterable;
import xyz.cofe.text.template.FieldController;
import xyz.cofe.text.template.PropertyController;
import xyz.cofe.text.template.ValueController;

public class TypesUtil {
    public static final Predicates predicates = new Predicates();
    public static final Iterators iterators = new Iterators();
    private static NodesExtracter classMethodsExtracter = null;
    private static NodesExtracter methodParametersExtracter = null;
    public static final Class[] emptyParametersArray = new Class[0];

    public static boolean AinstanceOfB(Class cA, Class cB) {
        if (cA == null) {
            throw new IllegalArgumentException("cA == null");
        }
        if (cB == null) {
            throw new IllegalArgumentException("cB == null");
        }
        return cB.isAssignableFrom(cA);
    }

    public static boolean isCallableArguments(Class[] types, Object[] args) {
        if (types == null) {
            throw new IllegalArgumentException("types == null");
        }
        if (args == null) {
            throw new IllegalArgumentException("args == null");
        }
        if (types.length != args.length) {
            return false;
        }
        boolean callable = true;
        for (int paramIdx = 0; paramIdx < types.length; ++paramIdx) {
            Class cMethodPrm = types[paramIdx];
            if (args[paramIdx] == null) {
                if (!cMethodPrm.isPrimitive()) continue;
                callable = false;
                break;
            }
            Class<?> cArg = args[paramIdx].getClass();
            boolean assign = cMethodPrm.isAssignableFrom(cArg);
            if (assign) continue;
            callable = false;
            break;
        }
        return callable;
    }

    public static NodesExtracter classMethodsExtracter() {
        if (classMethodsExtracter != null) {
            return classMethodsExtracter;
        }
        classMethodsExtracter = new NodesExtracter(){

            public Iterable extract(Object from) {
                if (from == null) {
                    return null;
                }
                if (!(from instanceof Class)) {
                    return null;
                }
                return Iterators.methodsOf((Class)from);
            }
        };
        return null;
    }

    public static NodesExtracter methodParametersExtracter() {
        if (methodParametersExtracter != null) {
            return methodParametersExtracter;
        }
        methodParametersExtracter = new NodesExtracter(){

            public Iterable extract(Object from) {
                if (from == null) {
                    return null;
                }
                if (!(from instanceof Method)) {
                    return null;
                }
                return Iterators.paramtersOf((Method)from);
            }
        };
        return null;
    }

    public static class Predicates {
        public static Predicate<Method> hasEmptyParameters() {
            return Predicates.hasParameters(emptyParametersArray);
        }

        public static Predicate<Method> hasParameters(Class ... params) {
            if (params == null) {
                throw new IllegalArgumentException("params == null");
            }
            final Class[] _p = params;
            return new Predicate<Method>(){

                @Override
                public boolean test(Method value) {
                    Class<?>[] p = value.getParameterTypes();
                    if (p.length != _p.length) {
                        return false;
                    }
                    for (int i = 0; i < p.length; ++i) {
                        if (p[i].equals(_p[i])) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        public static Predicate<Class> classInstanceOf(Class target) {
            final Class fTarget = target;
            return new Predicate<Class>(){

                @Override
                public boolean test(Class value) {
                    if (fTarget == null) {
                        return value == null;
                    }
                    if (value == null) {
                        return false;
                    }
                    return TypesUtil.AinstanceOfB(value, fTarget);
                }
            };
        }

        public static Predicate<Class> classEquals(Class target) {
            final Class fTarget = target;
            return new Predicate<Class>(){

                @Override
                public boolean test(Class value) {
                    if (fTarget == null) {
                        return value == null;
                    }
                    return value == null ? false : fTarget.equals(value);
                }
            };
        }

        public static Predicate<Method> returns(Class type) {
            if (type == null) {
                throw new IllegalArgumentException("type == null");
            }
            final Class tip = type;
            return new Predicate<Method>(){

                @Override
                public boolean test(Method value) {
                    Class<?> ret = value.getReturnType();
                    return TypesUtil.AinstanceOfB(ret, tip);
                }
            };
        }

        public static Predicate<Method> nameStart(String text) {
            if (text == null) {
                throw new IllegalArgumentException("text == null");
            }
            final String txt = text;
            return new Predicate<Method>(){

                @Override
                public boolean test(Method value) {
                    return value.getName().startsWith(txt);
                }
            };
        }

        public static Predicate<Method> hasAnnotation(Class annClass) {
            if (annClass == null) {
                throw new IllegalArgumentException("annClass == null");
            }
            final Class ann = annClass;
            return new Predicate<Method>(){

                @Override
                public boolean test(Method value) {
                    Object a = value.getAnnotation(ann);
                    return a != null;
                }
            };
        }

        public static Predicate<Method> callableArguments(Object[] args) {
            if (args == null) {
                throw new IllegalArgumentException("args == null");
            }
            final Object[] fa = args;
            return new Predicate<Method>(){

                @Override
                public boolean test(Method value) {
                    Class[] types = value.getParameterTypes();
                    return TypesUtil.isCallableArguments(types, fa);
                }
            };
        }
    }

    public static class Iterators {
        public static <T> Iterable<T> sort(Iterable<T> src, Comparator<T> comparer) {
            if (src == null) {
                throw new IllegalArgumentException("src == null");
            }
            if (comparer == null) {
                throw new IllegalArgumentException("comparer == null");
            }
            List<T> list = Iterators.toList(src, ArrayList.class);
            Collections.sort(list, comparer);
            return list;
        }

        public static <T extends Comparable<? super T>> Iterable<T> sort(Iterable<T> src) {
            if (src == null) {
                throw new IllegalArgumentException("src == null");
            }
            List<T> list = Iterators.toList(src, ArrayList.class);
            Collections.sort(list);
            return list;
        }

        public static <T> T[] toArray(Iterable<? extends T> src, T[] array) {
            if (src == null) {
                throw new IllegalArgumentException("src == null");
            }
            if (array == null) {
                throw new IllegalArgumentException("array == null");
            }
            return Iterators.toArrayList(src).toArray(array);
        }

        public static <T> ArrayList<T> toArrayList(Iterable<? extends T> src) {
            return (ArrayList)Iterators.toList(src, ArrayList.class);
        }

        public static <T> List<T> toList(Iterable<? extends T> src, Class<? extends List> listClass) {
            if (src == null) {
                throw new IllegalArgumentException("src == null");
            }
            if (listClass == null) {
                throw new IllegalArgumentException("listClass == null");
            }
            try {
                List result = listClass.newInstance();
                for (T o : src) {
                    result.add(o);
                }
                return result;
            }
            catch (InstantiationException ex) {
                Logger.getLogger(TypesUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(TypesUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }

        public static <T> Iterable<T> classFilter(Eterable src, Class<T> c, boolean includeNull) {
            if (src == null) {
                throw new IllegalArgumentException("src == null");
            }
            if (c == null) {
                throw new IllegalArgumentException("c == null");
            }
            final boolean incNull = includeNull;
            final Class<T> need = c;
            Predicate p = new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    if (value == null && incNull) {
                        return true;
                    }
                    Class<?> c = value.getClass();
                    return need.equals(c);
                }
            };
            return src.filter(p);
        }

        public static <T> Iterable<T> isClassFilter(Eterable src, Class<T> c, boolean includeNull) {
            if (src == null) {
                throw new IllegalArgumentException("src == null");
            }
            if (c == null) {
                throw new IllegalArgumentException("c == null");
            }
            final boolean incNull = includeNull;
            final Class<T> need = c;
            Predicate p = new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    if (value == null) {
                        return incNull;
                    }
                    Class<?> c = value.getClass();
                    return need.isAssignableFrom(c);
                }
            };
            return src.filter(p);
        }

        public static Eterable<Class> paramtersOf(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method == null");
            }
            Object[] params = method.getParameterTypes();
            return Eterable.of((Object[])params);
        }

        public static Eterable<Method> methodsOf(Object src, Predicate<Method> predicate) {
            if (src == null) {
                throw new IllegalArgumentException("src == null");
            }
            if (predicate == null) {
                throw new IllegalArgumentException("predicate == null");
            }
            Class<?> c = src.getClass();
            return Eterable.of((Object[])c.getMethods()).filter(predicate);
        }

        public static Eterable<Method> methodsOf(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("obj == null");
            }
            return Eterable.of((Object[])obj.getClass().getMethods());
        }

        public static Eterable<Method> methodsOf(Class cls) {
            if (cls == null) {
                throw new IllegalArgumentException("cls == null");
            }
            return Eterable.of((Object[])cls.getMethods());
        }

        public static Eterable<Field> fieldsOf(Class cls) {
            if (cls == null) {
                throw new IllegalArgumentException("cls == null");
            }
            return Eterable.of((Object[])cls.getFields());
        }

        public static Eterable<ValueController> fieldsControllersOf(Class cls, Object owner) {
            if (cls == null) {
                throw new IllegalArgumentException("cls == null");
            }
            ArrayList<FieldController> _vc = new ArrayList<FieldController>();
            for (Field f : Iterators.fieldsOf(cls)) {
                FieldController fc = new FieldController(owner, f);
                _vc.add(fc);
            }
            return Eterable.of(_vc);
        }

        public static Eterable<Method> declaredMethodsOf(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("obj == null");
            }
            return Eterable.of((Object[])obj.getClass().getDeclaredMethods());
        }

        public static Eterable<ValueController> propertiesOf(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("object == null");
            }
            return PropertyController.buildControllers(object);
        }

        public static Eterable<? extends ValueController> propertiesOfClass(Class cls) {
            if (cls == null) {
                throw new IllegalArgumentException("object == null");
            }
            return PropertyController.buildPropertiesList(cls);
        }
    }
}

