/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.graph;

import xyz.cofe.collection.graph.Path.Direction;

/**
 * Путь в графе
 * @author gocha
 */
public abstract class AbstractPath<N,E> implements Path<N, E> {
    
    /* (non-Javadoc)
     * @see Path
     */
    @Override
    public Edge<N, E> getLastEdge() {
        int size = size();
        if( size<1 )return null;
        return get(size-1);
    }

    /* (non-Javadoc)
     * @see Path
     */
    @Override
    public N getLastNode() {
        Edge<N,E> e = getLastEdge();
        Direction d = getDirection();
        if( e==null )return null;
        return d==null ? e.getNodeB() : (d.equals(Direction.AB) ? e.getNodeB() : e.getNodeA());
    }

    /**
     * Описывает направление движения
     */
    protected Path.Direction direction = Path.Direction.AB;

    /**
     * Указывает направление движения
     * @param d Направление
     */
    public void setDirection(Path.Direction d){
        if (d== null) {
            throw new IllegalArgumentException("d==null");
        }
        this.direction = d;
    }

    /* (non-Javadoc)
     * @see Path
     */
    @Override
    public Direction getDirection() {
        return direction;
    }

    /* (non-Javadoc)
     * @see Path
     */
    @Override
    public boolean contains(N a, N b) {
        if (a== null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b== null) {
            throw new IllegalArgumentException("b==null");
        }
        for( Edge<N,E> e : this ){
            if( a.equals(e.getNodeA()) && b.equals(e.getNodeB()) )
                return true;
        }
        return false;
    }
}
