/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.iterators;

import java.util.Iterator;

/**
 * Итератор выдающий последовательность значений из итераторов
 * @author GoCha
 */
public class AddIterator<TValue> implements Iterator<TValue>
{
    private Iterable<Iterator<TValue>> src = null;
    private Iterator<Iterator<TValue>> srcitr = null;
    private boolean end = false;
    private TValue currentValue;
    private Iterator<TValue> currentSrc = null;

    public AddIterator(Iterable<Iterator<TValue>> src)
    {
        this.src = src;

        if (src == null)
        {
            end = true;
        }
        else
        {
            srcitr = this.src.iterator();
            find();
        }
    }

    private void find()
    {
        while (true)
        {
            if (currentSrc != null)
            {
                if (currentSrc.hasNext())
                {
                    currentValue = currentSrc.next();
                    break;
                }
                else
                {
                    if (!srcitr.hasNext())
                    {
                        end = true;
                        break;
                    }

                    currentSrc = srcitr.next();
                }
            }
            else
            {
                if (!srcitr.hasNext())
                {
                    end = true;
                    break;
                }

                currentSrc = srcitr.next();
            }
        }
    }

    public boolean hasNext()
    {
        return !end;
    }

    public TValue next()
    {
        if (end)
            return null;
        TValue res = currentValue;
        find();
        return res;
    }

    public void remove()
    {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
