/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.iterators;

import xyz.cofe.collection.Predicate;
import java.util.Iterator;


/**
 * Итератор по интератору с предикатом :)
 * @author GoCha
 */
public class PredicateIterator<T> implements Iterator<T>
{

    /**
     * Итератор
     */
    protected Iterator<T> iterator = null;
    /**
     * Предикат
     */
    protected Predicate<T> predicate = null;
    /**
     * Текущий элемент
     */
    protected T current = null;
    /**
     * Есть еще?
     */
    protected boolean hasNext = false;

    /**
     * Конструктор
     * @param predicate Предикат
     * @param iterator Итератор
     */
    public PredicateIterator(Predicate<T> predicate, Iterator<T> iterator)
    {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator == null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("predicate  == null");
        }

        this.iterator = iterator;
        this.predicate = predicate;

        findNext();
    }

    /**
     * Поиск следующего элемента
     */
    protected void findNext()
    {
        T obj = null;
        while (iterator.hasNext()) {
            obj = iterator.next();
            if (predicate.validate(obj)) {
                current = obj;
                hasNext = true;
                return;
            }
        }
        hasNext = false;
        current = null;
        return;
    }

    /**
     * Есть элементы?
     * @return Есть элементы?
     */
    public boolean hasNext()
    {
        return hasNext;
    }

    /**
     * Получить элемент и перейти к следующему
     * @return элемент
     */
    public T next()
    {
        if (!hasNext) {
            return null;
        }

        T result = current;
        findNext();
        return result;
    }

    /**
     * Удалить проччитанный из коллекции (Не поддерживаеться)
     */
    public void remove()
    {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
