/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.iterators;

import java.util.*;

/**
 * Создает последовательность неповторяющихся объектов
 * @author gocha
 * @param <T> Тип объектов
 */
public class SetIterator<T> implements Iterator<T>
{
	private List<T> list = null;
	private CompareEqu<T> cmp = null;
	private Iterator<T> src = null;
	private T current = null;
    
	public SetIterator(Iterator<T> src, CompareEqu<T> cmp, List<T> buffer)
	{
		if (buffer == null)
		{
			throw new IllegalArgumentException("buffer == null");
		}
		if (cmp == null)
		{
			throw new IllegalArgumentException("cmp == null");
		}
		if (src == null)
		{
			throw new IllegalArgumentException("src == null");
		}

		this.list = buffer;
		this.src = src;
		this.cmp = cmp;

		list.clear();

		current = findNext();
	}

	private T findNext()
	{
		while( src.hasNext() )
		{
			T v = src.next();
			if( v==null )continue;

			boolean duplicate = false;
			for( T history : list )
			{
				if( cmp.isEqu(history, v) )
				{
					duplicate = true;
					break;
				}
			}

			if( !duplicate )
			{
				list.add(v);
				return v;
			}
		}
		return null;
	}

	@Override
	public boolean hasNext()
	{
		return current != null;
	}

	@Override
	public T next()
	{
		T result = current;
		current = findNext();
		return result;
	}

	@Override
	public void remove()
	{
	}

    /**
     * Возвращает буффер
     * @return буффер
     */
    public List<T> getBuffert() {
        return list;
    }
}
