/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.iterators;

import java.util.Iterator;

/**
 * Вычитает из исходного множества объекты заданые вторым множством
 * @author gocha
 * @param <T> Тип объектов в множестве
 */
public class SubIterable<T> implements Iterable<T>
{
    private Iterable<T> src;
    private Iterable<T> sub;
    private CompareEqu<T> cmp;

	public SubIterable(Iterable<T> src,Iterable<T> sub)
	{
		if (src == null)
		{
			throw new IllegalArgumentException("src == null");
		}
		if (sub == null)
		{
			throw new IllegalArgumentException("sub == null");
		}
        
        this.src = src;
        this.sub = sub;

		CompareEqu<T> defCmp = new CompareEqu<T>()
		{
			@Override
			public boolean isEqu(T a, T b)
			{
				if( a==null && b==null )return true;
				if( a!=null && b==null )return false;
				if( a==null && b!=null )return false;

				return a.equals(b);
			}
		};
        
        this.cmp = defCmp;
	}

	public SubIterable(Iterable<T> src,Iterable<T> sub, CompareEqu<T> cmp)
	{
		if (src == null)
		{
			throw new IllegalArgumentException("src == null");
		}
		if (sub == null)
		{
			throw new IllegalArgumentException("sub == null");
		}
		if (cmp == null)
		{
			throw new IllegalArgumentException("cmp == null");
		}

        this.src = src;
        this.sub = sub;
        this.cmp = cmp;
	}

	@Override
	public Iterator<T> iterator()
	{
		return new SubIterator<T>(src,sub,cmp);
	}
}
