/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.iterators;

/**
 * Информация о обходе дерева - текущем узле/листе
 * @author gocha
 */
public interface TreeWalk<T>
{
    /**
     * Возвращает текущий узел/лист древа
     * @return Текущий узел/лист древа
     */
    T currentNode();

    /**
     * Возвращает родительский узел
     * @return Родительский узел (или null)
     */
    T parentNode();

    /**
     * Возвращает указатель на предществующий (родительский) узел древа
     * @return Родительский узел (или null)
     */
    TreeWalk<T> parent();

    /**
     * Возвращает путь от корня, до текущего узла, ввиде набора "шагов"
     * @return Путь от корня, до текущего узла
     */
    Iterable<TreeWalk<T>> walkPath();

    /**
     * Возвращает путь от корня, до текущего узла, ввиде набора "узлов"
     * @return Путь от корня, до текущего узла
     */
    Iterable<T> nodePath();

    /**
     * Возвращает корневой узел
     * @return Корневой узел (или null)
     */
    T startNode();

    /**
     * Начальный уровень
     * @return Начальный уровень
     */
    int startLevel();

    /**
     * Шаг между уровнями
     * @return Шаг
     */
    int stepLevel();

    /**
     * Возвращает текущий уровень
     * @return Текущий уровень
     */
    int currentLevel();
}
