/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.iterators;

/**
 * <p>Указывает тип обхода</p>
 * <b>Древо:</b>
 * <table border="1" cellspacing="0" summary="Структура дерева">
 * <tr>
 * <td colspan="8" align="center">(1) Корень</td>
 * </tr>
 * <tr>
 * <td colspan="4" align="center">(2) Узел</td>
 * <td colspan="4" align="center">(3) Узел</td>
 * </tr>
 * <tr>
 * <td colspan="2" align="center">(4) Узел</td>
 * <td colspan="2" align="center">(5) Узел</td>
 * <td colspan="2" align="center">(6) Узел</td>
 * <td colspan="2" align="center">(7) Узел</td>
 * </tr>
 * <tr>
 * <td>(8) Лист</td><td>(9) Лист</td><td>(10) Лист</td><td>(11) Лист</td>
 * <td>(12) Лист</td><td>(13) Лист</td><td>(14) Лист</td><td>(15) Лист</td>
 * </tr>
 * </table>
 *
 * <ul>
 * <li><b>ByLevel</b> - Обход по уровням сверху вниз. <br>
 * Последовательность обхода узлов/листов будет такая:
 * <b>(1), (2), (3), (4), (5), (6), (7), (8), (9), (10), (11), (12), (13), (14), (15)</b>
 * </li>
 *
 * <li>
 * <b>ByBranchForward</b> - Обход по ветвьям в прямой последовательности. <br>
 * Последовательность обхода узлов/листов будет такая:
 * <b>(1), (2), (4), (8), (9), (5), (10), (11), (3), (6), (12), (13), (7), (14), (15)</b>
 * </li>
 *
 * <li>
 * <b>ByBranchBackward</b> - Обход по ветвьям в обратной последовательности. <br>
 * Последовательность обхода узлов/листов будет такая:<br>
 * <b>(1), (3), (7), (15), (14), (6), (13), (12), (2), (5), (11), (10), (4), (9), (8)</b>
 * </li>
 * </ul>
 * @author gocha
 */
public enum TreeWalkType
{
    /**
     * Обход по уровням сверху вниз
     */
    ByLevel,

    /**
     * Обход по ветвьям в прямой последовательности
     */
    ByBranchForward,

    /**
     * Обход по ветвьям в обратной последовательности
     */
    ByBranchBackward
}
