/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.list;


import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Список с поддержкой блокировки
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class LockList<E> 
extends ListWrapper<E>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(LockList.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    protected final Lock lock;

    public LockList(List<E> wraplist) {
        super(wraplist);
        this.lock = new ReentrantLock();
    }

    public LockList(List<E> wraplist, Lock lock) {
        super(wraplist);
        this.lock = lock!=null ? lock : new ReentrantLock();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        try{
            lock.lock();
            return super.toArray(a);
        }
        finally{
            lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        try {
            lock.lock();
            return super.toArray();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        try {
            lock.lock();
            return super.subList(fromIndex, toIndex);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        try {
            lock.lock();
            return super.size();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E set(int index, E element) {
        try {
            lock.lock();
            return super.set(index, element);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        try {
            lock.lock();
            return super.retainAll(c);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        try {
            lock.lock();
            return super.removeAll(c);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E remove(int index) {
        try {
            lock.lock();
            return super.remove(index);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        try {
            lock.lock();
            return super.remove(o);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        try {
            lock.lock();
            return super.listIterator(index);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        try {
            lock.lock();
            return super.listIterator();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        try {
            lock.lock();
            return super.lastIndexOf(o);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        try {
            lock.lock();
            return super.iterator();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            lock.lock();
            return super.isEmpty();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        try {
            lock.lock();
            return super.indexOf(o);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E get(int index) {
        try {
            lock.lock();
            return super.get(index);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        try {
            lock.lock();
            return super.containsAll(c);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        try {
            lock.lock();
            return super.contains(o);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            lock.lock();
            super.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        try {
            lock.lock();
            return super.addAll(index, c);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        try {
            lock.lock();
            return super.addAll(c);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void add(int index, E element) {
        try {
            lock.lock();
            super.add(index, element);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        try {
            lock.lock();
            return super.add(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected synchronized void setWrappedList(List<E> list) {
        super.setWrappedList(list);
    }

    @Override
    public synchronized List<E> getWrappedList() {
        return super.getWrappedList();
    }
}
