/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.map;

import xyz.cofe.collection.RemovedPositionalItemEvent;

/**
 * Событие удаления данных из карты
 * @author gocha
 */
public class DeletedMapEvent<Key,Value> 
extends KeyValueMapEvent<Key,Value>
implements RemovedPositionalItemEvent<Value, EventMap<Key,Value>, Key>
{
    /**
     * Конструктор
     * @param source Источник сообщений (карта)
     * @param key Ключ
     * @param value Значение
     */
    public DeletedMapEvent(EventMap<Key,Value> source, Key key,Value value)
    {
        super(source,key,value);
        this.collection = source;
        this.removedItem = value;
        this.removedItemPosition = key;
    }

    /**
     * Конструктор копирования
     * @param source образец
     */
    public DeletedMapEvent(DeletedMapEvent<Key,Value> source){
        super(source);
        if( source!=null ){
            this.collection = source.collection;
            this.removedItem = source.removedItem;
            this.removedItemPosition = source.removedItemPosition;
        }
    }

    @Override
    public DeletedMapEvent<Key,Value> clone() {
        return new DeletedMapEvent<Key, Value>(this);
    }
    
    protected Key removedItemPosition;

    @Override
    public Key getRemovedItemPosition() {
        return removedItemPosition;
    }
    
    protected Value removedItem;

    @Override
    public Value getRemovedItem() {
        return removedItem;
    }
    
    protected EventMap<Key, Value> collection = null;

    @Override
    public EventMap<Key, Value> getCollection() {
        return collection;
    }
}
