/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.map;

import xyz.cofe.collection.AddedPositionalItemEvent;

/**
 * Событие добавления данных в карту
 * @author gocha
 * @param <Key> Тип ключа
 * @param <Value> Тип значения
 */
public class InsertedMapEvent<Key,Value> 
extends KeyValueMapEvent<Key,Value> 
implements AddedPositionalItemEvent<Value, EventMap<Key,Value>, Key>
{
    /**
     * Конструктор
     * @param source Источник
     * @param key Ключ
     * @param value Значение
     */
    public InsertedMapEvent(EventMap<Key,Value> source, Key key,Value value)
    {
        super(source,key,value);
        this.collection = source;
        this.position = key;
        this.addedItem = value;
    }
    
    /**
     * Конструктор копирования
     * @param source Образец для копирования
     */
    public InsertedMapEvent(InsertedMapEvent<Key,Value> source){
        super(source);
        if( source!=null ){
            this.collection = source.collection;
            this.position = source.position;
            this.addedItem = source.addedItem;
        }
    }

    @Override
    public InsertedMapEvent<Key,Value> clone() {
        return new InsertedMapEvent<Key, Value>(this);
    }
    
    protected Key position = null;

    @Override
    public Key getAddedItemPosition() {
        return position;
    }

    protected Value addedItem = null;
    
    @Override
    public Value getAddedItem() {
        return addedItem;
    }
    
    protected EventMap<Key, Value> collection = null;

    @Override
    public EventMap<Key, Value> getCollection() {
        return collection;
    }
}
