/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.set;

/**
 * Адаптер подписчика изменения множества
 * @author gocha
 * @param <E> Элемент множества
 */
public class EventSetAdapter<E> implements EventSetListener<E>
{
    /**
     * Изменения множества
     * @param args Сообщение
     */
    @Override
    public void eventSet(EventSetArgs<E> args)
    {
        if( args==null )return;
        if( args.getAction()==null )return;
        switch( args.getAction() )
        {
            case Inserted: inserted(args.getItem(),args.getSet()); break;
            case Deleted: deleted(args.getItem(),args.getSet()); break;
//            case Updated: updated(args.getItem(),args.getSet()); break;
            case Inserting: inserting(args); break;
            case Deleting: deleting(args); break;
        }
    }

    /**
     * Вызывается при добавлении элемента, можно отменить добавление элемента.
     * <br>
     * Вызывает inserting(E item, BasicEventSet&lt;E&gt; set), если он возвращает false, то элемент элемент не будет добавлен
     * @param args Аргументы события
     */
    protected void inserting(EventSetArgs<E> args)
    {
        if( args==null )return;
        args.setCancel(!inserting(args.getItem(), args.getSet()));
    }

    /**
     * Вызывается при добавлении элемента, можно отменить добавление элемента.
     * <br>
     * Вызывает inserting(E item), если он возвращает false, то элемент элемент не будет добавлен
     * @param item Добавляемый элемент (может быть null)
     * @param set Набор в который добавляется (может быть null)
     * @return true - добавлять, false - нет
     */
    protected boolean inserting(E item, EventSet<E> set)
    {
        return inserting(item);
    }

    /**
     * Вызывается при добавлении элемента, можно отменить добавление элемента.<br>
     * @param item Добавляемый элемент (может быть null)
     * @return true - добавлять, false - нет
     */
    protected boolean inserting(E item)
    {
        return true;
    }

    /**
     * Вызывается при удалении элемента, можно отменить удалении элемента. <br>
     * Вызывает deleting(E item, BasicEventSet&lt;E&gt; set), если он возвращает false, то элемент элемент не будет удален
     * @param args Аргументы события
     */
    protected void deleting(EventSetArgs<E> args)
    {
        if( args==null )return;
        args.setCancel(!deleting(args.getItem(), args.getSet()));
    }

    /**
     * Вызывается при удалении элемента, можно отменить удалении элемента.<br>
     * Вызывает deleting(E item), если он возвращает false, то элемент элемент не будет удален
     * @param item Удаляемый элемент (может быть null)
     * @param set Набор из которого удаляется (может быть null)
     * @return true - удалять, false - нет
     */
    protected boolean deleting(E item, EventSet<E> set)
    {
        return deleting(item);
    }

    /**
     * Вызывается при удалении элемента, можно отменить удалении элемента.
     * @param item Удаляемый элемент (может быть null)
     * @return true - удалять, false - нет
     */
    protected boolean deleting(E item)
    {
        return true;
    }

//    protected void updated(E item)
//    {
//    }
//    protected void updated(E item, EventSet<E> set)
//    {
//    }

    /**
     * Вызывается после добавления элемента в набора. <br>
     * Вызывает inserted(E item)
     * @param item Добавленный элемент (может быть null)
     * @param set Набор в который добавлен (может быть null)
     */
    protected void inserted(E item, EventSet<E> set)
    {
        inserted(item);
    }

    /**
     * Вызывается после добавления элемента в набора.
     * @param item Добавленный элемент (может быть null)
     */
    protected void inserted(E item)
    {
    }

    /**
     * Вызывается после удаление элемента из набора. <br>
     * Вызывает deleted(E item)
     * @param item Удаленный элемент (может быть null)
     * @param set Набор из которого удален (может быть null)
     */
    protected void deleted(E item, EventSet<E> set)
    {
        deleted(item);
    }

    /**
     * Вызывается после удаление элемента из набора.
     * @param item Удаленный элемент (может быть null)
     */
    protected void deleted(E item)
    {
    }
}
