/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.set;

/**
 * Сообщение измения множества
 * @author gocha
 */
public class EventSetArgs<E>
{
    /**
     * Конструктор
     * @param src Исходное множество
     * @param action Действие
     * @param item Элемент множества
     */
    public EventSetArgs(EventSet<E> src, EventSetAction action, E item)
    {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action == null");
        }
        if (item == null) {
            throw new IllegalArgumentException("item == null");
        }

        this.item = item;
        this.src = src;
        this.action = action;
    }
    
    public EventSetArgs(EventSetArgs<E> src){
        this( src.src, src.action, src.item );
        this.cancel = src.cancel;
    }

    protected E item;
    protected EventSet<E> src;
    protected EventSetAction action;

    /**
     * Возвращает действие
     * @return Действие
     */
    public EventSetAction getAction()
    {
        return action;
    }

    /**
     * Возвращает элемент множества
     * @return Элемент множества
     */
    public E getItem()
    {
        return item;
    }

    /**
     * Возвращает множество
     * @return Исходное множество
     */
    public EventSet<E> getSet()
    {
        return src;
    }

    protected boolean cancel = false;

    /**
     * Возвращает статус отмены операции
     * @return true - операция отменена, false - операция подтвержена (по умолчанию)
     */
    public boolean isCancel() {
        return cancel;
    }

    /**
     * Устанавливает статус отмены операции
     * @param cancel true - операция отменена, false - операция подтвержена (по умолчанию)
     */
    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }
}
