/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.set;

import java.io.Closeable;
import java.util.Collection;
import xyz.cofe.collection.Func3;
import xyz.cofe.common.Reciver;

/**
 * Интерфейс множества(набора..) с поддержкой уведомлений о измении
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 * @param <E> Тип объекта в коллекции
 */
public interface EventSetSender<E>
{
    /**
     * Добавляет подписчика изменений
     * @param listener Подписчик
     * @return Обработчик закрытия прослушивания сообщений
     */
    Closeable addEventSetListener(EventSetListener<E> listener);
    
    /**
     * Добавляет подписчика изменений
     * @param listener Подписчик
     * @param weak Добавить как weak ссылку
     * @return Обработчик закрытия прослушивания сообщений
     */
    Closeable addEventSetListener(EventSetListener<E> listener,boolean weak);

    /**
     * Удаляет подписчика изменений
     * @param listener Подписчик
     */
    void removeEventSetListener(EventSetListener<E> listener);

    /**
     * Проверяет что указанный подписчик прослушивает изменения
     * @param listener Подписчик
     * @return true - подписчик подписан на события
     */
    boolean containsEventSetListener(EventSetListener<E> listener);
    
    /**
     * Возвращает подписчиков на изменения
     * @return Подписчики
     */
    public Collection<EventSetListener<E>> getEventSetListeners();

    /**
     * Добавляет подписчика изменений добавления элемента
     * @param listener Подписчик
     * @return Обработчик закрытия прослушивания сообщений
     */
    public Closeable onAdded(final Reciver<E> listener);
    
    /**
     * Добавляет подписчика изменений удадения элемента
     * @param listener Подписчик
     * @return Обработчик закрытия прослушивания сообщений
     */
    public Closeable onRemoved(final Reciver<E> listener);
    
    /**
     * Добавляет подписчика на изменения
     * @param fn 
     * <span style='font-family:monospace'>
     * Функция(Key ключ, Value староеЗначение, Value новоеЗначение):Object
     * </span> 
     * <br>
     * <br>
     * 
     * Если <i>новоеЗначение</i> != null и <i>староеЗначение</i> != null - значение в карте обновленно.
     * <br>
     * <br>
     * 
     * Если <i>новоеЗначение</i> != null и <i>староеЗначение</i> == null - добавлено значение в карту.
     * <br>
     * <br>
     * 
     * Если <i>новоеЗначение</i> == null и <i>староеЗначение</i> != null - удалено значение из карты.
     * <br>
     * 
     * @param weak Добавить подписчика как weak ссылку
     * @return Обработчик закрытия/отписки от уведомлений
     */
    Closeable onChanged(final Func3<Object,? super E,? super E,? super E> fn,boolean weak);
    
    /**
     * Добавляет подписчика на изменения
     * @param fn 
     * <span style='font-family:monospace'>
     * Функция(Key ключ, Value староеЗначение, Value новоеЗначение):Object
     * </span> 
     * <br>
     * <br>
     * 
     * Если <i>новоеЗначение</i> != null и <i>староеЗначение</i> != null - значение в карте обновленно.
     * <br>
     * <br>
     * 
     * Если <i>новоеЗначение</i> != null и <i>староеЗначение</i> == null - добавлено значение в карту.
     * <br>
     * <br>
     * 
     * Если <i>новоеЗначение</i> == null и <i>староеЗначение</i> != null - удалено значение из карты.
     * <br>
     * 
     * @return Обработчик закрытия/отписки от уведомлений
     */
    Closeable onChanged(final Func3<Object,? super E,? super E,? super E> fn);
}
