/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.table;

/**
 * Адаптер обхода по таблице
 * @author Камнев Георгий Павлович
 * @param <Row> Тип строки таблицы
 * @param <Column> Тип колонки таблицы
 * @param <Item> Элемент таблицы
 */
public class CellWalkHandlerAdapter<Row, Column, Item> implements CellWalkHandler<Row, Column, Item>
{
    /**
     * Принимает элементы<br>
     * Вызывает другие методы accept
     * @param r Строка соответ. элементу
     * @param rowIdx Индекс строки
     * @param rowsCount Кол-во строк
     * @param c Колонка соответ. элементу
     * @param columnIdx Индекс колонки (от 0)
     * @param columnsCount Кол-во колонок
     * @param item Элемент
     */
    @Override
    public void accept(Row r, int rowIdx, int rowsCount, Column c, int columnIdx, int columnsCount, Item item)
    {
        accept(r, c, item, rowIdx == 0, rowIdx == rowsCount - 1, columnIdx == 0, columnIdx == columnsCount - 1);
    }

    /**
     * Принимает элементы
     * @param r Строка соответ. элементу
     * @param c Колонка соответ. элементу
     * @param i Элемент
     * @param startRow Первая строка в списке строк
     * @param endRow Последняя строка в списке строк
     * @param startColumn Первая колонка в списке строк
     * @param endColumn Последняя колонка в списке строк
     */
    public void accept(Row r, Column c, Item i, boolean startRow, boolean endRow, boolean startColumn, boolean endColumn)
    {
    }
}
