/*
 * The MIT License
 *
 * Copyright 2017 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.tree;


import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.common.Reciver;

/**
 * Узел древа с уведомлением о изменении структуры
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public abstract class PopupTreeNode<Node extends TreeNode>
    extends BasicTreeNode<Node>
    implements TreeNodeNotifier<Node>, TreeNodeAssignSelfParent<Node>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(PopupTreeNode.class.getName());

    private static Level logLevel(){ 
        return logger.getLevel() ;
    }
    
    private static boolean isLogSevere(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.SEVERE.intValue();
    }
    
    private static boolean isLogWarning(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.WARNING.intValue();
    }
    
    private static boolean isLogInfo(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.INFO.intValue();
    }
    
    private static boolean isLogFine(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.FINE.intValue();
    }
    
    private static boolean isLogFiner(){
        Level level = logLevel();
        return level==null 
        ? false
        : level.intValue() <= Level.FINER.intValue();
    }    
    
    private static boolean isLogFinest(){
        Level level = logLevel();
        return level==null 
        ? false
        : level.intValue() <= Level.FINEST.intValue();
    }    
    
    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    
    private static void logEntering(String method,Object ... params){
        logger.entering(PopupTreeNode.class.getName(),method,params);
    }

    private static void logExiting(String method,Object result){
        logger.exiting(PopupTreeNode.class.getName(),method,result);
    }

    private static void logExiting(String method){
        logger.exiting(PopupTreeNode.class.getName(),method);
    }
    //</editor-fold>
    
    /**
     * Передача события вверх по древу
     * @param ev Событие
     */
    @Override
    public void popup( final TreeNodeEvent<Node> ev ){
        syncrun( new Func0() {
            @Override
            public Object apply() {
            if( ev instanceof TreeNodePopupEvent ){
                TreeNodePopupEvent tnpe
                    = (TreeNodePopupEvent)ev;

                List l = tnpe.getPopupPath();

                // Проверка цикла
                if( l!=null ){
                    int cycles = 0;
                    for( Object o : l ){
                        if( this == o ){
                            // найден цикл
                            cycles++;
                        }
                    }
                    if( cycles>1 ){
                        throw new Error( "cycle detected" );
                        // return;
                    }
                }

                l.add(this);

                fireTreeNodeEvent(ev);

                Node pnode = getParent();
                if( pnode instanceof TreeNodeNotifier ){
                    ((TreeNodeNotifier)pnode).popup(ev);
                }
            }
            
            return null;
        }}, "popup", ev );
    }
    
    @Override
    public void onTreeNodeAdded(final Integer index,final Node child){
        syncrun( new Func0() {
            @Override
            public Object apply() {
         
            //super.onTreeNodeAdded(index, child);
            //TreeNodeAssignSelfParent.super.onTreeNodeAdded(index, child);            
            // Установка parent
            if( child instanceof TreeNodeSetParent ){
                TreeNodeSetParent<TreeNode> tn = (TreeNodeSetParent<TreeNode>)child;
                tn.setParent(PopupTreeNode.this);
            }
            
            //TreeNodeNotifier.super.onTreeNodeAdded(index, child);
            // Уведомление выше стоящих
            TreeNodeAdded<Node> ev = new TreeNodeAdded(PopupTreeNode.this,child,index);
            ev.getPopupPath().add(child);

            popup( ev );
            
            return null;
        }}, "onTreeNodeAdded", index, child );
    }
    
    @Override
    public void onTreeNodeAdding(final Integer index,final Node child){
        syncrun( new Func0() {
            @Override
            public Object apply() {
         
            //super.onTreeNodeAdding(index, child);
            
            //TreeNodeNotifier.super.onTreeNodeAdding(index, child);            
            // Уведомление выше стоящих
            TreeNodeAdding<Node> ev = new TreeNodeAdding(PopupTreeNode.this,child,index);
            ev.getPopupPath().add(child);
            popup( ev );
            
            return null;
        }}, "onTreeNodeAdding", index, child );
    }
    
    @Override
    public void onTreeNodeRemoved(final Integer index,final Node child){
        syncrun( new Func0() {
            @Override
            public Object apply() {
         
            //super.onTreeNodeRemoved(index, child);
            // Обновление parent
            if( child instanceof TreeNodeUpdateParent ){
                ((TreeNodeUpdateParent)child).updateParent(PopupTreeNode.this, null);
            }

            // TreeNodeNotifier.super.onTreeNodeRemoved(index, child);
            // Уведомление выше стоящих
            TreeNodeRemoved<Node> ev = new TreeNodeRemoved(PopupTreeNode.this,child,index);
            ev.getPopupPath().add(child);
            popup( ev );

            return null;
        }}, "onTreeNodeRemoved", index, child );
    }    
    
    @Override
    public void onTreeNodeRemoving(final Integer index,final Node child){
        syncrun( new Func0() {
            @Override
            public Object apply() {
         
            //super.onTreeNodeRemoving(index, child);
            
            // TreeNodeNotifier.super.onTreeNodeRemoving(index, child);
            // Уведомление выше стоящих
            TreeNodeRemoving<Node> ev = new TreeNodeRemoving(PopupTreeNode.this,child,index);
            ev.getPopupPath().add(child);
            popup( ev );

            return null;
            }}, "onTreeNodeRemoving", index, child );
    }
    
    @Override
    public Closeable addTreeNodeListener(TreeNodeListener<Node> lsr) {
        return TreeNodeListenersDef.addTreeNodeListener(this, lsr);
    }

    @Override
    public Closeable addTreeNodeListener(TreeNodeListener<Node> lsr, boolean weakLink) {
        return TreeNodeListenersDef.addTreeNodeListener(this, lsr, weakLink);
    }

    @Override
    public <EventType extends TreeNodeEvent<Node>> Closeable onTreeNodeEvent(Class<EventType> cls, boolean weakLink, Reciver<? super EventType> consumer) {
        return TreeNodeListenersDef.onTreeNodeEvent(this, cls, weakLink, consumer);
    }

    @Override
    public <EventType extends TreeNodeEvent<Node>> Closeable onTreeNodeEvent(Class<EventType> cls, Reciver<? super EventType> consumer) {
        return TreeNodeListenersDef.onTreeNodeEvent(this, cls, consumer);
    }

    @Override
    public void fireTreeNodeEvent(TreeNodeEvent<Node> ev) {
        TreeNodeListenersDef.fireTreeNodeEvent(this, ev);
    }

    @Override
    public boolean hasTreeNodeListener(TreeNodeListener<Node> lsr) {
        return TreeNodeListenersDef.hasTreeNodeListener(this,lsr);
    }

    @Override
    public void removeTreeNodeListener(TreeNodeListener<Node> lsr) {
        TreeNodeListenersDef.removeTreeNodeListener(this, (TreeNodeListener)lsr);
    }

    @Override
    public Set<TreeNodeListener> getTreeNodeListeners() {
        return TreeNodeListenersDef.getTreeNodeListeners(this);
    }

}
