/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.tree;

import java.util.Stack;
//import java.util.function.Consumer;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.iterators.TreeWalk;
import xyz.cofe.collection.iterators.TreeWalkType;
import static xyz.cofe.collection.tree.AbstractTreeNode.tree;
import xyz.cofe.common.Reciver;

/**
 * Интерфейс узла дерева
 * @author gocha
 */
public interface TreeNode<Node extends TreeNode>
{
	/**
	 * Возвращает родительский узел
	 * @return Узел
	 */
	public Node getParent();
	
	/**
	 * Возвращает дочерние узлы
	 * @return Дочерние узлы
	 */
	public Node[] getChildren();
	
	/**
	 * Возвращает собственный дочерний индекс
	 * @return Индекс или -1, если нет родительского элемента
	 */
	public int getIndex();
	
	/**
	 * Возвращает соседний узел
	 * @param offset Смещение от текущего
	 * @return Узел или null в случаи достижения края
	 */
    public Node getSibling(int offset);
    
	/* java 8
    public default Node getSibling(int offset){
        return (Node)AbstractTreeNode.getSibling(this, offset);
    }
    */
    
    /**
     * Возвращает следующий соседний узел
     * @return Узел или null в случаи достижения края
     */
    public Node getNextSibling();
    
    // java 8
    /* public default Node getNextSibling(){
        return (Node)AbstractTreeNode.getSibling(this, 1);
    }*/
    
    /**
     * Возвращает предыдущий соседний узел
     * @return Узел или null в случаи достижения края
     */
    public Node getPreviousSibling();
    
    // java 8
    /*public default Node getPreviousSibling(){
        return (Node)AbstractTreeNode.getSibling(this, -1);
    }*/
    
    /**
     * Возвращает итератор по узлам дерева
     * @return Обход дерева
     */
    public Iterable<? extends Node> walk();
    
    // java 8
    /*
    public default Iterable<Node> walk(){
        return AbstractTreeNode.<Node>walk(this);
    }
    */

    /**
     * Возвращает итератор по узлам дерева
     * @return Обход дерева
     */
    public Iterable<TreeWalk<Node>> tree();
    
    // java 8
    /*public default Iterable<TreeWalk<Node>> tree(){
        return AbstractTreeNode.<Node>tree(this, TreeWalkType.ByBranchForward);
    }*/
    
    // java 8
    /**
     * обход вершин древа
     * @param visiter постетитель
     */
    public void visit( Reciver<Stack<Node>> visiter );
    
    /*
    public default void visit( Reciver<Stack<Node>> visiter ){
        if( visiter==null )throw new IllegalArgumentException( "visiter==null" );

        AbstractTreeNode.<Node>visit(
            (st) -> { 
                visiter.accept(st);
                return true;
            }
            ,this);
    }
    */
    
    /**
     * обход вершин древа
     * @param visiterEnter функция посещения узла, если вернет true - то будет продолжен движение вглубь по дереву.
     * @param visiterExit функция выхода из узла.
     */
    public void visit( Func1<Boolean,Stack<Node>> visiterEnter, Func1<Object,Stack<Node>> visiterExit );
    
    // java 8
    /*
    public default void visit( Func1<Boolean,Stack<Node>> visiterEnter, Reciver<Stack<Node>> visiterExit ){
        if( visiterEnter==null )throw new IllegalArgumentException( "visiterEnter==null" );
        if( visiterExit==null )throw new IllegalArgumentException( "visiterExit==null" );

        AbstractTreeNode.<Node>visit(
            visiterEnter,
            (st) -> { 
                visiterExit.accept(st);
                return true;
            }
            ,this);
    }
    */

    /**
     * обход вершин древа
     * @param visiterEnter функция посещения узла
     * @param visiterExit функция выхода из узла
     */
    public void visit( Reciver<Stack<Node>> visiterEnter, Reciver<Stack<Node>> visiterExit );
    
    // java 8
    /*
    public default void visit( Reciver<Stack<Node>> visiterEnter, Reciver<Stack<Node>> visiterExit ){
        if( visiterEnter==null )throw new IllegalArgumentException( "visiterEnter==null" );
        if( visiterExit==null )throw new IllegalArgumentException( "visiterExit==null" );

        AbstractTreeNode.<Node>visit(
            (st) -> { 
                visiterEnter.accept(st);
                return true;
            },
            (st) -> { 
                visiterExit.accept(st);
                return true;
            }
            ,this);
    }
    */
}
