/*
 * The MIT License
 *
 * Copyright 2017 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.tree;

import java.io.Closeable;
import java.util.Set;
import xyz.cofe.common.Reciver;

/**
 * Подписчики на события TreeNodeEvent
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 * @param <Node> Тип узла
 */
public interface TreeNodeListeners<Node extends TreeNode> extends TreeNode<Node>
{
    /**
     * Добавление подписчика.
     * @param lsr Подписчик
     * @return Интерфес для отсоединения подписчика
     */
    public Closeable addTreeNodeListener( TreeNodeListener<Node> lsr );

    /**
     * Добавление подписчика.
     * @param lsr Подписчик
     * @param weakLink true - добавить как weak ссылку / false - как hard ссылку
     * @return Интерфес для отсоединения подписчика
     */
    public Closeable addTreeNodeListener( TreeNodeListener<Node> lsr, boolean weakLink );
    
    /**
     * Добавление подписчика на события древа
     * @param <EventType> тип события
     * @param cls тип события
     * @param weakLink true - добавить как weak ссылку / false - как hard ссылку
     * @param consumer приемник события (подписчик)
     * @return Интерфес для отсоединения подписчика
     */
    public <EventType extends TreeNodeEvent<Node>> Closeable onTreeNodeEvent( 
        Class<EventType> cls, 
        boolean weakLink, 
        final Reciver<? super EventType> consumer );
    
    /**
     * Добавление подписчика на события древа
     * @param <EventType> тип события
     * @param cls тип события
     * @param consumer приемник события (подписчик)
     * @return Интерфес для отсоединения подписчика
     */
    public <EventType extends TreeNodeEvent<Node>> Closeable 
    onTreeNodeEvent( Class<EventType> cls, Reciver<? super EventType> consumer );
    
    /**
     * Рассылка уведомления подписчикам
     * @param ev уведомление
     */
    public void fireTreeNodeEvent( TreeNodeEvent<Node> ev );

    /**
     * роверка наличия подписчика в списке обработки
     * @param lsr подписчик
     * @return есть в списке обработки
     */
    public boolean hasTreeNodeListener( TreeNodeListener<Node> lsr );

    /**
     * Удаление подписчика из списка обработки
     * @param lsr подписчик
     */
    public void removeTreeNodeListener( TreeNodeListener<Node> lsr );
    
    /**
     * Получение списка подписчиков
     * @return подписчики
     */
    public Set<TreeNodeListener> getTreeNodeListeners();
}
