/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Pointer<A> {
    protected List<A> elements = null;
    protected int index = 0;
    protected Stack<Integer> stack = new Stack();
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Pointer(Iterable<A> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens==null");
        }
        this.elements = new ArrayList<A>();
        for (A a : tokens) {
            this.elements.add(a);
        }
    }

    public Pointer(List<A> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens==null");
        }
        this.elements = tokens;
    }

    public A lookup(int offset) {
        int t = offset + this.index;
        if (t < 0 || t >= this.elements.size()) {
            return null;
        }
        return this.elements.get(t);
    }

    public List<A> getList() {
        return this.elements;
    }

    public Stack<Integer> getStack() {
        return this.stack;
    }

    public void move(int offset) {
        this.setIndex(this.index + offset);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(Integer idx) {
        if (idx == null) {
            return;
        }
        Integer old = this.index;
        this.index = idx;
        this.propertyChangeSupport.firePropertyChange("index", old, idx);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void push() {
        this.stack.push(this.getIndex());
    }

    public Integer pop() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.pop();
    }

    public Integer peek() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.peek();
    }

    public boolean restore() {
        Integer i = this.pop();
        if (i != null) {
            this.setIndex(i);
            return true;
        }
        return false;
    }
}

