/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection;

import java.math.BigInteger;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Predicate;

public class Predicates {
    public static <T> Predicate<T> isNotNull() {
        return new Predicate<T>(){

            @Override
            public boolean validate(T value) {
                return value != null;
            }
        };
    }

    public static <T> Predicate<T> isNull() {
        return new Predicate<T>(){

            @Override
            public boolean validate(T value) {
                return value == null;
            }
        };
    }

    public static <T> Predicate<T> in(Iterable src) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        final Iterable fsrc = src;
        return new Predicate<T>(){

            @Override
            public boolean validate(T value) {
                return Iterators.in(value, fsrc);
            }
        };
    }

    public static <T> Predicate<T> isEquals(Object value) {
        final Object fvalue = value;
        return new Predicate<T>(){

            @Override
            public boolean validate(T value) {
                if (fvalue == null && value == null) {
                    return true;
                }
                if (fvalue != null && value == null) {
                    return false;
                }
                if (fvalue == null && value != null) {
                    return false;
                }
                return fvalue.equals(value);
            }
        };
    }

    public static <T> Predicate<T> and(Predicate<T> ... a) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        final Predicate[] fa = a;
        return new Predicate<T>(){

            @Override
            public boolean validate(T value) {
                if (fa == null) {
                    return false;
                }
                int co = 0;
                for (Predicate p : fa) {
                    if (p == null) continue;
                    ++co;
                    if (p.validate(value)) continue;
                    return false;
                }
                return co > 0;
            }
        };
    }

    public static <T> Predicate<T> or(Predicate<T> ... a) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        final Predicate[] fa = a;
        return new Predicate<T>(){

            @Override
            public boolean validate(T value) {
                if (fa == null) {
                    return false;
                }
                for (Predicate p : fa) {
                    if (p == null || !p.validate(value)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> not(Predicate<T> a) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        final Predicate<T> fa = a;
        return new Predicate<T>(){

            @Override
            public boolean validate(T value) {
                return !fa.validate(value);
            }
        };
    }

    public static <T> Predicate<T> xor(Predicate<T> a, Predicate<T> b) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        final Predicate<T> fa = a;
        final Predicate<T> fb = b;
        return new Predicate<T>(){

            @Override
            public boolean validate(T value) {
                boolean vb;
                boolean va = fa.validate(value);
                return va != (vb = fb.validate(value));
            }
        };
    }

    public static Predicate<Number> moreOrEqualsThen(final Number compareValue) {
        return new Predicate<Number>(){

            @Override
            public boolean validate(Number value) {
                return !Predicates.lessThen(compareValue).validate(value);
            }
        };
    }

    public static Predicate<Number> lessOrEqualsThen(final Number compareValue) {
        return new Predicate<Number>(){

            @Override
            public boolean validate(Number value) {
                return !Predicates.moreThen(compareValue).validate(value);
            }
        };
    }

    public static Predicate<Number> moreThen(final Number compareValue) {
        return new Predicate<Number>(){

            @Override
            public boolean validate(Number value) {
                if (value == null || compareValue == null) {
                    return false;
                }
                if (value instanceof Byte) {
                    if (compareValue instanceof Byte) {
                        return value.byteValue() > compareValue.byteValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.shortValue() > compareValue.shortValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() > compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.byteValue() > compareValue.byteValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.byteValue() > compareValue.byteValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) > 0;
                    }
                } else if (value instanceof Short) {
                    if (compareValue instanceof Byte) {
                        return value.shortValue() > compareValue.shortValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.shortValue() > compareValue.shortValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() > compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.shortValue() > compareValue.shortValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.shortValue() > compareValue.shortValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) > 0;
                    }
                } else if (value instanceof Integer) {
                    if (compareValue instanceof Byte) {
                        return value.intValue() > compareValue.intValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.intValue() > compareValue.intValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() > compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.intValue() > compareValue.intValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.intValue() > compareValue.intValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) > 0;
                    }
                } else if (value instanceof Long) {
                    if (compareValue instanceof Byte) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.longValue() > compareValue.longValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) > 0;
                    }
                } else if (value instanceof Double) {
                    if (compareValue instanceof Byte) {
                        return value.doubleValue() > compareValue.doubleValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.doubleValue() > compareValue.doubleValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.doubleValue() > compareValue.doubleValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.doubleValue() > compareValue.doubleValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.doubleValue() > compareValue.doubleValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.doubleValue() > compareValue.doubleValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) > 0;
                    }
                } else if (value instanceof Float) {
                    if (compareValue instanceof Byte) {
                        return value.floatValue() > compareValue.floatValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.floatValue() > compareValue.floatValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.floatValue() > compareValue.floatValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.floatValue() > compareValue.floatValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.doubleValue() > compareValue.doubleValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.floatValue() > compareValue.floatValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) > 0;
                    }
                }
                return false;
            }
        };
    }

    public static Predicate<Number> lessThen(final Number compareValue) {
        return new Predicate<Number>(){

            @Override
            public boolean validate(Number value) {
                if (value == null || compareValue == null) {
                    return false;
                }
                if (value instanceof Byte) {
                    if (compareValue instanceof Byte) {
                        return value.byteValue() < compareValue.byteValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.shortValue() < compareValue.shortValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() < compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.byteValue() < compareValue.byteValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.byteValue() < compareValue.byteValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) < 0;
                    }
                } else if (value instanceof Short) {
                    if (compareValue instanceof Byte) {
                        return value.shortValue() < compareValue.shortValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.shortValue() < compareValue.shortValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() < compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.shortValue() < compareValue.shortValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.shortValue() < compareValue.shortValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) < 0;
                    }
                } else if (value instanceof Integer) {
                    if (compareValue instanceof Byte) {
                        return value.intValue() < compareValue.intValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.intValue() < compareValue.intValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() < compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.intValue() < compareValue.intValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.intValue() < compareValue.intValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) < 0;
                    }
                } else if (value instanceof Long) {
                    if (compareValue instanceof Byte) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.longValue() < compareValue.longValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) < 0;
                    }
                } else if (value instanceof Double) {
                    if (compareValue instanceof Byte) {
                        return value.doubleValue() < compareValue.doubleValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.doubleValue() < compareValue.doubleValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.doubleValue() < compareValue.doubleValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.doubleValue() < compareValue.doubleValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.doubleValue() < compareValue.doubleValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.doubleValue() < compareValue.doubleValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) < 0;
                    }
                } else if (value instanceof Float) {
                    if (compareValue instanceof Byte) {
                        return value.floatValue() < compareValue.floatValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.floatValue() < compareValue.floatValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.floatValue() < compareValue.floatValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.floatValue() < compareValue.floatValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.doubleValue() < compareValue.doubleValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.floatValue() < compareValue.floatValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) < 0;
                    }
                }
                return false;
            }
        };
    }

    public static Predicate<Number> notEquals(final Number compareValue) {
        return new Predicate<Number>(){

            @Override
            public boolean validate(Number value) {
                return !Predicates.equals(compareValue).validate(value);
            }
        };
    }

    public static Predicate<Number> equals(final Number compareValue) {
        return new Predicate<Number>(){

            @Override
            public boolean validate(Number value) {
                if (value == null || compareValue == null) {
                    return false;
                }
                if (value instanceof Byte) {
                    if (compareValue instanceof Byte) {
                        return value.byteValue() == compareValue.byteValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.shortValue() == compareValue.shortValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() == compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.byteValue() == compareValue.byteValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.byteValue() == compareValue.byteValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) == 0;
                    }
                } else if (value instanceof Short) {
                    if (compareValue instanceof Byte) {
                        return value.shortValue() == compareValue.shortValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.shortValue() == compareValue.shortValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() == compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.shortValue() == compareValue.shortValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.shortValue() == compareValue.shortValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) == 0;
                    }
                } else if (value instanceof Integer) {
                    if (compareValue instanceof Byte) {
                        return value.intValue() == compareValue.intValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.intValue() == compareValue.intValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.intValue() == compareValue.intValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.intValue() == compareValue.intValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.intValue() == compareValue.intValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) == 0;
                    }
                } else if (value instanceof Long) {
                    if (compareValue instanceof Byte) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.longValue() == compareValue.longValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) == 0;
                    }
                } else if (value instanceof Double) {
                    if (compareValue instanceof Byte) {
                        return value.doubleValue() == compareValue.doubleValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.doubleValue() == compareValue.doubleValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.doubleValue() == compareValue.doubleValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.doubleValue() == compareValue.doubleValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.doubleValue() == compareValue.doubleValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.doubleValue() == compareValue.doubleValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) == 0;
                    }
                } else if (value instanceof Float) {
                    if (compareValue instanceof Byte) {
                        return value.floatValue() == compareValue.floatValue();
                    }
                    if (compareValue instanceof Short) {
                        return value.floatValue() == compareValue.floatValue();
                    }
                    if (compareValue instanceof Integer) {
                        return value.floatValue() == compareValue.floatValue();
                    }
                    if (compareValue instanceof Long) {
                        return value.floatValue() == compareValue.floatValue();
                    }
                    if (compareValue instanceof Double) {
                        return value.doubleValue() == compareValue.doubleValue();
                    }
                    if (compareValue instanceof Float) {
                        return value.floatValue() == compareValue.floatValue();
                    }
                    if (compareValue instanceof BigInteger) {
                        return BigInteger.valueOf(value.longValue()).compareTo((BigInteger)compareValue) == 0;
                    }
                }
                return false;
            }
        };
    }
}

