/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.graph.DefaultGraphFactory;
import xyz.cofe.collection.graph.Edge;
import xyz.cofe.collection.graph.SingleDirectedGraph;

public class MappedSDGraph<N, E>
implements SingleDirectedGraph<N, E> {
    protected Map<N, Map<N, E>> data = null;

    protected Map<N, E> createN2EMap() {
        return new TreeMap();
    }

    protected Map<N, Map<N, E>> createN2NEMap() {
        return new TreeMap();
    }

    protected Edge<N, E> createEdge(N a, N b, E e) {
        DefaultGraphFactory.MutableEdge<N, E> p = new DefaultGraphFactory.MutableEdge<N, E>();
        p.setEdge(e);
        p.setNodeA(a);
        p.setNodeB(b);
        return p;
    }

    protected Map<N, Map<N, E>> getData() {
        if (this.data != null) {
            return this.data;
        }
        this.data = this.createN2NEMap();
        return this.data;
    }

    protected Collection<Edge<N, E>> createEdgePairs() {
        return new ArrayList<Edge<N, E>>();
    }

    protected boolean equals(N a, N b) {
        return a.equals(b);
    }

    protected Collection<E> createEdges() {
        return new HashSet();
    }

    @Override
    public boolean contains(N node) {
        return this.getData().containsKey(node);
    }

    @Override
    public void add(N node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (!this.contains(node)) {
            this.getData().put(node, this.createN2EMap());
        }
    }

    @Override
    public void remove(N node) {
        if (node == null) {
            return;
        }
        if (this.getData().containsKey(node)) {
            for (Map.Entry<N, Map<N, E>> e : this.getData().entrySet()) {
                e.getValue().remove(node);
            }
            this.getData().remove(node);
        }
    }

    @Override
    public Iterable<N> getNodes() {
        return this.getData().keySet();
    }

    @Override
    public Iterable<Edge<N, E>> getEdges() {
        Collection<Edge<N, Edge<N, E>>> result = this.createEdgePairs();
        for (Map.Entry<N, Map<N, E>> e : this.getData().entrySet()) {
            for (Map.Entry<N, E> e2 : e.getValue().entrySet()) {
                result.add(this.createEdge(e.getKey(), e2.getKey(), e2.getValue()));
            }
        }
        return result;
    }

    @Override
    public Iterable<Edge<N, E>> edgesOf(N node) {
        Collection<Edge<N, Edge<N, E>>> result = this.createEdgePairs();
        for (Map.Entry<N, Map<N, E>> _e : this.getData().entrySet()) {
            Map<N, E> ma = _e.getValue();
            E e = ma.get(node);
            if (e == null) continue;
            result.add(this.createEdge(_e.getKey(), node, e));
        }
        Map<N, E> ma = this.getData().get(node);
        for (Map.Entry<N, E> _e : ma.entrySet()) {
            result.add(this.createEdge(node, _e.getKey(), _e.getValue()));
        }
        return result;
    }

    @Override
    public Iterable<Edge<N, E>> edgesOfNodeA(N nodeA) {
        if (nodeA == null) {
            return Iterators.empty();
        }
        Map<N, E> ma = this.getData().get(nodeA);
        if (ma == null) {
            return Iterators.empty();
        }
        Collection<Edge<N, Edge<N, E>>> result = this.createEdgePairs();
        for (Map.Entry<N, E> e2 : ma.entrySet()) {
            result.add(this.createEdge(nodeA, e2.getKey(), e2.getValue()));
        }
        return result;
    }

    @Override
    public Iterable<Edge<N, E>> edgesOfNodeB(N nodeB) {
        if (nodeB == null) {
            return Iterators.empty();
        }
        Collection<Edge<N, Edge<N, E>>> result = this.createEdgePairs();
        for (Map.Entry<N, Map<N, E>> _e : this.getData().entrySet()) {
            Map<N, E> mb = _e.getValue();
            E e = mb.get(nodeB);
            if (e == null) continue;
            Edge<N, E> ep = this.createEdge(_e.getKey(), nodeB, e);
            result.add(ep);
        }
        return result;
    }

    @Override
    public void clearEdges() {
        for (Map.Entry<N, Map<N, E>> e : this.getData().entrySet()) {
            e.getValue().clear();
        }
    }

    @Override
    public void clearAll() {
        for (Map.Entry<N, Map<N, E>> e : this.getData().entrySet()) {
            e.getValue().clear();
        }
        this.getData().clear();
    }

    @Override
    public boolean hasEdge(N a, N b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        Map<N, E> ma = this.getData().get(a);
        return ma == null ? false : ma.containsKey(b);
    }

    @Override
    public void removeEdge(N a, N b) {
        if (a == null) {
            return;
        }
        if (b == null) {
            return;
        }
        Map<N, E> ma = this.getData().get(a);
        if (ma == null) {
            return;
        }
        ma.remove(b);
    }

    @Override
    public E getEdge(N a, N b) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            return null;
        }
        Map<N, E> ma = this.getData().get(a);
        if (ma == null) {
            return null;
        }
        return ma.get(b);
    }

    @Override
    public void setEdge(N a, N b, E edge) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        if (!this.contains(a)) {
            this.add(a);
        }
        if (!this.contains(b)) {
            this.add(b);
        }
        Map<N, E> ma = this.getData().get(a);
        if (edge == null) {
            if (ma != null) {
                ma.remove(b);
            }
        } else if (ma != null) {
            ma.put(b, edge);
        }
    }

    @Override
    public Iterable<E> getEdges(N a, N b) {
        if (a == null || b == null) {
            return Iterators.empty();
        }
        Map<N, E> ma = this.getData().get(a);
        if (ma == null) {
            return Iterators.empty();
        }
        E e = ma.get(b);
        if (e == null) {
            Iterators.empty();
        }
        Collection<E> c = this.createEdges();
        c.add(e);
        return c;
    }

    @Override
    public void setEdges(N a, N b, Iterable<E> edges) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        if (edges == null) {
            this.setEdge(a, b, null);
        } else {
            Iterable<E> _e;
            long c;
            if (!this.contains(a)) {
                this.add(a);
            }
            if (!this.contains(b)) {
                this.add(b);
            }
            if ((c = Iterators.count(_e = Iterators.notNullFilter(edges))) == 0L) {
                Map<N, E> ma = this.getData().get(a);
                ma.remove(b);
            } else {
                Map<N, E> ma = this.getData().get(a);
                int i = -1;
                for (E e : _e) {
                    ma.put(b, e);
                    if (++i < 0) continue;
                    break;
                }
            }
        }
    }

    @Override
    public E get(N a, N b) {
        return this.getEdge(a, b);
    }

    @Override
    public void set(N a, N b, E e) {
        this.setEdge(a, b, e);
    }
}

