/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.graph.BasicPath;
import xyz.cofe.collection.graph.Edge;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.collection.graph.SingleDirectedGraph;

public class PathFinder<N, E>
implements Iterator<Path<N, E>> {
    protected SingleDirectedGraph<N, E> graph = null;
    protected Path.Direction direction = null;
    protected List<Path<N, E>> paths = null;
    protected Comparator<Path<N, E>> comparator = null;
    protected Iterator<Path<N, E>> pathItr = null;
    protected Predicate<Edge<N, E>> validator = null;

    public PathFinder(SingleDirectedGraph<N, E> graph, N start, Path.Direction direction, Convertor<Edge<N, E>, Double> getWeight) {
        if (getWeight == null) {
            throw new IllegalArgumentException("getWeight==null");
        }
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        if (direction == null) {
            throw new IllegalArgumentException("direction==null");
        }
        if (graph == null) {
            throw new IllegalArgumentException("graph==null");
        }
        this.graph = graph;
        this.direction = direction;
        this.paths = this.createPathsList();
        this.comparator = this.createComparatorFrom(getWeight);
        this.validator = this.createValidtor();
        Iterable<Edge<N, E>> next = this.getNextEdges(start);
        for (Edge<N, E> e : next) {
            Path<N, Edge<N, E>> bp = this.createPath(direction);
            bp.add(e);
            this.paths.add(bp);
        }
        Collections.sort(this.paths, this.comparator);
        this.pathItr = this.paths.iterator();
    }

    protected double getIntWeightOf(Path<N, E> path, Convertor<Edge<N, E>, Double> getWeight) {
        double w = 0.0;
        for (Edge edge : path) {
            double we = getWeight.convert(edge);
            w += we;
        }
        return w;
    }

    protected Comparator<Path<N, E>> createComparatorFrom(Convertor<Edge<N, E>, Double> getWeight) {
        final Convertor<Edge<N, E>, Double> fgetWeight = getWeight;
        return new Comparator<Path<N, E>>(){

            @Override
            public int compare(Path<N, E> p1, Path<N, E> p2) {
                double w2;
                double w1 = PathFinder.this.getIntWeightOf(p1, fgetWeight);
                return w1 == (w2 = PathFinder.this.getIntWeightOf(p1, fgetWeight)) ? 0 : (w1 < w2 ? -1 : 1);
            }
        };
    }

    public PathFinder(SingleDirectedGraph<N, E> graph, N start, Path.Direction direction, Comparator<Path<N, E>> comparator) {
        if (graph == null) {
            throw new IllegalArgumentException("graph==null");
        }
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        if (direction == null) {
            throw new IllegalArgumentException("direction==null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator==null");
        }
        this.graph = graph;
        this.direction = direction;
        this.paths = this.createPathsList();
        this.comparator = comparator;
        this.validator = this.createValidtor();
        Iterable<Edge<N, E>> next = this.getNextEdges(start);
        for (Edge<N, E> e : next) {
            Path<N, Edge<N, E>> bp = this.createPath(direction);
            bp.add(e);
            this.paths.add(bp);
        }
        Collections.sort(this.paths, comparator);
        this.pathItr = this.paths.iterator();
    }

    protected List<Path<N, E>> createPathsList() {
        return new ArrayList<Path<N, E>>();
    }

    protected Path<N, E> createPath(Path.Direction d) {
        BasicPath p = new BasicPath();
        p.setDirection(d);
        return p;
    }

    protected Path<N, E> append(Path<N, E> path, Edge<N, E> e) {
        BasicPath<N, E> npath = new BasicPath<N, E>();
        npath.addAll(path);
        npath.add(e);
        return npath;
    }

    protected Predicate<Edge<N, E>> createValidtor() {
        Predicate p = new Predicate<Edge<N, E>>(){

            @Override
            public boolean validate(Edge<N, E> value) {
                if (PathFinder.this.paths == null) {
                    return false;
                }
                for (Path p : PathFinder.this.paths) {
                    if (!p.contains(value.getNodeA(), value.getNodeB())) continue;
                    return false;
                }
                return true;
            }
        };
        return p;
    }

    protected Iterable<Edge<N, E>> getNextEdges(N n) {
        Iterable itr;
        Iterable iterable = itr = this.direction.equals((Object)Path.Direction.AB) ? this.graph.edgesOfNodeA(n) : this.graph.edgesOfNodeB(n);
        if (this.validator != null) {
            itr = Iterators.predicate(itr, this.validator);
        }
        return itr;
    }

    protected void searchAgain() {
        if (this.paths.size() < 1) {
            this.pathItr = null;
            return;
        }
        Path<N, E> smallPath = this.paths.get(0);
        Iterable<Edge<N, E>> next = this.getNextEdges(smallPath.getLastNode());
        for (Edge<N, E> e : next) {
            this.paths.add(this.append(smallPath, e));
        }
        this.paths.remove(0);
        Collections.sort(this.paths, this.comparator);
        this.pathItr = this.paths.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.pathItr == null) {
            return false;
        }
        boolean res = this.pathItr.hasNext();
        if (!res) {
            this.searchAgain();
        }
        return res;
    }

    @Override
    public Path<N, E> next() {
        if (this.pathItr == null) {
            return null;
        }
        Path<N, E> p = this.pathItr.next();
        if (!this.pathItr.hasNext()) {
            this.searchAgain();
        }
        return p;
    }

    @Override
    public void remove() {
    }
}

