/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.Iterator;
import xyz.cofe.collection.iterators.SingleIterator;
import xyz.cofe.common.LazyValue;

public class SingleIterable<T>
implements Iterable<T> {
    private T item = null;
    private LazyValue<T> lazyValue = null;

    public SingleIterable(T item) {
        this.item = item;
    }

    public SingleIterable(LazyValue<T> item) {
        this.lazyValue = item;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.lazyValue != null) {
            return new Iterator<T>(){
                boolean readed = false;

                @Override
                public boolean hasNext() {
                    return !this.readed;
                }

                @Override
                public T next() {
                    if (!this.readed) {
                        this.readed = true;
                        return SingleIterable.this.lazyValue.evaluate();
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return new SingleIterator<T>(this.item);
    }
}

