/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.Iterator;
import xyz.cofe.collection.iterators.CompareEqu;
import xyz.cofe.collection.iterators.SubIterator;

public class SubIterable<T>
implements Iterable<T> {
    private Iterable<T> src;
    private Iterable<T> sub;
    private CompareEqu<T> cmp;

    public SubIterable(Iterable<T> src, Iterable<T> sub) {
        CompareEqu defCmp;
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (sub == null) {
            throw new IllegalArgumentException("sub == null");
        }
        this.src = src;
        this.sub = sub;
        this.cmp = defCmp = new CompareEqu<T>(){

            @Override
            public boolean isEqu(T a, T b) {
                if (a == null && b == null) {
                    return true;
                }
                if (a != null && b == null) {
                    return false;
                }
                if (a == null && b != null) {
                    return false;
                }
                return a.equals(b);
            }
        };
    }

    public SubIterable(Iterable<T> src, Iterable<T> sub, CompareEqu<T> cmp) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (sub == null) {
            throw new IllegalArgumentException("sub == null");
        }
        if (cmp == null) {
            throw new IllegalArgumentException("cmp == null");
        }
        this.src = src;
        this.sub = sub;
        this.cmp = cmp;
    }

    @Override
    public Iterator<T> iterator() {
        return new SubIterator<T>(this.src, this.sub, this.cmp);
    }
}

