/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.list;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.LockMethod;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.list.AddedEvent;
import xyz.cofe.collection.list.AddedPositionalEvent;
import xyz.cofe.collection.list.AddingEvent;
import xyz.cofe.collection.list.AddingPositionalEvent;
import xyz.cofe.collection.list.BasicEventListIterator;
import xyz.cofe.collection.list.BasicIterator;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.ListWrapper;
import xyz.cofe.collection.list.RemovedEvent;
import xyz.cofe.collection.list.RemovedPositionalEvent;
import xyz.cofe.collection.list.RemovingEvent;
import xyz.cofe.collection.list.RemovingPositionalEvent;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.collection.list.SubList;
import xyz.cofe.collection.list.UpdatedPositionalEvent;
import xyz.cofe.collection.list.UpdatingPositionalEvent;
import xyz.cofe.common.GetListenersHelper;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;

public class BasicEventList<E>
extends ListWrapper<E>
implements EventList<E>,
GetListenersHelper {
    private static final Logger logger = Logger.getLogger(BasicEventList.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Queue<Object> eventQueue = new LinkedList<Object>();
    protected final ListenersHelper<EventListListener, Object> listeners = new ListenersHelper<EventListListener, Object>(new Func2<Object, EventListListener, Object>(){

        @Override
        public Object apply(EventListListener l, Object e) {
            if (l != null) {
                l.listItemsChanged(e);
            }
            return null;
        }
    });

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    public BasicEventList() {
        this(new ArrayList());
    }

    public BasicEventList(List<E> list) {
        super(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToQueue(Object event) {
        Queue<Object> queue = this.eventQueue;
        synchronized (queue) {
            this.addEventToQueue0(event);
        }
    }

    private void addEventToQueue0(Object event) {
        if (event != null) {
            this.eventQueue.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireQueueEvents() {
        Queue<Object> queue = this.eventQueue;
        synchronized (queue) {
            this.fireQueueEvents0();
        }
    }

    protected void fireQueueEvents0() {
        Object event;
        while ((event = this.eventQueue.poll()) != null) {
            this.listeners.fireEvent(event);
        }
    }

    @Override
    public ListenersHelper getListenersHelper() {
        return this.listeners;
    }

    @Override
    public Closeable addEventListListener(EventListListener<E> listener) {
        return this.listeners.addListener(listener);
    }

    @Override
    public Closeable addEventListListener(EventListListener<E> listener, boolean weak) {
        return this.listeners.addListener(listener, weak);
    }

    @Override
    public void removeEventListListener(EventListListener<E> listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public boolean containsEventListListener(EventListListener<E> listener) {
        return this.listeners.hasListener(listener);
    }

    protected void fireEventListMessage(Object evnt) {
        this.listeners.fireEvent(evnt);
    }

    @Override
    public Closeable onAdding(final Reciver<E> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        return this.addEventListListener(new SimpleListAdapter<E>(){

            @Override
            protected void adding(E e, EventList<E> list, Integer position) {
                if (listener != null) {
                    listener.recive(e);
                }
            }
        });
    }

    @Override
    public Closeable onAdded(final Reciver<E> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        return this.addEventListListener(new SimpleListAdapter<E>(){

            @Override
            protected void added(E e, EventList<E> list, Integer position) {
                if (listener != null) {
                    listener.recive(e);
                }
            }
        });
    }

    @Override
    public Closeable onRemoving(final Reciver<E> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        return this.addEventListListener(new SimpleListAdapter<E>(){

            @Override
            protected void removing(E e, EventList<E> list, Integer position) {
                if (listener != null) {
                    listener.recive(e);
                }
            }
        });
    }

    @Override
    public Closeable onRemoved(final Reciver<E> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        return this.addEventListListener(new SimpleListAdapter<E>(){

            @Override
            protected void removed(E e, EventList<E> list, Integer position) {
                if (listener != null) {
                    listener.recive(e);
                }
            }
        });
    }

    @Override
    public Closeable onChanged(final Func3<Object, Integer, E, E> fn, boolean weak) {
        return this.addEventListListener(new EventListListener<E>(){

            @Override
            public void listItemsChanged(Object evnt) {
                if (evnt instanceof UpdatedPositionalEvent) {
                    Integer pAdded;
                    UpdatedPositionalEvent updateEv = (UpdatedPositionalEvent)evnt;
                    Integer pRemove = updateEv.getRemovedItemPosition();
                    if (!BasicEventList.eq(pRemove, pAdded = updateEv.getAddedItemPosition())) {
                        BasicEventList.logWarning("update position event - removed pos({0}) != added pos({1})", new Object[]{pRemove, pAdded});
                    }
                    Object added = updateEv.getAddedItem();
                    Object removed = updateEv.getRemovedItem();
                    if (fn != null) {
                        fn.apply(pAdded, removed, added);
                    }
                } else if (evnt instanceof AddedPositionalEvent) {
                    AddedPositionalEvent ev = (AddedPositionalEvent)evnt;
                    Integer pos = ev.getAddedItemPosition();
                    if (pos == null) {
                        BasicEventList.logWarning("added position event - added item pos({0}) is null", new Object[]{pos});
                    }
                    Object eadded = ev.getAddedItem();
                    if (fn != null) {
                        fn.apply(pos, null, eadded);
                    }
                } else if (evnt instanceof AddedEvent) {
                    AddedEvent ev = (AddedEvent)evnt;
                    Object eadded = ev.getAddedItem();
                    if (fn != null) {
                        fn.apply(null, null, eadded);
                    }
                } else if (evnt instanceof RemovedPositionalEvent) {
                    RemovedPositionalEvent ev = (RemovedPositionalEvent)evnt;
                    Integer pos = ev.getRemovedItemPosition();
                    if (pos == null) {
                        BasicEventList.logWarning("removed position event - removed item pos({0}) is null", new Object[]{pos});
                    }
                    Object edeleted = ev.getRemovedItem();
                    if (fn != null) {
                        fn.apply(pos, edeleted, null);
                    }
                } else if (evnt instanceof RemovedEvent) {
                    RemovedEvent ev = (RemovedEvent)evnt;
                    Object edeleted = ev.getRemovedItem();
                    if (fn != null) {
                        fn.apply(null, edeleted, null);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onChanged(Func3<Object, Integer, E, E> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onChanged(fn, false);
    }

    @Override
    public Closeable onChanging(final Func3<Object, Integer, E, E> fn, boolean weak) {
        return this.addEventListListener(new EventListListener<E>(){

            @Override
            public void listItemsChanged(Object evnt) {
                if (evnt instanceof UpdatingPositionalEvent) {
                    Integer pos;
                    UpdatingPositionalEvent updateEv = (UpdatingPositionalEvent)evnt;
                    Integer pRemove = updateEv.getRemovingItemPosition();
                    if (!BasicEventList.eq(pRemove, pos = updateEv.getAddingItemPosition())) {
                        BasicEventList.logWarning("updating position event - removing pos({0}) != added pos({1})", new Object[]{pRemove, pos});
                    }
                    Object adding = updateEv.getAddingItem();
                    Object removing = updateEv.getRemovingItem();
                    if (fn != null) {
                        fn.apply(pos, removing, adding);
                    }
                } else if (evnt instanceof AddingPositionalEvent) {
                    AddingPositionalEvent ev = (AddingPositionalEvent)evnt;
                    Integer pos = ev.getAddingItemPosition();
                    if (pos == null) {
                        BasicEventList.logWarning("adding position event - adding item pos({0}) is null", new Object[]{pos});
                    }
                    Object eadding = ev.getAddingItem();
                    if (fn != null) {
                        fn.apply(pos, null, eadding);
                    }
                } else if (evnt instanceof AddingEvent) {
                    AddingEvent ev = (AddingEvent)evnt;
                    Object eadding = ev.getAddingItem();
                    if (fn != null) {
                        fn.apply(null, null, eadding);
                    }
                } else if (evnt instanceof RemovingPositionalEvent) {
                    RemovingPositionalEvent ev = (RemovingPositionalEvent)evnt;
                    Integer pos = ev.getRemovingItemPosition();
                    if (pos == null) {
                        BasicEventList.logWarning("removing position event - removing item pos({0}) is null", new Object[]{pos});
                    }
                    Object edeleting = ev.getRemovingItem();
                    if (fn != null) {
                        fn.apply(pos, edeleting, null);
                    }
                } else if (evnt instanceof RemovingEvent) {
                    RemovingEvent ev = (RemovingEvent)evnt;
                    Object edeleting = ev.getRemovingItem();
                    if (fn != null) {
                        fn.apply(null, edeleting, null);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onChanging(Func3<Object, Integer, E, E> fn) {
        return this.onChanging(fn, false);
    }

    @Override
    public Closeable onUpdated(final Func3<Object, Integer, E, E> fn, boolean weak) {
        return this.addEventListListener(new EventListListener<E>(){

            @Override
            public void listItemsChanged(Object evnt) {
                if (evnt instanceof UpdatedPositionalEvent) {
                    Integer pAdded;
                    UpdatedPositionalEvent updateEv = (UpdatedPositionalEvent)evnt;
                    Integer pRemove = updateEv.getRemovedItemPosition();
                    if (!BasicEventList.eq(pRemove, pAdded = updateEv.getAddedItemPosition())) {
                        BasicEventList.logWarning("update position event - removed pos({0}) != added pos({1})", new Object[]{pRemove, pAdded});
                    }
                    Object added = updateEv.getAddedItem();
                    Object removed = updateEv.getRemovedItem();
                    if (fn != null) {
                        fn.apply(pAdded, removed, added);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onUpdated(Func3<Object, Integer, E, E> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onUpdated(fn, false);
    }

    @Override
    public Closeable onUpdating(final Func3<Object, Integer, E, E> fn, boolean weak) {
        return this.addEventListListener(new EventListListener<E>(){

            @Override
            public void listItemsChanged(Object evnt) {
                if (evnt instanceof UpdatingPositionalEvent) {
                    Integer pAdded;
                    UpdatingPositionalEvent updateEv = (UpdatingPositionalEvent)evnt;
                    Integer pRemove = updateEv.getRemovingItemPosition();
                    if (!BasicEventList.eq(pRemove, pAdded = updateEv.getAddingItemPosition())) {
                        BasicEventList.logWarning("updating position event - removing pos({0}) != adding pos({1})", new Object[]{pRemove, pAdded});
                    }
                    Object adding = updateEv.getAddingItem();
                    Object removing = updateEv.getRemovingItem();
                    if (fn != null) {
                        fn.apply(pAdded, removing, adding);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onUpdating(Func3<Object, Integer, E, E> fn) {
        return this.onUpdating(fn, false);
    }

    @Override
    public Closeable onInserted(Func3<Object, Integer, E, E> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onInserted(fn, false);
    }

    @Override
    public Closeable onInserted(final Func3<Object, Integer, E, E> fn, boolean weak) {
        return this.addEventListListener(new EventListListener<E>(){

            @Override
            public void listItemsChanged(Object evnt) {
                if (evnt instanceof AddedPositionalEvent) {
                    AddedPositionalEvent ev = (AddedPositionalEvent)evnt;
                    Integer pos = ev.getAddedItemPosition();
                    if (pos == null) {
                        BasicEventList.logWarning("added position event - added item pos({0}) is null", new Object[]{pos});
                    }
                    Object eAdded = ev.getAddedItem();
                    if (fn != null) {
                        fn.apply(pos, null, eAdded);
                    }
                } else if (evnt instanceof AddedEvent) {
                    AddedEvent ev = (AddedEvent)evnt;
                    Object eAdded = ev.getAddedItem();
                    if (fn != null) {
                        fn.apply(null, null, eAdded);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onInserting(final Func3<Object, Integer, E, E> fn, boolean weak) {
        return this.addEventListListener(new EventListListener<E>(){

            @Override
            public void listItemsChanged(Object evnt) {
                if (evnt instanceof AddingPositionalEvent) {
                    AddingPositionalEvent ev = (AddingPositionalEvent)evnt;
                    Integer pos = ev.getAddingItemPosition();
                    if (pos == null) {
                        BasicEventList.logWarning("adding position event - adding item pos({0}) is null", new Object[]{pos});
                    }
                    Object eadding = ev.getAddingItem();
                    if (fn != null) {
                        fn.apply(pos, null, eadding);
                    }
                } else if (evnt instanceof AddingEvent) {
                    AddingEvent ev = (AddingEvent)evnt;
                    Object eadding = ev.getAddingItem();
                    if (fn != null) {
                        fn.apply(null, null, eadding);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onInserting(Func3<Object, Integer, E, E> fn) {
        return this.onInserting(fn, false);
    }

    @Override
    public Closeable onDeleted(Func3<Object, Integer, E, E> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onDeleted(fn, false);
    }

    @Override
    public Closeable onDeleted(final Func3<Object, Integer, E, E> fn, boolean weak) {
        return this.addEventListListener(new EventListListener<E>(){

            @Override
            public void listItemsChanged(Object evnt) {
                if (evnt instanceof RemovedPositionalEvent) {
                    RemovedPositionalEvent ev = (RemovedPositionalEvent)evnt;
                    Integer pos = ev.getRemovedItemPosition();
                    if (pos == null) {
                        BasicEventList.logWarning("removed position event - removed item pos({0}) is null", new Object[]{pos});
                    }
                    Object eDeleted = ev.getRemovedItem();
                    if (fn != null) {
                        fn.apply(pos, eDeleted, null);
                    }
                } else if (evnt instanceof RemovedEvent) {
                    RemovedEvent ev = (RemovedEvent)evnt;
                    Object eDeleted = ev.getRemovedItem();
                    if (fn != null) {
                        fn.apply(null, eDeleted, null);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onDeleting(final Func3<Object, Integer, E, E> fn, boolean weak) {
        return this.addEventListListener(new EventListListener<E>(){

            @Override
            public void listItemsChanged(Object evnt) {
                if (evnt instanceof RemovingPositionalEvent) {
                    RemovingPositionalEvent ev = (RemovingPositionalEvent)evnt;
                    Integer pos = ev.getRemovingItemPosition();
                    if (pos == null) {
                        BasicEventList.logWarning("removing position event - removing item pos({0}) is null", new Object[]{pos});
                    }
                    Object edeleting = ev.getRemovingItem();
                    if (fn != null) {
                        fn.apply(pos, edeleting, null);
                    }
                } else if (evnt instanceof RemovingEvent) {
                    RemovingEvent ev = (RemovingEvent)evnt;
                    Object edeleting = ev.getRemovingItem();
                    if (fn != null) {
                        fn.apply(null, edeleting, null);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onDeleting(Func3<Object, Integer, E, E> fn) {
        return this.onDeleting(fn, false);
    }

    protected Object lockRun(Func0 run) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        Object r = run.apply();
        return r;
    }

    protected Object lockRun(Func0 run, LockMethod method) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        return this.lockRun(run);
    }

    @Override
    public boolean add(final E e) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.add0(e);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("add", true));
        this.fireQueueEvents();
        return res;
    }

    protected boolean add0(E e) {
        AddingEvent<E> insenv1 = new AddingEvent<E>(e, this);
        this.addEventToQueue(insenv1);
        this.fireQueueEvents();
        boolean res = super.add(e);
        if (res) {
            AddedEvent<E> insenv2 = new AddedEvent<E>(e, this);
            this.addEventToQueue(insenv2);
        }
        return res;
    }

    @Override
    public void add(final int index, final E element) {
        Func0 fn = new Func0(){

            public Object apply() {
                BasicEventList.this.add0(index, element);
                return null;
            }
        };
        this.lockRun(fn, new LockMethod("add", true));
        this.fireQueueEvents();
    }

    protected void add0(int index, E element) {
        AddingPositionalEvent<E> insEvent1 = new AddingPositionalEvent<E>(element, this, index);
        this.addEventToQueue(insEvent1);
        this.fireQueueEvents();
        super.add(index, element);
        AddedPositionalEvent<E> insEvent2 = new AddedPositionalEvent<E>(element, this, index);
        this.addEventToQueue(insEvent2);
    }

    @Override
    public boolean addAll(final Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException("c==null");
        }
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.addAll0(c);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("addAll", true));
        this.fireQueueEvents();
        return res;
    }

    protected boolean addAll0(Collection<? extends E> c) {
        boolean res = false;
        for (E e : c) {
            boolean r = this.add0(e);
            res = r ? r : res;
        }
        return res;
    }

    @Override
    public boolean addAll(final int index, final Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException("c==null");
        }
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.addAll0(index, c);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("addAll", true));
        this.fireQueueEvents();
        return res;
    }

    protected boolean addAll0(int index, Collection<? extends E> c) {
        boolean res = false;
        int idx = index;
        for (E e : c) {
            this.add0(idx, e);
            ++idx;
            res = true;
        }
        return res;
    }

    @Override
    public void clear() {
        Func0 fn = new Func0(){

            public Object apply() {
                BasicEventList.this.clear0();
                return null;
            }
        };
        this.lockRun(fn, new LockMethod("clear", true));
        this.fireQueueEvents();
    }

    protected void clear0() {
        int i;
        Object[] items = super.toArray();
        for (i = items.length - 1; i >= 0; --i) {
            this.addEventToQueue(new RemovingPositionalEvent<Object>(items[i], this, i));
            this.fireQueueEvents();
        }
        super.clear();
        for (i = items.length - 1; i >= 0; --i) {
            this.addEventToQueue(new RemovedPositionalEvent<Object>(items[i], this, i));
        }
    }

    @Override
    public boolean remove(final Object o) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.remove0(o);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("remove", true));
        this.fireQueueEvents();
        return res;
    }

    protected boolean remove0(Object o) {
        boolean res;
        if (super.contains(o)) {
            this.addEventToQueue(new RemovingEvent<Object>(o, this));
            this.fireQueueEvents();
        }
        if (res = super.remove(o)) {
            this.addEventToQueue(new RemovedEvent<Object>(o, this));
        }
        return res;
    }

    @Override
    public E remove(final int index) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.remove0(index);
            }
        };
        Object item = this.lockRun(fn, new LockMethod("remove", true));
        this.fireQueueEvents();
        return (E)item;
    }

    protected E remove0(int index) {
        this.addEventToQueue(new RemovingPositionalEvent<E>(this.get(index), this, index));
        this.fireQueueEvents();
        Object item = super.remove(index);
        this.addEventToQueue(new RemovedPositionalEvent(item, this, index));
        return item;
    }

    @Override
    public boolean removeAll(final Collection<?> c) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.removeAll0(c);
            }
        };
        boolean modified = (Boolean)this.lockRun(fn, new LockMethod("removeAll", true));
        this.fireQueueEvents();
        return modified;
    }

    protected boolean removeAll0(Collection<?> c) {
        int cnt = 0;
        for (Object o : c) {
            while (this.remove0(o)) {
                ++cnt;
            }
        }
        return cnt > 0;
    }

    @Override
    public boolean retainAll(final Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.retainAll0(c);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("retainAll", true));
        this.fireQueueEvents();
        return res;
    }

    protected boolean retainAll0(Collection<?> c) {
        Object[] beforeItems = super.toArray();
        for (int i = 0; i < beforeItems.length; ++i) {
            Object beforeItem = beforeItems[i];
            if (c.contains(beforeItem)) continue;
            this.addEventToQueue(new RemovingPositionalEvent<Object>(beforeItem, this, i));
            this.fireQueueEvents();
        }
        boolean res = super.retainAll(c);
        Object[] afterItems = super.toArray();
        if (res) {
            TreeSet<Pair<Object, Integer>> dels = new TreeSet<Pair<Object, Integer>>(new Comparator<Pair<Object, Integer>>(){

                @Override
                public int compare(Pair<Object, Integer> o1, Pair<Object, Integer> o2) {
                    return -o1.B().compareTo(o2.B());
                }
            });
            int biIndex = -1;
            for (Object bi : beforeItems) {
                ++biIndex;
                boolean found = false;
                for (Object ai : afterItems) {
                    if (bi != ai) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                dels.add(new BasicPair<Object, Integer>(bi, biIndex));
            }
            for (Pair pair : dels) {
                this.addEventToQueue(new RemovedPositionalEvent(pair.A(), this, (Integer)pair.B()));
            }
        }
        return res;
    }

    @Override
    public E set(final int index, final E element) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.set0(index, element);
            }
        };
        Object deleted = this.lockRun(fn, new LockMethod("set", true));
        this.fireQueueEvents();
        return (E)deleted;
    }

    protected E set0(int index, E element) {
        Object exists = super.get(index);
        this.addEventToQueue(new UpdatingPositionalEvent(exists, element, this, index));
        this.fireQueueEvents();
        E deleted = super.set(index, element);
        this.addEventToQueue(new UpdatedPositionalEvent<E>(deleted, element, this, index));
        return deleted;
    }

    @Override
    public Iterator<E> iterator() {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.iterator0();
            }
        };
        Iterator itr = (Iterator)this.lockRun(fn, new LockMethod("iterator", false));
        this.fireQueueEvents();
        return itr;
    }

    protected Iterator<E> iterator0() {
        BasicEventList f_elist = this;
        Iterator<E> f_itr = this.getWrappedList().iterator();
        return new BasicIterator<E>(f_elist, f_itr);
    }

    @Override
    public ListIterator<E> listIterator() {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.listIterator0();
            }
        };
        ListIterator itr = (ListIterator)this.lockRun(fn, new LockMethod("listIterator", false));
        this.fireQueueEvents();
        return itr;
    }

    protected ListIterator<E> listIterator0() {
        return new BasicEventListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.listIterator0(index);
            }
        };
        ListIterator li = (ListIterator)this.lockRun(fn, new LockMethod("listIterator", false));
        this.fireQueueEvents();
        return li;
    }

    protected ListIterator<E> listIterator0(int index) {
        return new BasicEventListIterator(this, index);
    }

    @Override
    public List<E> subList(final int fromIndex, final int toIndexExclusive) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.this.subList0(fromIndex, toIndexExclusive);
            }
        };
        List li = (List)this.lockRun(fn, new LockMethod("subList", false));
        this.fireQueueEvents();
        return li;
    }

    protected List<E> subList0(int fromIndex, int toIndexExclusive) {
        return new SubList(this, fromIndex, toIndexExclusive);
    }

    @Override
    public <T> T[] toArray(final T[] a) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.toArray(a);
            }
        };
        Object[] res = (Object[])this.lockRun(fn, new LockMethod("toArray", false));
        return res;
    }

    @Override
    public Object[] toArray() {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.toArray();
            }
        };
        Object[] res = (Object[])this.lockRun(fn, new LockMethod("toArray", false));
        return res;
    }

    @Override
    public int size() {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.size();
            }
        };
        int res = (Integer)this.lockRun(fn, new LockMethod("size", false));
        return res;
    }

    @Override
    public int lastIndexOf(final Object o) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.lastIndexOf(o);
            }
        };
        int res = (Integer)this.lockRun(fn, new LockMethod("lastIndexOf", false));
        return res;
    }

    @Override
    public boolean isEmpty() {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.isEmpty();
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("isEmpty", false));
        return res;
    }

    @Override
    public int indexOf(final Object o) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.indexOf(o);
            }
        };
        int res = (Integer)this.lockRun(fn, new LockMethod("indexOf", false));
        return res;
    }

    @Override
    public E get(final int index) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.get(index);
            }
        };
        Object res = this.lockRun(fn, new LockMethod("get", false));
        return (E)res;
    }

    @Override
    public boolean containsAll(final Collection<?> c) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.containsAll(c);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("containsAll", false));
        return res;
    }

    @Override
    public boolean contains(final Object o) {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.contains(o);
            }
        };
        boolean res = (Boolean)this.lockRun(fn, new LockMethod("contains", false));
        return res;
    }

    @Override
    protected synchronized void setWrappedList(final List<E> list) {
        Func0 fn = new Func0(){

            public Object apply() {
                BasicEventList.super.setWrappedList(list);
                return null;
            }
        };
        this.lockRun(fn, new LockMethod("setWrappedList", true));
        this.fireQueueEvents();
    }

    @Override
    public synchronized List<E> getWrappedList() {
        Func0 fn = new Func0(){

            public Object apply() {
                return BasicEventList.super.getWrappedList();
            }
        };
        List res = (List)this.lockRun(fn, new LockMethod("getWrappedList", false));
        return res;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

