/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.list;

import java.io.Closeable;
import java.io.IOException;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.list.BasicEventList;

public class BasicEventListIterator<E>
implements ListIterator<E>,
Closeable {
    protected BasicEventList<E> elist = null;
    protected int position = -1;
    protected boolean closed = false;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(BasicEventListIterator.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(BasicEventListIterator.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(BasicEventListIterator.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(BasicEventListIterator.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(BasicEventListIterator.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(BasicEventListIterator.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(BasicEventListIterator.class.getName()).log(Level.SEVERE, null, ex);
    }

    public BasicEventListIterator(BasicEventList<E> elist) {
        if (elist == null) {
            throw new IllegalArgumentException("elist==null");
        }
        this.elist = elist;
        this.position = this.getBeginPosition();
    }

    public BasicEventListIterator(BasicEventList<E> elist, int initialIndex) {
        if (elist == null) {
            throw new IllegalArgumentException("elist==null");
        }
        this.elist = elist;
        this.position = initialIndex;
        this.checkPositionBounds();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        int nidx = this.nextIndex();
        return this.indexInList(nidx);
    }

    @Override
    public E next() {
        if (this.closed) {
            return null;
        }
        this.position = this.nextIndex();
        if (this.indexInList(this.position)) {
            return this.elist.get(this.position);
        }
        return null;
    }

    @Override
    public boolean hasPrevious() {
        if (this.closed) {
            return false;
        }
        int nidx = this.previousIndex();
        return this.indexInList(nidx);
    }

    @Override
    public E previous() {
        if (this.closed) {
            return null;
        }
        this.position = this.previousIndex();
        if (this.indexInList(this.position)) {
            return this.elist.get(this.position);
        }
        return null;
    }

    protected void checkPositionBounds() {
        if (this.closed) {
            return;
        }
        int nmin = this.getBeginPosition();
        int nmax = this.getEndPosition();
        if (this.position > nmax && this.isLimitNextPosition()) {
            this.position = nmax;
        }
        if (this.position < nmin && this.isLimitPreviousPosition()) {
            this.position = nmin;
        }
    }

    protected boolean positionInBounds(int idx) {
        if (this.closed) {
            return false;
        }
        if (idx <= this.getBeginPosition()) {
            return false;
        }
        return idx < this.getEndPosition();
    }

    protected boolean indexInList(int idx) {
        if (this.closed) {
            return false;
        }
        if (idx < 0) {
            return false;
        }
        return idx < this.elist.size();
    }

    protected int getEndPosition() {
        if (this.closed) {
            return -100;
        }
        return this.elist.size();
    }

    protected boolean isLimitNextPosition() {
        return true;
    }

    @Override
    public int nextIndex() {
        if (this.closed) {
            return -100;
        }
        int npos = this.position + 1;
        int endidx = this.getEndPosition();
        if (npos > endidx && this.isLimitNextPosition()) {
            npos = endidx;
        }
        return npos;
    }

    protected int getBeginPosition() {
        if (this.closed) {
            return -100;
        }
        return -1;
    }

    protected boolean isLimitPreviousPosition() {
        return true;
    }

    @Override
    public int previousIndex() {
        if (this.closed) {
            return -100;
        }
        int npos = this.position - 1;
        int bidx = this.getBeginPosition();
        if (npos < bidx && this.isLimitPreviousPosition()) {
            npos = bidx;
        }
        return npos;
    }

    @Override
    public void remove() {
        if (this.closed) {
            return;
        }
        if (this.indexInList(this.position)) {
            this.elist.remove(this.position);
        }
        this.checkPositionBounds();
    }

    @Override
    public void set(E e) {
        if (this.closed) {
            return;
        }
        if (this.indexInList(this.position)) {
            this.elist.set(this.position, e);
        }
    }

    protected int getFirstIndex() {
        return 0;
    }

    @Override
    public void add(E e) {
        if (this.closed) {
            return;
        }
        if (this.indexInList(this.position)) {
            this.elist.add(this.position, e);
        } else if (this.position <= this.getBeginPosition()) {
            int fidx = this.getFirstIndex();
            this.elist.add(fidx, e);
            this.position = fidx;
        } else if (this.position >= this.getEndPosition()) {
            this.elist.add(e);
            this.position = this.getEndPosition();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.elist != null) {
            this.elist = null;
        }
    }
}

