/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.list;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.list.BasicEventList;

public class SubList<E>
extends AbstractList<E>
implements List<E> {
    protected BasicEventList<E> list = null;
    protected int size = 0;
    protected int offset = 0;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(SubList.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(SubList.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(SubList.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(SubList.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(SubList.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(SubList.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(SubList.class.getName()).log(Level.SEVERE, null, ex);
    }

    public SubList(BasicEventList<E> list, int beginIndex, int endIndexExclusive) {
        if (list == null) {
            throw new IllegalArgumentException("list==null");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex<0");
        }
        if (endIndexExclusive > list.size()) {
            throw new IllegalArgumentException("endIndexExclusive>list.size()");
        }
        if (beginIndex > endIndexExclusive) {
            throw new IllegalArgumentException("beginIndex>endIndexExclusive");
        }
        this.list = list;
        this.offset = beginIndex;
        this.size = endIndexExclusive - beginIndex;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        int ss;
        int ti;
        for (int i = 0; i < this.size && (ti = i + this.offset) < (ss = this.list.size()); ++i) {
            E srcO = this.list.get(ti);
            if (o == null && srcO == null) {
                return true;
            }
            if (o == null || srcO == null || !o.equals(srcO)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        int ss;
        int ti;
        Object[] a = new Object[]{};
        for (int i = 0; i < this.size && (ti = i + this.offset) < (ss = this.list.size()); ++i) {
            E srcO = this.list.get(ti);
            a = Arrays.copyOf(a, a.length + 1);
            a[a.length - 1] = srcO;
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int ss;
        int ti;
        for (int i = 0; i < this.size && (ti = i + this.offset) < (ss = this.list.size()); ++i) {
            E srcO = this.list.get(ti);
            a = Arrays.copyOf(a, a.length + 1);
            a[a.length - 1] = srcO;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        int pos = this.offset + this.size;
        int ss = this.list.size();
        if (pos >= ss) {
            boolean succ = this.list.add(e);
            if (succ) {
                ++this.size;
            }
            return succ;
        }
        this.list.add(pos, e);
        ++this.size;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = false;
        for (E e : c) {
            boolean r = this.add(e);
            added = r ? r : added;
        }
        return added;
    }

    @Override
    public void clear() {
        if (this.size <= 0) {
            return;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            int ti = i + this.offset;
            int s = this.list.size();
            if (ti < 0 || ti >= s) continue;
            this.list.remove(ti);
        }
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.size) {
            return null;
        }
        int ti = this.offset + index;
        int s = this.list.size();
        if (ti < 0 || ti >= s) {
            return null;
        }
        return this.list.get(ti);
    }

    @Override
    public E set(int index, E e) {
        if (index < 0) {
            return null;
        }
        if (index >= this.size) {
            return null;
        }
        int ti = this.offset + index;
        int s = this.list.size();
        if (ti < 0 || ti >= s) {
            return null;
        }
        return this.list.set(ti, e);
    }

    @Override
    public void add(int index, E e) {
        int ss;
        int pos;
        if (index < 0) {
            index = 0;
        }
        if (index > this.size) {
            index = this.size;
        }
        if ((pos = this.offset + this.size + index) >= (ss = this.list.size())) {
            boolean succ = this.list.add(e);
            if (succ) {
                ++this.size;
            }
        } else {
            this.list.add(pos, e);
            ++this.size;
        }
    }

    @Override
    public E remove(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.size) {
            return null;
        }
        if (this.size <= 0) {
            return null;
        }
        int ti = this.offset + index;
        int s = this.list.size();
        if (ti < 0 || ti >= s) {
            return null;
        }
        E r = this.list.remove(ti);
        --this.size;
        return r;
    }

    @Override
    public int indexOf(Object o) {
        int ss;
        int ti;
        for (int i = 0; i < this.size && (ti = i + this.offset) < (ss = this.list.size()); ++i) {
            E srcO = this.list.get(ti);
            if (o == null && srcO == null) {
                return i;
            }
            if (o == null || srcO == null || !o.equals(srcO)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size - 1; i >= 0; --i) {
            int ti = i + this.offset;
            int ss = this.list.size();
            if (ti >= ss) continue;
            E srcO = this.list.get(ti);
            if (o == null && srcO == null) {
                return i;
            }
            if (o == null || srcO == null || !o.equals(srcO)) continue;
            return i;
        }
        return -1;
    }
}

