/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.map;

import java.util.LinkedHashMap;
import java.util.Map;

public class ICaseStringMap<V>
extends LinkedHashMap<String, V> {
    protected boolean ignoreCase = true;

    public ICaseStringMap() {
    }

    public ICaseStringMap(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return super.containsKey(key);
        }
        if (this.isIgnoreCase()) {
            if (key instanceof String) {
                key = ((String)key).toLowerCase();
            }
            return super.containsKey(key);
        }
        return super.containsKey(key);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return super.get(key);
        }
        if (this.isIgnoreCase()) {
            if (key instanceof String) {
                key = ((String)key).toLowerCase();
            }
            return super.get(key);
        }
        return super.get(key);
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            return super.get(key);
        }
        if (this.isIgnoreCase()) {
            if (key instanceof String) {
                key = key.toLowerCase();
            }
            return super.put(key, value);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        if (m == null) {
            super.putAll(m);
            return;
        }
        if (this.isIgnoreCase()) {
            for (String string : m.keySet()) {
                this.put(string, m.get(string));
            }
        } else {
            super.putAll(m);
            return;
        }
    }
}

