/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PrefixStringMap<T>
implements Map<String, T> {
    protected Map<String, T> wrappedMap = null;
    protected String prefix = null;

    public PrefixStringMap(String prefix, Map<String, T> wrappedMap) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix==null");
        }
        if (wrappedMap == null) {
            throw new IllegalArgumentException("wrappedMap==null");
        }
        this.wrappedMap = wrappedMap;
        this.prefix = prefix;
    }

    public Map<String, T> getWrappedMap() {
        return this.wrappedMap;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Collection<T> values() {
        ArrayList<T> l = new ArrayList<T>();
        for (String k : this.keySet()) {
            if (k == null) continue;
            String key = this.prefix + k;
            T v = this.wrappedMap.get(key);
            l.add(v);
        }
        return l;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public T remove(Object key) {
        if (key == null) {
            return null;
        }
        String k = key == null ? null : this.prefix + key.toString();
        return this.wrappedMap.remove(k);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        for (String string : m.keySet()) {
            if (string == null) continue;
            String k = this.prefix + string;
            this.wrappedMap.put(k, m.get(string));
        }
    }

    @Override
    public T put(String key, T value) {
        if (key == null) {
            return null;
        }
        String k = key == null ? null : this.prefix + key;
        return this.wrappedMap.put(k, value);
    }

    @Override
    public Set<String> keySet() {
        TreeSet<String> keys = new TreeSet<String>();
        for (String key : this.wrappedMap.keySet()) {
            if (key == null || !key.startsWith(this.prefix)) continue;
            String k = key.length() == this.prefix.length() ? "" : key.substring(this.prefix.length());
            keys.add(k);
        }
        return keys;
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public T get(Object key) {
        String k = key == null ? null : this.prefix + key;
        return this.wrappedMap.get(k);
    }

    protected Map.Entry<String, T> createEntry(final String key, T value) {
        return new Map.Entry<String, T>(){

            @Override
            public String getKey() {
                if (key != null && key.startsWith(PrefixStringMap.this.prefix)) {
                    if (key.length() == PrefixStringMap.this.prefix.length()) {
                        return "";
                    }
                    return key.substring(PrefixStringMap.this.prefix.length());
                }
                return key;
            }

            @Override
            public T getValue() {
                return PrefixStringMap.this.wrappedMap.get(key);
            }

            @Override
            public T setValue(T value) {
                return PrefixStringMap.this.wrappedMap.put(key, value);
            }
        };
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        HashSet<Map.Entry<String, T>> r = new HashSet<Map.Entry<String, T>>();
        for (Map.Entry<String, T> e : this.wrappedMap.entrySet()) {
            String key = e.getKey();
            T value = e.getValue();
            if (key == null || !key.startsWith(this.prefix)) continue;
            r.add(this.createEntry(key, value));
        }
        return r;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public boolean containsKey(Object key) {
        String k = key == null ? null : this.prefix + key.toString();
        return this.wrappedMap.containsKey(k);
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }
}

