/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.tree.BasicTreeNodeEvent;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeAddingEvent;
import xyz.cofe.collection.tree.TreeNodePopupEvent;
import xyz.cofe.collection.tree.TreeNodePopupEventDef;

public class TreeNodeAdding<Node extends TreeNode>
extends BasicTreeNodeEvent<Node>
implements TreeNodeAddingEvent<Node>,
TreeNodePopupEvent<Node> {
    private static final Logger logger = Logger.getLogger(TreeNodeAdding.class.getName());
    protected final TreeNodePopupEventDef popupDef = new TreeNodePopupEventDef(this);
    protected TreeNode<Node> parent;
    protected TreeNode<Node> child;
    protected Integer childIndex;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = TreeNodeAdding.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = TreeNodeAdding.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = TreeNodeAdding.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = TreeNodeAdding.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = TreeNodeAdding.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = TreeNodeAdding.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodeAdding.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodeAdding.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodeAdding.class.getName(), method);
    }

    public TreeNodeAdding(TreeNode<Node> source) {
        super(source);
    }

    public TreeNodeAdding(TreeNode<Node> parent, TreeNode<Node> child, Integer childIndex) {
        super(child);
        this.child = child;
        this.parent = parent;
        this.childIndex = childIndex;
    }

    @Override
    public List<TreeNode<Node>> getPopupPath() {
        return this.popupDef.getPopupPath();
    }

    @Override
    public TreeNode<Node> getParent() {
        return this.parent;
    }

    @Override
    public TreeNode<Node> getChild() {
        return this.child;
    }

    @Override
    public Integer getChildIndex() {
        return this.childIndex;
    }
}

