/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeAdded;
import xyz.cofe.collection.tree.TreeNodeAdding;
import xyz.cofe.collection.tree.TreeNodeEvent;
import xyz.cofe.collection.tree.TreeNodeNotifier;
import xyz.cofe.collection.tree.TreeNodePopupEvent;
import xyz.cofe.collection.tree.TreeNodeRemoved;
import xyz.cofe.collection.tree.TreeNodeRemoving;

public class TreeNodeNotifierDef<Node extends TreeNode> {
    private static final Logger logger = Logger.getLogger(TreeNodeNotifierDef.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final TreeNodeNotifier<Node> self;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodeNotifierDef.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodeNotifierDef.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodeNotifierDef.class.getName(), method, result);
    }

    public TreeNodeNotifierDef(TreeNodeNotifier<Node> self) {
        this.self = self;
    }

    public void popup(TreeNodeEvent ev) {
        if (ev instanceof TreeNodePopupEvent) {
            TreeNodePopupEvent tnpe = (TreeNodePopupEvent)ev;
            List l = tnpe.getPopupPath();
            if (l != null) {
                int cycles = 0;
                for (TreeNode o : l) {
                    if (this.self != o) continue;
                    ++cycles;
                }
                if (cycles > 1) {
                    throw new Error("cycle detected");
                }
            }
            l.add(this.self);
            this.self.fireTreeNodeEvent(ev);
            Object pnode = this.self.getParent();
            if (pnode instanceof TreeNodeNotifier) {
                ((TreeNodeNotifier)pnode).popup(ev);
            }
        }
    }

    public void onTreeNodeAdded(Integer index, Node child) {
        TreeNodeAdded<Node> ev = new TreeNodeAdded<Node>(this.self, child, index);
        ev.getPopupPath().add((TreeNode<Node>)child);
        this.popup(ev);
    }

    public void onTreeNodeAdding(Integer index, Node child) {
        TreeNodeAdding<Node> ev = new TreeNodeAdding<Node>(this.self, child, index);
        ev.getPopupPath().add((TreeNode<Node>)child);
        this.popup(ev);
    }

    public void onTreeNodeRemoved(Integer index, Node child) {
        TreeNodeRemoved<Node> ev = new TreeNodeRemoved<Node>(this.self, child, index);
        ev.getPopupPath().add((TreeNode<Node>)child);
        this.popup(ev);
    }

    public void onTreeNodeRemoving(Integer index, Node child) {
        TreeNodeRemoving<Node> ev = new TreeNodeRemoving<Node>(this.self, child, index);
        ev.getPopupPath().add((TreeNode<Node>)child);
        this.popup(ev);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

